/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainRealm {
    static final Logger logger = LoggerFactory.getLogger(DomainRealm.class);
    public static final String[] DOMAINS = new String[]{"prod", "desktop", "test", "preprod"};
    public static final String[] REALMS = new String[]{"us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-west-2", "sa-east-1", "ap-southeast-2", "us-gov-west-1", "cn-north-1", "us-iso-east-1"};
    public final String domain;
    public final String realm;

    public DomainRealm(String domain, String realm) {
        this.domain = domain;
        this.realm = realm;
    }

    public DomainRealm(long jobflowIdRaw) {
        int bits = (int)((jobflowIdRaw & 0x7F00000000L) >> 32);
        int realmId = bits >> 3;
        int domainId = bits & 7;
        if (realmId >= REALMS.length) {
            throw new RuntimeException("Invalid realm id " + realmId);
        }
        if (domainId >= DOMAINS.length) {
            throw new RuntimeException("Invalid domain id " + domainId);
        }
        this.domain = DOMAINS[domainId];
        this.realm = REALMS[realmId];
    }

    public DomainRealm(String jobflowId) {
        this(DomainRealm.decryptJobFlowIdReflect(jobflowId));
    }

    public static long decryptJobFlowIdReflect(String jidstr) {
        String className = "amazon.security.AmzUid";
        try {
            Class<?> clazz = Class.forName("amazon.security.AmzUid");
            Method method = clazz.getMethod("decryptSequenceID", String.class, String.class);
            long output = (Long)method.invoke(null, jidstr, "j-");
            return output;
        }
        catch (Exception ex) {
            logger.info("decryptJobFlowIdReflect error: {}", (Object)ex.getMessage());
            throw new RuntimeException(ex);
        }
    }
}

