/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.metrics.ClientUtil;
import amazon.emr.metrics.DomainRealm;
import amazon.emr.metrics.S3Path;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsConfig {
    static Logger logger = LoggerFactory.getLogger(MetricsConfig.class);
    public static final String configRoot = "/mnt/var/run/metrics-server/";
    public static String emrMetricsLog4jFileName = "emr-metrics-log4j.config";
    public static String emrMetricsLog4jFilePath = "/mnt/var/run/metrics-server/" + emrMetricsLog4jFileName;
    public static final String HDFS_ROOT_DIR = "hdfs:///mnt/var/em/";
    public static final String LOCAL_ROOT_DIR = "/mnt/var/em/";
    public static final String LOCAL_CONFIG_FILE = "/mnt/var/em/emr-metrics-config.bin";
    public static final String HDFS_CONFIG_FILE = "hdfs:///mnt/var/em/emr-metrics-config.bin";
    public static final String DROPBOX_ROOT_DIR = "/mnt/var/em/dropbox/";
    public static final String PRODUCERS_ROOT_DIR = "/mnt/var/em/producers/";
    public static final String SERVER_HEARTBEAT_FILE = "/mnt/var/em/server-heartbeat";
    public String dropboxRootDir = "/mnt/var/em/dropbox/";
    public String localConfigFile = "/mnt/var/em/emr-metrics-config.bin";
    public String hdfsConfigFile = "hdfs:///mnt/var/em/emr-metrics-config.bin";
    public String producersRootDir = "/mnt/var/em/producers/";
    public static final int SAVER_PERIOD_SEC_DEFAULT = 60;
    public static final int MAX_KEY_LENGTH = 48;
    public static final int MAX_CONTEXT_LENGTH = 64;
    public static boolean disableMetricSaver = false;
    public static boolean withinEmrJobFlow = true;
    public static long saverLockDelayMeasureWindow = 0L;
    public int saverPeriodSec = 60;
    public static int systemProducerPeriodSec = 10;
    public boolean disableClusterEngine = false;
    public int instanceEngineCycleSec = 60;
    public int clusterEngineCycleSec = 60;
    public int maxMemoryMb = 3072;
    public int maxInstanceCount = 500;
    public static long retentionPeriodMills = 604800000L;
    public static final int MAX_LOCAL_FILES = 10000;
    public static final int MAX_HDFS_FILES = 100000;
    public static List<String> traceids = null;
    public final boolean hdfs;
    public final String rootDir;
    public final String rawDir;
    public final String aggDir;
    public final String aggChunkIndexFile;
    public final String rawChunkIndexFilePrefix = "raw_chunk_index_";
    public final long rawChunkIndexFileSize = 0x8000000L;
    public final String engineStateFile;
    public final String s3UploadStateFile;
    public String s3bucket;
    public String s3root;
    public String s3rawDir;
    public String s3aggDir;
    public String s3rawChunkIndexFile;
    public String s3aggChunkIndexFile;
    public final String emrMetricsConfigFile;
    public final int LateArrivalWaitPeriodMilliSec = 120000;
    public String instanceId;
    public String jobFlowId;
    public final String masterInstanceId;
    public boolean readFromS3 = false;
    public final String hostname;
    public String processName;
    public static CACHE_LEVEL outputCacheLevel = CACHE_LEVEL.MEDIUM;

    public MetricsConfig() {
        this(false, null);
    }

    public MetricsConfig(boolean useHDFS) {
        this(useHDFS, null);
    }

    public MetricsConfig(boolean useHDFS, String instanceIdToUse) {
        this(useHDFS ? HDFS_ROOT_DIR : LOCAL_ROOT_DIR, instanceIdToUse);
    }

    public MetricsConfig(String rootDir, String instanceIdToUse) {
        this.hdfs = rootDir.startsWith("hdfs:/");
        this.rootDir = rootDir;
        this.rawDir = MetricsConfig.CombinePath(rootDir, "raw");
        this.aggDir = MetricsConfig.CombinePath(rootDir, "agg");
        this.aggChunkIndexFile = MetricsConfig.CombinePath(rootDir, "agg_chunk_index.bin");
        this.engineStateFile = MetricsConfig.CombinePath(rootDir, "engine_state.bin");
        this.s3UploadStateFile = MetricsConfig.CombinePath(rootDir, "s3_upload_state.bin");
        this.emrMetricsConfigFile = MetricsConfig.CombinePath(rootDir, "emr-metrics-config.bin");
        this.instanceId = MetricsConfig.getInstanceId(instanceIdToUse);
        this.hostname = ClientUtil.getHostName();
        String s1 = "j-NOTAJOBFLOW";
        String s2 = this.instanceId;
        EmrInstanceData idata = MetricsConfig.readEmrInstanceData();
        if (idata != null) {
            s1 = idata.jobFlowId;
            s2 = idata.masterInstanceId;
            if (s2 == null) {
                s2 = this.instanceId;
            }
        } else {
            disableMetricSaver = true;
            withinEmrJobFlow = false;
        }
        this.jobFlowId = s1;
        this.masterInstanceId = s2;
        if (this.hostname.endsWith(".amazon.com")) {
            withinEmrJobFlow = false;
        }
        this.s3bucket = "aws157-logs-prod";
        this.s3root = S3Path.getPath(this.s3bucket, this.jobFlowId + "/em");
        this.s3rawDir = S3Path.combine(this.s3root, "raw");
        this.s3aggDir = S3Path.combine(this.s3root, "agg");
        this.processName = ClientUtil.getProcessMainClassName(true);
        if (this.processName == null) {
            this.processName = ClientUtil.getPidStr();
        }
    }

    protected void setReadFromS3(String jidstr) {
        DomainRealm dr = new DomainRealm(jidstr);
        this.s3bucket = ClientUtil.getSysLogS3Bucket(dr.domain, dr.realm);
        this.s3root = String.format("s3://%s/%s/em/", this.s3bucket, jidstr);
        this.s3rawDir = S3Path.combine(this.s3root, "raw");
        this.s3aggDir = S3Path.combine(this.s3root, "agg");
        this.s3rawChunkIndexFile = S3Path.combine(this.s3rawDir, "chunk_index.bin");
        this.s3aggChunkIndexFile = S3Path.combine(this.s3aggDir, "chunk_index.bin");
        this.jobFlowId = jidstr;
        this.readFromS3 = true;
    }

    public String toString() {
        return String.format("root:%s period:%d instanceId:%s jobflow:%s", this.rootDir, this.saverPeriodSec, this.instanceId, this.jobFlowId);
    }

    static EmrInstanceData readEmrInstanceData() {
        try {
            String extraInstanceDataFile = "/mnt/var/lib/instance-controller/extraInstanceData.json";
            String JobFlowFile = "/mnt/var/lib/info/job-flow.json";
            EmrInstanceData data = new EmrInstanceData();
            if (ClientUtil.fileExists("/mnt/var/lib/info/job-flow.json")) {
                String content = ClientUtil.readFileAsString("/mnt/var/lib/info/job-flow.json");
                JsonParser jsonParser = new JsonParser();
                JsonObject jo = (JsonObject)jsonParser.parse(content);
                data.jobFlowId = jo.get("jobFlowId").getAsString();
                data.masterInstanceId = jo.get("masterInstanceId").getAsString();
                return data;
            }
            if (ClientUtil.fileExists("/mnt/var/lib/instance-controller/extraInstanceData.json")) {
                String content = ClientUtil.readFileAsString("/mnt/var/lib/instance-controller/extraInstanceData.json");
                JsonParser jsonParser = new JsonParser();
                JsonObject jo = (JsonObject)jsonParser.parse(content);
                data.jobFlowId = jo.get("jobFlowId").getAsString();
                JsonElement je = jo.get("masterInstanceId");
                if (je != null) {
                    data.masterInstanceId = je.getAsString();
                }
                return data;
            }
            return null;
        }
        catch (Exception e) {
            logger.info("readEmrInstanceData exception ", (Throwable)e);
            return null;
        }
    }

    private static String getInstanceId(String idToUse) {
        int index;
        if (idToUse == null) {
            idToUse = ClientUtil.getInstanceId();
        }
        if ((index = idToUse.indexOf(58)) >= 0) {
            idToUse = idToUse.substring(0, index);
        }
        if (idToUse.length() > 40) {
            idToUse = idToUse.substring(0, 40);
        }
        return idToUse;
    }

    private static String CombinePath(String dir, String filename) {
        return dir.endsWith("/") ? dir + filename : dir + "/" + filename;
    }

    public static void setLog4jFile(String log4jFile) {
        emrMetricsLog4jFileName = log4jFile;
        emrMetricsLog4jFilePath = configRoot + emrMetricsLog4jFileName;
    }

    static class EmrInstanceData {
        public String jobFlowId;
        public String masterInstanceId;

        EmrInstanceData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CACHE_LEVEL {
        OFF,
        LOW,
        MEDIUM,
        HIGH;

    }
}

