/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import java.io.File;

public class S3Path {
    String s3bucket;
    String s3key;
    String path;
    String basename;
    static final String s3Scheme = "s3://";

    public static String getPath(String bucket, String key) {
        return String.format("%s%s/%s", s3Scheme, bucket, S3Path.trimSlashes(key));
    }

    public static String combine(String path, String child) {
        return String.format("%s/%s", S3Path.trimSlashes(path), child);
    }

    public static S3Path tryParse(String s3path) {
        if (!s3path.startsWith(s3Scheme)) {
            return null;
        }
        int slashIndex = (s3path = s3path.substring(s3Scheme.length())).indexOf(47);
        if (slashIndex <= 0) {
            return null;
        }
        String s3bucket = s3path.substring(0, slashIndex);
        String s3key = S3Path.trimSlashes(s3path.substring(slashIndex + 1));
        if (s3key.length() == 0) {
            return null;
        }
        return new S3Path(s3bucket, s3key);
    }

    public static S3Path parse(String s3path) {
        S3Path r = S3Path.tryParse(s3path);
        if (r == null) {
            throw new RuntimeException("Invalid s3path " + s3path);
        }
        return r;
    }

    public S3Path(String bucket, String key) {
        this.s3bucket = bucket;
        this.s3key = key;
        this.path = S3Path.getPath(bucket, key);
        this.basename = new File(key).getName();
    }

    public static String trimSlashes(String key) {
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        while (key.endsWith("/")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }
}

