/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxConnectionEventListener;
import com.informix.jdbcx.IfxCoreDataSource;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class IfxConnectionPoolDataSource
extends IfxCoreDataSource
implements ConnectionPoolDataSource,
Referenceable {
    private static Properties defProp = null;
    private Set connectionsFromServer = Collections.synchronizedSet(new HashSet());
    private Constructor directReUsableCons = null;
    private boolean isDirect = false;
    private boolean isDirectChecked = false;
    static boolean isPrimaryUp = false;
    static /* synthetic */ Class class$com$informix$jdbcx$IfxConnectionPoolDataSource;
    static /* synthetic */ Class class$com$informix$jdbcx$IfxConnectionPoolDataSourceFactory;

    public void setReUsableCons(Constructor constructor) {
        this.directReUsableCons = constructor;
    }

    public Constructor getReUsableCons() {
        return this.directReUsableCons;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        String string = this.getUser();
        String string2 = this.getPassword();
        if (string == null || string2 == null) {
            throw IfxErrMsg.getLocSQLException((int)-79811, (String)this.getIfxCLIENT_LOCALE());
        }
        return new IfxPooledConnection(string, string2, this);
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return new IfxPooledConnection(string, string2, this);
    }

    public PooledConnection getPooledConnection(String string, String string2, IfxConnectionEventListener ifxConnectionEventListener) throws SQLException {
        IfxPooledConnection ifxPooledConnection = new IfxPooledConnection(string, string2, this);
        ifxPooledConnection.addConnectionEventListener(ifxConnectionEventListener);
        return ifxPooledConnection;
    }

    protected void checkMaxConnections() throws SQLException {
        int n = this.getIfxCPMMaxConnections();
        if (n != -1 && this.connectionsFromServer.size() >= n) {
            throw IfxErrMsg.getLocSQLException((int)-79831, (String)this.getIfxCLIENT_LOCALE());
        }
    }

    protected void addToReferenceList(IfxPooledConnection ifxPooledConnection) {
        this.connectionsFromServer.add(ifxPooledConnection);
    }

    protected void removeFromReferenceList(IfxPooledConnection ifxPooledConnection) {
        this.connectionsFromServer.remove(ifxPooledConnection);
    }

    protected int getConnectionCount() {
        return this.connectionsFromServer.size();
    }

    public Reference getReference() throws NamingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeProperties(byteArrayOutputStream);
            return new Reference((class$com$informix$jdbcx$IfxConnectionPoolDataSource == null ? (class$com$informix$jdbcx$IfxConnectionPoolDataSource = IfxConnectionPoolDataSource.class$("com.informix.jdbcx.IfxConnectionPoolDataSource")) : class$com$informix$jdbcx$IfxConnectionPoolDataSource).getName(), new StringRefAddr("CPDSProperties", ((Object)byteArrayOutputStream).toString()), (class$com$informix$jdbcx$IfxConnectionPoolDataSourceFactory == null ? (class$com$informix$jdbcx$IfxConnectionPoolDataSourceFactory = IfxConnectionPoolDataSource.class$("com.informix.jdbcx.IfxConnectionPoolDataSourceFactory")) : class$com$informix$jdbcx$IfxConnectionPoolDataSourceFactory).getName(), null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setIfxCPMMaxConnections(int n) {
        this.DSProperties.setProperty("IFMX_CPM_MAX_CONNECTIONS", new Integer(n).toString());
    }

    public void setMaxStatements(int n) throws SQLException {
    }

    public int getIfxCPMMaxConnections() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_MAX_CONNECTIONS");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_MAX_CONNECTIONS");
        }
        return Integer.parseInt(this.value);
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public void setIfxCPMInitPoolSize(int n) {
        this.DSProperties.setProperty("IFMX_CPM_INIT_POOLSIZE", new Integer(n).toString());
    }

    public void setInitialPoolSize(int n) {
        this.setIfxCPMInitPoolSize(n);
    }

    public int getIfxCPMInitPoolSize() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_INIT_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_INIT_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getInitialPoolSize() {
        return this.getIfxCPMInitPoolSize();
    }

    public void setIfxCPMMaxPoolSize(int n) {
        this.DSProperties.setProperty("IFMX_CPM_MAX_POOLSIZE", new Integer(n).toString());
    }

    public void setMaxPoolSize(int n) {
        if (n == 0) {
            this.setIfxCPMMaxPoolSize(-1);
        } else {
            this.setIfxCPMMaxPoolSize(n);
        }
    }

    public int getIfxCPMMaxPoolSize() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_MAX_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_MAX_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getMaxPoolSize() {
        int n = this.getIfxCPMMaxPoolSize();
        if (n == -1) {
            return 0;
        }
        return n;
    }

    public void setIfxCPMMinPoolSize(int n) {
        this.DSProperties.setProperty("IFMX_CPM_MIN_POOLSIZE", new Integer(n).toString());
    }

    public void setMinPoolSize(int n) {
        this.setIfxCPMMinPoolSize(n);
    }

    public int getIfxCPMMinPoolSize() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_MIN_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_MIN_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getMinPoolSize() {
        return this.getIfxCPMMinPoolSize();
    }

    public void setIfxCPMMinAgeLimit(long l) {
        this.DSProperties.setProperty("IFMX_CPM_MIN_AGELIMIT", new Long(l).toString());
    }

    public long getIfxCPMMinAgeLimit() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_MIN_AGELIMIT");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_MIN_AGELIMIT");
        }
        return Long.parseLong(this.value);
    }

    public void setIfxCPMAgeLimit(long l) {
        this.DSProperties.setProperty("IFMX_CPM_AGELIMIT", new Long(l).toString());
    }

    public void setMaxIdleTime(int n) {
        if (n == 0) {
            this.setIfxCPMAgeLimit(-1L);
        } else {
            this.setIfxCPMAgeLimit(n);
        }
    }

    public long getIfxCPMAgeLimit() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_AGELIMIT");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_AGELIMIT");
        }
        return Long.parseLong(this.value);
    }

    public int getMaxIdleTime() {
        int n = (int)this.getIfxCPMAgeLimit();
        if (n == -1) {
            return 0;
        }
        return n;
    }

    public void setPropertyCycle(int n) throws SQLException {
    }

    public int getPropertyCycle() throws SQLException {
        this.value = this.DSProperties.getProperty("IFMX_CPM_SERVICE_INTERVAL");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_SERVICE_INTERVAL");
        }
        return Integer.parseInt(this.value);
    }

    public void setIfxCPMServiceInterval(long l) {
        this.DSProperties.setProperty("IFMX_CPM_SERVICE_INTERVAL", new Long(l).toString());
    }

    public long getIfxCPMServiceInterval() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_SERVICE_INTERVAL");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_SERVICE_INTERVAL");
        }
        return Long.parseLong(this.value);
    }

    public void setIfxCPMSwitchHDRPool(boolean bl) {
        this.DSProperties.setProperty("IFMX_CPM_ENABLE_SWITCH_HDR_POOL", new Boolean(bl).toString());
    }

    public boolean getIfxCPMSwitchHDRPool() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_ENABLE_SWITCH_HDR_POOL");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_ENABLE_SWITCH_HDR_POOL");
        }
        return Boolean.valueOf(this.value);
    }

    public boolean checkIsDirect() {
        if (this.isDirectChecked) {
            return this.isDirect;
        }
        String string = this.DSProperties.getProperty("PROTOCOLCLASS");
        if (string != null && string.equalsIgnoreCase("com.informix.jdbc.IfxDirectProtocol")) {
            this.isDirect = true;
        }
        this.isDirectChecked = true;
        return this.isDirect;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defProp = new Properties();
        defProp.setProperty("IFMX_CPM_MAX_CONNECTIONS", "-1");
        defProp.setProperty("IFMX_CPM_INIT_POOLSIZE", "0");
        defProp.setProperty("IFMX_CPM_MAX_POOLSIZE", "50");
        defProp.setProperty("IFMX_CPM_MIN_POOLSIZE", "0");
        defProp.setProperty("IFMX_CPM_MIN_AGELIMIT", "-1");
        defProp.setProperty("IFMX_CPM_AGELIMIT", "-1");
        defProp.setProperty("IFMX_CPM_SERVICE_INTERVAL", "50");
        defProp.setProperty("IFMX_CPM_ENABLE_SWITCH_HDRPOOL", new Boolean(false).toString());
    }
}

