/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import sqlj.codegen.JSClassType;
import sqlj.codegen.TempDecl;
import sqlj.codegen.Util;
import sqlj.codegen.engine.CodegenException;
import sqlj.codegen.engine.Expression;
import sqlj.codegen.engine.FieldDecl;
import sqlj.codegen.engine.Initializer;
import sqlj.codegen.engine.ObjectExpression;
import sqlj.codegen.engine.Statement;
import sqlj.codegen.engine.StatementGroup;
import sqlj.codegen.engine.Streamable;
import sqlj.codegen.engine.Type;
import sqlj.framework.JSClass;
import sqlj.util.ArrayAccessDescriptor;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.FieldAccessDescriptor;
import sqlj.util.OutputContext;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;

class TypedExpression
implements Expression {
    private Expression m_expr;
    private JSClassType m_type;
    private JSClass m_class;
    private String m_name = null;
    private TempDeclFactory m_tempFactory;

    public TypedExpression(Parselet parselet, JSClassType.Factory factory) throws ClassNotFoundException {
        this(TypedExpression.getType(parselet, factory), new ParseletExpression(parselet), TypedExpression.getName(parselet));
        TypeDescriptor typeDescriptor = parselet.getDescriptor();
        if (typeDescriptor instanceof FieldAccessDescriptor) {
            this.m_tempFactory = new FieldTempDecl(this, (FieldAccessDescriptor)typeDescriptor, factory);
        } else if (typeDescriptor instanceof ArrayAccessDescriptor) {
            this.m_tempFactory = new ArrayTempDecl(this, (ArrayAccessDescriptor)typeDescriptor, factory);
        }
    }

    private static JSClassType getType(Parselet parselet, JSClassType.Factory factory) throws ClassNotFoundException {
        JSClass jSClass = ((ExpressionDescriptor)parselet.getDescriptor()).getReflection();
        return factory.getType(jSClass);
    }

    private static String getName(Parselet parselet) throws ClassNotFoundException {
        return ((ExpressionDescriptor)parselet.getDescriptor()).getName();
    }

    public TypedExpression(JSClassType jSClassType, Expression expression, String string) {
        this.m_expr = expression;
        this.m_type = jSClassType;
        this.m_class = this.m_type.toClass();
        this.m_name = string;
        this.m_tempFactory = new BasicTempDecl(this);
    }

    public String getName() {
        return this.m_name;
    }

    public JSClassType getType() {
        return this.m_type;
    }

    public JSClass getJSClass() {
        return this.m_class;
    }

    public void stream(PrintWriter printWriter) throws IOException, CodegenException {
        this.m_expr.stream(printWriter);
    }

    public TempDecl declareTemps(String string, int n) {
        return this.m_tempFactory.declareTemps(string, n);
    }

    private static class ParseletExpression
    implements Expression {
        private Parselet m_parselet;

        ParseletExpression(Parselet parselet) {
            this.m_parselet = parselet;
        }

        public void stream(PrintWriter printWriter) throws IOException, CodegenException {
            if (!this.m_parselet.generate(new OutputContextImpl(printWriter))) {
                throw new CodegenException();
            }
        }

        private static class OutputContextImpl
        implements OutputContext {
            private Writer m_writer;

            OutputContextImpl(Writer writer) {
                this.m_writer = writer;
            }

            public Writer getWriter() {
                return this.m_writer;
            }

            public Writer createWriter(String string) throws IOException {
                throw new IOException("Typed expression unable to create writer");
            }

            public OutputStream createOutputStream(String string) throws IOException {
                throw new IOException("Typed expression unable to create output stream");
            }
        }
    }

    private class ArrayTempDecl
    implements TempDeclFactory {
        private TypedExpression m_arrExpr;
        private TypedExpression m_ndxExpr;
        private TypedExpression m_expr;

        public ArrayTempDecl(TypedExpression typedExpression2, ArrayAccessDescriptor arrayAccessDescriptor, JSClassType.Factory factory) throws ClassNotFoundException {
            this.m_arrExpr = new TypedExpression(arrayAccessDescriptor.getBaseObject(), factory);
            this.m_ndxExpr = new TypedExpression(arrayAccessDescriptor.getArrayIndex(), factory);
            this.m_expr = typedExpression2;
        }

        public TempDecl declareTemps(String string, int n) {
            Streamable streamable;
            Streamable streamable2;
            String string2 = Util.newVarName(string);
            JSClassType jSClassType = this.m_expr.getType();
            String string3 = string2 + "arr";
            String string4 = string2 + "ndx";
            TypedExpression typedExpression = new TypedExpression(jSClassType, new ObjectExpression(string3 + "[" + string4 + "]"), null);
            TypedExpression typedExpression2 = new TypedExpression(jSClassType, new ObjectExpression(string2), string2);
            TempDeclImpl tempDeclImpl = new TempDeclImpl(typedExpression, typedExpression2);
            if (n != 1) {
                streamable2 = this.m_arrExpr.getType();
                streamable = new FieldDecl();
                streamable.name(string3);
                streamable.type((Type)streamable2);
                streamable.initializer(new Initializer(this.m_arrExpr));
                tempDeclImpl.addStatement((Statement)streamable);
                FieldDecl fieldDecl = new FieldDecl();
                fieldDecl.name(string4);
                fieldDecl.type(JSClassType.int_TYPE);
                fieldDecl.initializer(new Initializer(this.m_ndxExpr));
                tempDeclImpl.addStatement(fieldDecl);
            }
            if (n != 4) {
                streamable2 = new FieldDecl();
                ((FieldDecl)streamable2).name(string2);
                ((FieldDecl)streamable2).type(jSClassType);
                streamable = n == 1 ? this.m_expr : typedExpression;
                ((FieldDecl)streamable2).initializer(new Initializer((Expression)streamable));
                tempDeclImpl.addStatement((Statement)streamable2);
            }
            return tempDeclImpl;
        }
    }

    private class FieldTempDecl
    implements TempDeclFactory {
        private String m_fieldName;
        private TypedExpression m_objExpr;
        private TypedExpression m_expr;

        public FieldTempDecl(TypedExpression typedExpression2, FieldAccessDescriptor fieldAccessDescriptor, JSClassType.Factory factory) throws ClassNotFoundException {
            this.m_fieldName = fieldAccessDescriptor.getFieldName();
            this.m_objExpr = new TypedExpression(fieldAccessDescriptor.getBaseObject(), factory);
            this.m_expr = typedExpression2;
        }

        public TempDecl declareTemps(String string, int n) {
            Streamable streamable;
            Streamable streamable2;
            String string2 = Util.newVarName(string);
            JSClassType jSClassType = this.m_expr.getType();
            String string3 = string2 + "obj";
            TypedExpression typedExpression = new TypedExpression(jSClassType, new ObjectExpression(string3 + "." + this.m_fieldName), null);
            TypedExpression typedExpression2 = new TypedExpression(jSClassType, new ObjectExpression(string2), string2);
            TempDeclImpl tempDeclImpl = new TempDeclImpl(typedExpression, typedExpression2);
            if (n != 1) {
                streamable2 = this.m_objExpr.getType();
                streamable = new FieldDecl();
                streamable.name(string3);
                streamable.type((Type)streamable2);
                streamable.initializer(new Initializer(this.m_objExpr));
                tempDeclImpl.addStatement((Statement)streamable);
            }
            if (n != 4) {
                streamable2 = new FieldDecl();
                ((FieldDecl)streamable2).name(string2);
                ((FieldDecl)streamable2).type(jSClassType);
                streamable = n == 1 ? this.m_expr : typedExpression;
                ((FieldDecl)streamable2).initializer(new Initializer((Expression)streamable));
                tempDeclImpl.addStatement((Statement)streamable2);
            }
            return tempDeclImpl;
        }
    }

    private static class BasicTempDecl
    implements TempDeclFactory {
        private TypedExpression m_expr;

        BasicTempDecl(TypedExpression typedExpression) {
            this.m_expr = typedExpression;
        }

        public TempDecl declareTemps(String string, int n) {
            String string2 = Util.newVarName(string);
            JSClassType jSClassType = this.m_expr.getType();
            TypedExpression typedExpression = new TypedExpression(jSClassType, new ObjectExpression(string2), string2);
            TempDeclImpl tempDeclImpl = new TempDeclImpl(this.m_expr, typedExpression);
            if (n != 4) {
                FieldDecl fieldDecl = new FieldDecl();
                fieldDecl.name(string2);
                fieldDecl.type(jSClassType);
                fieldDecl.initializer(new Initializer(this.m_expr));
                tempDeclImpl.addStatement(fieldDecl);
            }
            return tempDeclImpl;
        }
    }

    private static class TempDeclImpl
    extends StatementGroup
    implements TempDecl {
        private TypedExpression m_lval;
        private TypedExpression m_rval;

        public TempDeclImpl(TypedExpression typedExpression, TypedExpression typedExpression2) {
            this.m_lval = typedExpression;
            this.m_rval = typedExpression2;
        }

        public TypedExpression getRValExpr() {
            return this.m_rval;
        }

        public TypedExpression getLValExpr() {
            return this.m_lval;
        }
    }

    private static interface TempDeclFactory {
        public TempDecl declareTemps(String var1, int var2);
    }
}

