/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen.engine;

import java.io.IOException;
import java.io.PrintWriter;
import sqlj.codegen.engine.BodyDecl;
import sqlj.codegen.engine.CodegenException;
import sqlj.codegen.engine.DocComment;
import sqlj.codegen.engine.Modifiers;
import sqlj.codegen.engine.NamedType;
import sqlj.codegen.engine.Statement;
import sqlj.codegen.engine.StatementBlock;
import sqlj.codegen.engine.StreamableObject;
import sqlj.codegen.engine.StreamableVector;
import sqlj.codegen.engine.Type;

public class BaseMethodDecl
implements BodyDecl {
    private DocComment comment_;
    private Modifiers modifiers_;
    private Type type_;
    private String name_;
    private StreamableVector params_;
    private StreamableVector throwlist_;
    private StatementBlock statements_;
    private boolean isAbstract_;

    public BaseMethodDecl(boolean bl) {
        this(bl, new StreamableVector(2));
    }

    public BaseMethodDecl(boolean bl, StreamableVector streamableVector) {
        this.isAbstract_ = bl;
        this.comment_ = new DocComment();
        this.modifiers_ = new Modifiers();
        this.name_ = "";
        this.params_ = streamableVector;
        this.params_.delimiter(", ");
        this.throwlist_ = new StreamableVector(1, "  throws ", ", ", " ");
        this.type_ = Type.EMPTY;
        this.statements_ = new StatementBlock();
    }

    public void docComment(DocComment docComment) {
        this.comment_ = docComment;
    }

    public void modifiers(Modifiers modifiers) {
        this.modifiers_ = modifiers;
    }

    public void name(String string) {
        this.name_ = string;
    }

    public String getName() {
        return this.name_;
    }

    public void addParameter(Type type, String string) {
        this.addParameter(new NamedType(type, string));
    }

    public void addParameter(NamedType namedType) {
        this.params_.addElement(namedType);
    }

    public void addException(String string) {
        this.throwlist_.addElement(new StreamableObject(string));
    }

    public void type(Type type) {
        this.type_ = type;
    }

    public void addStatement(Statement statement) {
        this.statements_.addStatement(statement);
    }

    public void stream(PrintWriter printWriter) throws IOException, CodegenException {
        this.comment_.stream(printWriter);
        this.modifiers_.stream(printWriter);
        this.type_.stream(printWriter);
        printWriter.print(this.name_ + "(");
        this.params_.stream(printWriter);
        printWriter.print(") ");
        if (this.throwlist_.size() > 0) {
            printWriter.println();
        }
        this.throwlist_.stream(printWriter);
        if (this.isAbstract_) {
            printWriter.println(";");
        } else {
            printWriter.println();
            this.statements_.stream(printWriter);
        }
    }
}

