/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import sqlj.framework.JSClass;
import sqlj.framework.JSMethod;
import sqlj.javac.ArgumentListNode;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.NameNode;
import sqlj.javac.Token;
import sqlj.util.ClassDescriptor;
import sqlj.util.Parselet;

public class SimpleNameNode
extends NameNode {
    private String name;
    private String text;
    int row;
    int col;
    private JSClass type = null;

    SimpleNameNode(JavaParserImpl javaParserImpl, Token token) {
        super(javaParserImpl);
        this.name = token.image;
        this.text = token.getText();
        this.row = token.beginLine;
        this.col = token.beginColumn;
    }

    int getRow() {
        return this.row;
    }

    int getColumn() {
        return this.col;
    }

    JSClass getType() {
        if (this.type == null && (this.type = this.lookupField()) == null) {
            this.type = this.resolveType();
        }
        return this.type;
    }

    boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    JSClass getBaseType() {
        JSClass jSClass = null;
        try {
            jSClass = this.getCaller();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return jSClass;
    }

    public String getText() {
        return this.name;
    }

    void scopeChanged() {
    }

    public final void getTextTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.text);
    }

    JSClass lookupMethod(ArgumentListNode argumentListNode) {
        JSClass jSClass = null;
        try {
            JSMethod[] jSMethodArray = this.getCaller().resolveMethod(this.name, argumentListNode.getTypeList(), this.getCaller());
            if (jSMethodArray.length == 1) {
                jSClass = jSMethodArray[0].getReturnType();
                if (jSClass == null) {
                    this.Error(29);
                }
                return jSClass;
            }
            Parselet parselet = this;
            while ((parselet = parselet.getScope().getEnclosingClass()) != null) {
                ClassDescriptor classDescriptor = (ClassDescriptor)parselet.getDescriptor();
                JSClass jSClass2 = classDescriptor.getReflection();
                JSMethod[] jSMethodArray2 = jSClass2.resolveMethod(this.name, argumentListNode.getTypeList(), this.getCaller());
                if (jSMethodArray2.length == 1) {
                    jSClass = jSMethodArray2[0].getReturnType();
                    if (jSClass == null) {
                        this.Error(29);
                    }
                    return jSClass;
                }
                if (jSMethodArray2.length <= 1) continue;
                this.Error(13);
                return jSClass;
            }
            this.Error(30);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.Error(36);
        }
        return jSClass;
    }

    public Object getValue() {
        Object object = super.getValue();
        return object;
    }
}

