/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.JSClass;
import sqlj.framework.checker.HostItem;
import sqlj.framework.checker.SQLOperation;
import sqlj.framework.checker.SQLToken;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.framework.error.Warning;
import sqlj.mesg.SemanticErrors;
import sqlj.semantics.ExecAnalysis;
import sqlj.semantics.OfflineChecker;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.semantics.sql.SQLTokenizer;
import sqlj.syntax.BindExpr;
import sqlj.syntax.DirectBindExpr;
import sqlj.syntax.IntoBindExpr;
import sqlj.syntax.ReturnBindExpr;
import sqlj.syntax.SQLUnit;
import sqlj.util.ClassDescriptor;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;

class SQLOperationImpl
implements SQLOperation {
    private SQLUnit m_sql_unit;
    private ErrorLog m_error_log;
    private int m_host_item_count;
    private int m_syntax_context;
    private Vector m_host_items;
    private JSClass m_result_type;
    private int m_result_index;

    SQLOperationImpl(ErrorLog errorLog, SQLUnit sQLUnit, JSClass jSClass, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        block25: {
            Object object;
            this.m_result_index = 0;
            this.m_sql_unit = sQLUnit;
            this.m_error_log = errorLog;
            this.m_result_type = jSClass;
            this.setOperationCode(this.getOperationCode());
            this.m_host_item_count = 0;
            this.m_host_items = new Vector();
            Enumeration enumeration = this.m_sql_unit.getBindExprs();
            IntoBindExpr intoBindExpr = null;
            while (enumeration.hasMoreElements()) {
                object = (BindExpr)enumeration.nextElement();
                if (object instanceof IntoBindExpr) {
                    if (intoBindExpr != null) {
                        errorLog.addEntry(new JSError(SemanticErrors.severalIntos()));
                        continue;
                    }
                    intoBindExpr = (IntoBindExpr)object;
                    continue;
                }
                if (object instanceof ReturnBindExpr) {
                    errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-1")));
                    continue;
                }
                if (object instanceof DirectBindExpr) {
                    ++this.m_host_item_count;
                    this.m_host_items.addElement(new HostItemImpl((DirectBindExpr)object, this.m_host_item_count));
                    continue;
                }
                errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-2")));
            }
            if (intoBindExpr != null) {
                if (this.m_result_type != null) {
                    errorLog.addEntry(new JSError(SemanticErrors.intoAndValue()));
                } else {
                    try {
                        this.m_result_type = semanticAnalyzerFactory.m_pf.newIteratorClass(intoBindExpr);
                        object = intoBindExpr.getParselets();
                        int n = 0;
                        while (object.hasMoreElements()) {
                            ++n;
                            try {
                                ExpressionDescriptor expressionDescriptor = (ExpressionDescriptor)((Parselet)object.nextElement()).getDescriptor();
                                if (expressionDescriptor.isAssignable()) continue;
                                errorLog.addEntry(new JSError(SemanticErrors.intoListItemMustBeLvalue(n)));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        boolean bl;
                        this.m_result_type = JSClass.ResultSetIterator_TYPE;
                        SQLToken sQLToken = ExecAnalysis.nextToken(this.tokens());
                        boolean bl2 = bl = sQLToken != null && sQLToken.tokenText().equalsIgnoreCase("FETCH");
                        if (bl) break block25;
                        errorLog.addEntry(new JSError(SemanticErrors.illegalIntoList(classNotFoundException.getMessage())));
                    }
                }
            }
        }
        if (this.m_host_item_count != this.m_sql_unit.getNumActualBindExprs()) {
            errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-3")));
        }
        int n = 0;
        Enumeration enumeration = this.tokens();
        int n2 = 0;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            SQLToken sQLToken = (SQLToken)enumeration.nextElement();
            if (0 <= n2 && sQLToken.tokenType() != 1) {
                if (++n2 == 1) {
                    if (sQLToken.tokenText().equalsIgnoreCase("SET")) {
                        bl = true;
                    } else {
                        n2 = -99999;
                    }
                } else if (n2 == 2) {
                    HostItemImpl hostItemImpl;
                    if (bl && sQLToken.tokenType() == 3 && (hostItemImpl = (HostItemImpl)this.m_host_items.elementAt(n)).getHostItemMode() != 4) {
                        if (hostItemImpl.getHostItemMode() != 0) {
                            errorLog.addEntry(new Warning(SemanticErrors.setModeChangedToOut()));
                        }
                        hostItemImpl.setHostItemMode(4);
                    }
                    n2 = -99999;
                }
            }
            if (sQLToken.tokenType() != 3) continue;
            if (++n > this.m_host_item_count) {
                errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-4")));
                continue;
            }
            ((HostItemImpl)this.m_host_items.elementAt(n - 1)).setPos(sQLToken.tokenPosition());
        }
        if (n < this.m_host_item_count) {
            errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-5")));
        }
    }

    public String getSQLString() {
        if (this.m_sql_unit.getSQL() == null) {
            throw new IllegalArgumentException("SQLUnit.getSQL() returns null");
        }
        return this.m_sql_unit.getSQL();
    }

    public void setSQLString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("SQLOperation.setSQLString(null)");
        }
        this.m_sql_unit.setSQL(string);
    }

    public Enumeration tokens() {
        return new SQLTokenizer(this.m_error_log, this.getSQLString());
    }

    public int getOperationCode() {
        return this.m_sql_unit.getOperationType();
    }

    public void setOperationCode(int n) {
        if (n != 9 && n != 4 && n != 11 && n != 8 && n != 6 && n != 2 && n != 7 && n != 12 && n != 3 && n != 17 && n != 1023 && n != 5 && n != 1022 && n != 19 && n != 18 && !OfflineChecker.isInternalOperation(n) && n < 1024) {
            throw new IllegalArgumentException("sqlj.semantics.SQLOperationImpl.setOperationCode(int): illegal operation code " + n);
        }
        this.m_sql_unit.setOperationType(n);
    }

    public void setDescriptor(Object object) {
        this.m_sql_unit.setDescriptor(object);
    }

    public Object getDescriptor() {
        return this.m_sql_unit.getDescriptor();
    }

    public int hostItemCount() {
        return this.m_host_item_count;
    }

    public HostItem hostItem(int n) {
        if (--n < 0 || n >= this.m_host_item_count) {
            return null;
        }
        return (HostItem)this.m_host_items.elementAt(n);
    }

    public JSClass getResultType() {
        return this.m_result_type;
    }

    public void setResultType(JSClass jSClass) {
        this.m_result_type = jSClass;
    }

    public void setResultParamIndex(int n) {
        if (n < 0 || n > this.hostItemCount() + 1) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.m_result_index == 0) {
            if (n != 0) {
                this.m_sql_unit.insertBindExprAt(ReturnBindExpr.COLUMN_RETURN, n);
            }
        } else {
            throw new IllegalArgumentException("can only set result param once");
        }
        this.m_result_index = n;
    }

    public int getResultParamIndex() {
        return this.m_result_index;
    }

    class HostItemImpl
    implements HostItem {
        private DirectBindExpr m_dbe;
        private int m_pos;
        private int m_nth;
        private JSClass m_type;
        private String m_name;
        private boolean m_lvalue;

        HostItemImpl(DirectBindExpr directBindExpr, int n) {
            block13: {
                this.m_dbe = directBindExpr;
                this.m_nth = n;
                if (this.m_dbe.getParselet() == null) {
                    SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-6")));
                }
                this.m_type = null;
                this.m_name = null;
                this.m_lvalue = false;
                try {
                    if (this.m_dbe.getParselet() == null) {
                        SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-8")));
                        break block13;
                    }
                    TypeDescriptor typeDescriptor = null;
                    try {
                        typeDescriptor = this.m_dbe.getParselet().getDescriptor();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        String string = "INTERNAL ERROR - PLEASE NOTIFY:\nException occurrend in parselet of DirectBindExpression when issuing getDescriptor():\n" + exception.toString() + "\n" + "This is at host expression #" + n + " in " + SQLOperationImpl.this.getSQLString();
                        System.out.println(string);
                        SQLOperationImpl.this.m_error_log.addEntry(new JSError(string));
                    }
                    if (typeDescriptor == null) {
                        SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-9")));
                        break block13;
                    }
                    try {
                        if (typeDescriptor instanceof ClassDescriptor) {
                            this.m_type = ((ClassDescriptor)typeDescriptor).getReflection();
                        } else if (typeDescriptor instanceof ExpressionDescriptor) {
                            this.m_type = ((ExpressionDescriptor)typeDescriptor).getReflection();
                            this.m_name = ((ExpressionDescriptor)typeDescriptor).getName();
                            this.m_lvalue = ((ExpressionDescriptor)typeDescriptor).isAssignable();
                            int n2 = this.getHostItemMode();
                            if (!(this.m_lvalue || n2 != 4 && n2 != 2)) {
                                SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.hostItemMustBeLvalue(this.m_nth)));
                            }
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-10")));
                }
            }
        }

        void setPos(int n) {
            this.m_pos = n;
        }

        public int getHostItemPosition() {
            return this.m_pos;
        }

        public JSClass getHostItemType() {
            return this.m_type;
        }

        public String getHostItemName() {
            return this.m_name;
        }

        public int getHostItemMode() {
            return this.m_dbe.getModality();
        }

        public void setHostItemMode(int n) {
            if (n == 1 || n == 4 || n == 2 || n == 0) {
                this.m_dbe.setModality(n);
                if (!(this.m_lvalue || n != 4 && n != 2)) {
                    SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.hostItemMustBeLvalue(this.m_nth)));
                }
            } else {
                throw new IllegalArgumentException("HostItem.setHostItemMode(" + n + ") - illegal mode value.");
            }
        }
    }
}

