/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics.sql;

import java.util.Enumeration;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.framework.options.HasOptions;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.PropertyList;
import sqlj.mesg.TranslatorErrors;

public class CheckerOptions
implements HasOptions {
    private boolean m_verbose = false;
    private boolean m_null = false;
    private boolean m_precision = false;
    private boolean m_portable = false;
    private boolean m_strict = false;
    private int m_default_function_mode = 0;
    private int m_default_procedure_mode = 0;
    private int m_default_block_mode = 0;

    public void setOptions(PropertyList propertyList, ErrorLog errorLog) throws InvalidOptionException {
        int n = 0;
        Enumeration enumeration = propertyList.propertyNames(false);
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = string = string2.trim();
            String string4 = null;
            String string5 = propertyList.getProperty(string3);
            int n2 = string3.indexOf("@");
            if (n2 >= 0) {
                string3 = string.substring(0, n2).trim();
                string4 = string.substring(n2 + 1).trim();
                if (string4 != null && string4.equals("")) {
                    string4 = null;
                }
            }
            if (string4 != null) {
                errorLog.addEntry(new JSError(TranslatorErrors.option_not_taggable(string3, string4)));
            }
            if (string3.equalsIgnoreCase("verbose")) {
                this.m_verbose = true;
                continue;
            }
            if (string3.equalsIgnoreCase("null")) {
                this.m_null = true;
                continue;
            }
            if (string3.equalsIgnoreCase("precision")) {
                this.m_precision = true;
                continue;
            }
            if (string3.equalsIgnoreCase("portable")) {
                this.m_portable = true;
                continue;
            }
            if (string3.equalsIgnoreCase("strict")) {
                this.m_strict = true;
                continue;
            }
            if (string3.equalsIgnoreCase("default-procedure-mode")) {
                this.m_default_procedure_mode = Integer.parseInt(string5);
                continue;
            }
            if (string3.equalsIgnoreCase("default-function-mode")) {
                this.m_default_function_mode = Integer.parseInt(string5);
                continue;
            }
            if (string3.equalsIgnoreCase("default-block-mode")) {
                this.m_default_block_mode = Integer.parseInt(string5);
                continue;
            }
            errorLog.addEntry(new JSError("Invalid option: " + string3));
            ++n;
        }
        if (n > 0) {
            throw new InvalidOptionException("One or more errors orrured during option processing");
        }
    }

    public String[][] getOptionInfo() {
        return new String[0][];
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public boolean getNull() {
        return this.m_null;
    }

    public boolean getPrecision() {
        return this.m_precision;
    }

    public boolean getPortable() {
        return this.m_portable;
    }

    public boolean getStrict() {
        return this.m_strict;
    }

    public int getDefaultFunctionMode() {
        return this.m_default_function_mode;
    }

    public int getDefaultProcedureMode() {
        return this.m_default_procedure_mode;
    }

    public int getDefaultBlockMode() {
        return this.m_default_block_mode;
    }
}

