/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import sqlj.framework.JSClass;
import sqlj.framework.checker.SQLOperation;
import sqlj.framework.checker.SQLToken;
import sqlj.framework.checker.SQLTypeProperties;
import sqlj.framework.checker.SimpleChecker;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.error.Warning;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.PropertyList;
import sqlj.mesg.SemanticErrors;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ref.RTResultSetJDBC;
import sqlj.semantics.sql.CheckerOptions;
import sqlj.semantics.sql.SQLMisc;
import sqlj.semantics.sql.SQLUtil;
import sqlj.util.Disposable;

public class SimpleCheckerImpl
implements SimpleChecker {
    private CheckerOptions m_co = null;
    private SQLTypeProperties m_stp;
    public ResultSet rset = null;
    public PreparedStatement pstmt = null;
    public RTResultSet rtrset = null;
    private boolean registered_disposal = false;

    public void setCheckerOptions(CheckerOptions checkerOptions) {
        this.m_co = checkerOptions;
    }

    public void setSQLTypeProperties(SQLTypeProperties sQLTypeProperties) {
        this.m_stp = sQLTypeProperties;
    }

    public boolean supportsDatabase(ErrorLog errorLog, Connection connection, String string, String string2) {
        return connection != null;
    }

    private void register_disposal() {
        Cleanup cleanup = new Cleanup();
        Disposable.disposer.register(cleanup);
        this.registered_disposal = true;
    }

    public ResultSetMetaData describeResultSet(ErrorLog errorLog, Connection connection, SQLOperation sQLOperation) {
        if (!this.registered_disposal) {
            this.register_disposal();
        }
        try {
            SimpleCheckerImpl.closeResultSet(this.rset);
            SimpleCheckerImpl.closeStatement(this.pstmt);
            Enumeration enumeration = new SQLUtil(errorLog, sQLOperation.getSQLString()).queryText();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                errorLog.addEntry(new Warning(SemanticErrors.unableToAnalyzeIllegalSQL()));
                return null;
            }
            String string = (String)enumeration.nextElement();
            if (this.m_co.getVerbose()) {
                errorLog.addEntry(new Info(SemanticErrors.queryingDatabaseWith(SQLMisc.stringify(SQLUtil.removeWhere(string)))));
            }
            this.pstmt = SimpleCheckerImpl.createStatement(this.pstmt, connection.prepareStatement(string));
            try {
                for (int i = 1; i <= sQLOperation.hostItemCount(); ++i) {
                    JSClass jSClass = sQLOperation.hostItem(i).getHostItemType();
                    try {
                        this.m_stp.bindNull(jSClass, i, this.pstmt);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        errorLog.addEntry(new Warning(SemanticErrors.badBindVarCast(jSClass.toString())));
                        continue;
                    }
                    catch (Exception exception) {
                        errorLog.addEntry(new Warning(SemanticErrors.badBindVarCast(jSClass.toString())));
                    }
                }
                this.rset = SimpleCheckerImpl.createResultSet(this.rset, this.pstmt.executeQuery());
                this.rset.getMetaData();
                return this.rset.getMetaData();
            }
            catch (SQLException sQLException) {
                if (!enumeration.hasMoreElements()) {
                    errorLog.addEntry(new JSError(SemanticErrors.unableToAnalyzeQuery(sQLException.getMessage())));
                    return null;
                }
                errorLog.addEntry(new Warning(SemanticErrors.unableToAnalyzeWhereClause(sQLException.getMessage())));
                while (enumeration.hasMoreElements()) {
                    try {
                        String string2 = (String)enumeration.nextElement();
                        if (this.m_co.getVerbose()) {
                            errorLog.addEntry(new Info(SemanticErrors.queryingDatabaseWith(SQLUtil.removeWhere(string2))));
                        }
                        SimpleCheckerImpl.closeResultSet(this.rset);
                        SimpleCheckerImpl.closeStatement(this.pstmt);
                        this.pstmt = SimpleCheckerImpl.createStatement(this.pstmt, connection.prepareStatement(string2));
                        this.rset = SimpleCheckerImpl.createResultSet(this.rset, this.pstmt.executeQuery());
                        return this.rset.getMetaData();
                    }
                    catch (SQLException sQLException2) {
                        if (enumeration.hasMoreElements()) continue;
                        errorLog.addEntry(new JSError(SemanticErrors.unableToAnalyze(sQLException2.getMessage())));
                        return null;
                    }
                }
                return this.rset.getMetaData();
            }
        }
        catch (SQLException sQLException) {
            errorLog.addEntry(new Warning(SemanticErrors.unableToAnalyze(sQLException.getMessage())));
            return null;
        }
    }

    public Enumeration getProcedureColumns(ErrorLog errorLog, Connection connection, Vector vector) {
        if (!this.registered_disposal) {
            this.register_disposal();
        }
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Vector vector2 = vector;
        try {
            SimpleCheckerImpl.closeResultSet(this.rset);
            SimpleCheckerImpl.closeStatement(this.pstmt);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            int n = 0;
            String string = null;
            String string2 = null;
            if (vector2.size() >= 2) {
                try {
                    string2 = databaseMetaData.getCatalogSeparator();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (string2 != null && !string2.equals("")) {
                    if (string2.equals(((SQLToken)vector2.elementAt(0)).tokenText())) {
                        ++n;
                    } else if (string2.equals(((SQLToken)vector2.elementAt(1)).tokenText()) && ((SQLToken)vector2.elementAt(0)).tokenType() == 2) {
                        string = SQLMisc.sqlCasing(((SQLToken)vector2.elementAt(0)).tokenText());
                        n += 2;
                    }
                }
            }
            String string3 = null;
            String string4 = ".";
            if (n + 1 < vector2.size() && string4 != null && string4.equals(((SQLToken)vector2.elementAt(n + 1)).tokenText())) {
                string3 = SQLMisc.sqlCasing(((SQLToken)vector2.elementAt(n)).tokenText());
                n += 2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n; i < vector2.size(); ++i) {
                stringBuffer.append(SQLMisc.sqlCasing(((SQLToken)vector2.elementAt(i)).tokenText()));
            }
            String string5 = stringBuffer.toString();
            this.rset = databaseMetaData.getProcedures(string, string3, string5);
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<Integer> vector6 = new Vector<Integer>();
            while (this.rset.next()) {
                vector3.addElement(this.rset.getString(1));
                vector4.addElement(this.rset.getString(2));
                vector5.addElement(this.rset.getString(3));
                vector6.addElement(new Integer(this.rset.getInt(8)));
            }
            SimpleCheckerImpl.closeResultSet(this.rset);
            SimpleCheckerImpl.closeStatement(this.pstmt);
            if (vector5.size() == 0) {
                return null;
            }
            return new ColumnEnumeration(vector3, vector4, vector5, databaseMetaData);
        }
        catch (SQLException sQLException) {
            errorLog.addEntry(new JSError(SemanticErrors.noDescriptionForProcedure(SQLMisc.sqlCasing(vector2.elements()))));
            return null;
        }
    }

    public void parse(ErrorLog errorLog, Connection connection, SQLOperation sQLOperation, short[] sArray) {
    }

    public void setOptions(PropertyList propertyList, ErrorLog errorLog) throws InvalidOptionException {
        this.m_co.setOptions(propertyList, errorLog);
    }

    public String[][] getOptionInfo() {
        return this.m_co.getOptionInfo();
    }

    private static void closeStatement(PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void closeRTResultSet(RTResultSet rTResultSet) {
        try {
            if (rTResultSet != null) {
                rTResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static PreparedStatement createStatement(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) {
        return preparedStatement2;
    }

    protected static ResultSet createResultSet(ResultSet resultSet, ResultSet resultSet2) {
        return resultSet2;
    }

    class ColumnEnumeration
    implements Enumeration {
        Vector catalogs;
        Vector schemas;
        Vector names;
        DatabaseMetaData dbm;
        int m_index = 0;

        ColumnEnumeration(Vector vector, Vector vector2, Vector vector3, DatabaseMetaData databaseMetaData) {
            this.catalogs = vector;
            this.schemas = vector2;
            this.names = vector3;
            this.dbm = databaseMetaData;
            this.m_index = 0;
        }

        public boolean hasMoreElements() {
            return this.m_index < this.names.size();
        }

        public Object nextElement() {
            if (this.m_index >= this.names.size()) {
                throw new NoSuchElementException();
            }
            try {
                SimpleCheckerImpl.closeRTResultSet(SimpleCheckerImpl.this.rtrset);
                SimpleCheckerImpl.closeResultSet(SimpleCheckerImpl.this.rset);
                SimpleCheckerImpl.closeStatement(SimpleCheckerImpl.this.pstmt);
                SimpleCheckerImpl.this.rset = SimpleCheckerImpl.createResultSet(SimpleCheckerImpl.this.rset, this.dbm.getProcedureColumns((String)this.catalogs.elementAt(this.m_index), (String)this.schemas.elementAt(this.m_index), (String)this.names.elementAt(this.m_index), null));
                SimpleCheckerImpl.this.rtrset = new RTResultSetJDBC(SimpleCheckerImpl.this.rset);
                ++this.m_index;
                return SimpleCheckerImpl.this.rtrset;
            }
            catch (SQLException sQLException) {
                ++this.m_index;
                return null;
            }
        }
    }

    class Cleanup
    implements Disposable {
        Cleanup() {
        }

        public void dispose() {
            SimpleCheckerImpl.closeResultSet(SimpleCheckerImpl.this.rset);
            SimpleCheckerImpl.closeStatement(SimpleCheckerImpl.this.pstmt);
        }
    }
}

