/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sqlj.framework.BaseJSClass;
import sqlj.framework.ClassResolver;
import sqlj.util.ClassNameResolver;
import sqlj.util.ClassNameResolverWrapper;
import sqlj.util.ClassResolverWrapper;
import sqlj.util.NestedClassResolver;

public class UnitClassResolver
extends ClassNameResolverWrapper {
    private Hashtable m_classCache = new Hashtable();
    private Hashtable m_nameCache = new Hashtable();
    private String m_packageQual = "";
    private int m_packageQualLen = 0;
    private Hashtable m_explicitImportTable = new Hashtable();
    private Vector m_implicitImports = new Vector();

    public UnitClassResolver(ClassResolver classResolver) {
        super(new ClassNameResolverImpl(classResolver));
        this.m_implicitImports.addElement(new ImplicitEntry(""));
        this.m_implicitImports.addElement(new ImplicitEntry("java.lang"));
    }

    public NestedClassResolver newNestedClassResolver(String string) {
        return new NestedClassResolver(string, this);
    }

    public void setPackageName(String string) {
        if (string == null) {
            string = "";
        }
        this.m_packageQual = string.length() > 0 ? string + "." : "";
        this.m_packageQualLen = this.m_packageQual.length();
        this.m_implicitImports.setElementAt(new ImplicitEntry(string), 0);
    }

    public void addExplicitImport(String string) {
        ExplicitEntry explicitEntry = new ExplicitEntry(string);
        this.m_explicitImportTable.put(explicitEntry.getClassComponent(), explicitEntry);
    }

    public void addImplicitImport(String string) {
        this.m_implicitImports.addElement(new ImplicitEntry(string));
    }

    public BaseJSClass getClass(String string) throws ClassNotFoundException {
        BaseJSClass baseJSClass = (BaseJSClass)this.m_classCache.get(string);
        if (baseJSClass != null) {
            return baseJSClass;
        }
        baseJSClass = this.lookupResult(string);
        if (baseJSClass != null) {
            this.m_classCache.put(string, baseJSClass);
            return baseJSClass;
        }
        throw new ClassNotFoundException(string);
    }

    private BaseJSClass lookupResult(String string) throws ClassNotFoundException {
        BaseJSClass baseJSClass = this.getArray(string);
        if (baseJSClass != null) {
            return baseJSClass;
        }
        baseJSClass = this.resolveExplicit(string);
        if (baseJSClass != null) {
            return baseJSClass;
        }
        baseJSClass = this.resolveImplicit(string);
        if (baseJSClass != null) {
            return baseJSClass;
        }
        baseJSClass = this.resolveClass(string);
        if (baseJSClass != null) {
            return baseJSClass;
        }
        return null;
    }

    private BaseJSClass resolveImplicit(String string) {
        string = string.replace('.', '$');
        Enumeration enumeration = this.m_implicitImports.elements();
        while (enumeration.hasMoreElements()) {
            ImplicitEntry implicitEntry = (ImplicitEntry)enumeration.nextElement();
            BaseJSClass baseJSClass = this.getQualifiedClass(implicitEntry.getImport() + string);
            if (baseJSClass == null) continue;
            this.m_nameCache.put(baseJSClass, string);
            return baseJSClass;
        }
        return null;
    }

    private BaseJSClass resolveExplicit(String string) throws ClassNotFoundException {
        String string2;
        String string3;
        BaseJSClass baseJSClass = null;
        int n = string.indexOf(46);
        if (n != -1) {
            string3 = string.substring(n);
            string3 = string3.replace('.', '$');
            string2 = string.substring(0, n);
        } else {
            string3 = "";
            string2 = string;
        }
        ExplicitEntry explicitEntry = null;
        explicitEntry = (ExplicitEntry)this.m_explicitImportTable.get(string2);
        if (explicitEntry != null && (baseJSClass = this.getQualifiedClass(explicitEntry.getResolvedName() + string3)) != null) {
            this.m_nameCache.put(baseJSClass, string.replace('.', '$'));
        }
        return baseJSClass;
    }

    private BaseJSClass resolveClass(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        while (true) {
            BaseJSClass baseJSClass;
            if ((baseJSClass = this.getQualifiedClass(stringBuffer.toString())) != null) {
                return baseJSClass;
            }
            if ((n = string.lastIndexOf(46, n - 1)) == -1) break;
            stringBuffer.setCharAt(n, '$');
        }
        return null;
    }

    public String getShortName(BaseJSClass baseJSClass) {
        String string = (String)this.m_nameCache.get(baseJSClass);
        if (string != null) {
            return string;
        }
        return this.m_base.getShortName(baseJSClass);
    }

    public StringBuffer getClassQualification() {
        return new StringBuffer(this.m_packageQual);
    }

    public void addClass(BaseJSClass baseJSClass) {
        String string = baseJSClass.getName();
        if (this.m_packageQualLen > 0 && string.startsWith(this.m_packageQual) && string.indexOf(46, this.m_packageQualLen) == -1) {
            String string2 = string.substring(this.m_packageQualLen);
            this.m_nameCache.put(baseJSClass, string2);
        }
        super.addClass(baseJSClass);
    }

    private class ExplicitEntry {
        private String m_origName;
        private String m_classComponent;
        private String m_resolvedName = null;

        public ExplicitEntry(String string) {
            this.m_origName = string;
            int n = string.lastIndexOf(46);
            this.m_classComponent = n == -1 ? string : string.substring(n + 1);
        }

        public String getClassComponent() {
            return this.m_classComponent;
        }

        public String getResolvedName() throws ClassNotFoundException {
            if (this.m_resolvedName == null) {
                BaseJSClass baseJSClass = UnitClassResolver.this.resolveClass(this.m_origName);
                if (baseJSClass == null) {
                    throw new ClassNotFoundException("error in import: " + this.m_origName);
                }
                this.m_resolvedName = baseJSClass.getName();
            }
            return this.m_resolvedName;
        }
    }

    private class ImplicitEntry {
        private String m_origName;
        private String m_resolvedName = null;

        public ImplicitEntry(String string) {
            if (string == null) {
                string = "";
            }
            this.m_origName = string;
        }

        public String getImport() {
            if (this.m_resolvedName == null) {
                String string = ".";
                String string2 = this.m_origName;
                if (string2.length() > 0) {
                    BaseJSClass baseJSClass = UnitClassResolver.this.resolveClass(string2);
                    if (baseJSClass != null) {
                        string2 = baseJSClass.getName();
                        string = "$";
                    }
                } else {
                    string = "";
                }
                this.m_resolvedName = string2 + string;
            }
            return this.m_resolvedName;
        }
    }

    private static class ClassNameResolverImpl
    extends ClassResolverWrapper
    implements ClassNameResolver {
        ClassNameResolverImpl(ClassResolver classResolver) {
            super(classResolver);
        }

        public String getShortName(BaseJSClass baseJSClass) {
            return baseJSClass.getName();
        }

        public StringBuffer getClassQualification() {
            return new StringBuffer();
        }
    }
}

