/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import sun.io.CharToByteConverter;

public class OracleOutputStreamWriter
extends OutputStreamWriter {
    private static final int MAXCHAR = 127;
    private CharToByteConverter m_encoding;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private char[] carr = new char[]{'\\', 'u', '0', '0', '0', '0'};

    public OracleOutputStreamWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        this(outputStream, System.getProperty("file.encoding"));
    }

    public OracleOutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string != null && string.equals("Unicode") && System.getProperty("os.arch").equals("x86") ? (string = "UnicodeLittle") : string);
        try {
            this.m_encoding = CharToByteConverter.getConverter((String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_encoding = null;
            throw unsupportedEncodingException;
        }
    }

    public void write(int n) throws IOException {
        if (!(127 >= n || this.m_encoding != null && this.m_encoding.canConvert((char)n))) {
            this.writeEscape(n);
        } else {
            super.write(n);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            if (!('\u007f' >= cArray[n4] || this.m_encoding != null && this.m_encoding.canConvert(cArray[n4]))) {
                if (n4 > n) {
                    super.write(cArray, n, n4 - n);
                }
                this.writeEscape(cArray[n4]);
                n = ++n4;
                continue;
            }
            ++n4;
        }
        if (n3 > n) {
            super.write(cArray, n, n3 - n);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        if (string == null) {
            return;
        }
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (!('\u007f' >= c || this.m_encoding != null && this.m_encoding.canConvert(c))) {
                if (n4 > n) {
                    super.write(string, n, n4 - n);
                }
                this.writeEscape(c);
                n = ++n4;
                continue;
            }
            ++n4;
        }
        if (n3 > n) {
            super.write(string, n, n3 - n);
        }
    }

    public static String getEscape(int n) {
        char[] cArray = new char[6];
        cArray[0] = 92;
        cArray[1] = 117;
        int n2 = n / 256;
        cArray[2] = hex[n2 / 16];
        cArray[3] = hex[n2 % 16];
        n2 = n % 256;
        cArray[4] = hex[n2 / 16];
        cArray[5] = hex[n2 % 16];
        return new String(cArray);
    }

    private void writeEscape(int n) throws IOException {
        int n2 = n / 256;
        this.carr[2] = hex[n2 / 16];
        this.carr[3] = hex[n2 % 16];
        n2 = n % 256;
        this.carr[4] = hex[n2 / 16];
        this.carr[5] = hex[n2 % 16];
        super.write(this.carr, 0, 6);
    }
}

