/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util.io;

import java.io.IOException;
import sqlj.util.io.CharStream;

public class StringCharStream
implements CharStream {
    private String m_s;
    private int m_length;
    private int m_pos;
    private int m_begin_token;

    public StringCharStream(String string) {
        this.m_s = string;
        if (string == null) {
            this.m_s = "";
        }
        this.m_pos = 0;
        this.m_begin_token = 0;
        this.m_length = this.m_s.length();
    }

    public char readChar() throws IOException {
        if (this.m_pos >= this.m_length) {
            throw new IOException("Reading past end of string");
        }
        return this.m_s.charAt(this.m_pos++);
    }

    public int getColumn() {
        return this.getEndColumn();
    }

    public int getLine() {
        return this.getEndLine();
    }

    public int getEndColumn() {
        return 0;
    }

    public int getEndLine() {
        return this.m_pos;
    }

    public int getBeginColumn() {
        return 0;
    }

    public int getBeginLine() {
        return this.m_begin_token;
    }

    public void backup(int n) {
        this.m_pos -= n;
        if (this.m_pos < 0) {
            this.m_pos = 0;
        }
    }

    public char BeginToken() throws IOException {
        this.m_begin_token = this.m_pos;
        return this.readChar();
    }

    public String GetImage() {
        return this.m_s.substring(this.m_begin_token, this.m_pos);
    }

    public char[] GetSuffix(int n) {
        return this.m_s.substring(this.m_pos - n, this.m_pos).toCharArray();
    }

    public void Done() {
    }
}

