/*
 * Decompiled with CFR 0.152.
 */
package UtilXML;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;

public class UtilXML {
    private static final boolean Debug = false;

    public static String XMLtoString(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        try {
            InputStream inputStream = UtilXML.XMLtoInputStream(string, string2, bl, bl2);
            int n = inputStream.available();
            if (n <= 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            byte[] byArray = new byte[n];
            while (n > 0) {
                n = inputStream.read(byArray);
                if (n <= 0) continue;
                stringBuffer.append(new String(byArray, 0, n));
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.toString());
            throw sQLException;
        }
    }

    public static String XMLtoString(String string, String string2) throws SQLException {
        return UtilXML.XMLtoString(string, string2, false, false);
    }

    public static String XMLtoString(String string) throws SQLException {
        return UtilXML.XMLtoString(string, null, false, false);
    }

    public static InputStream XMLtoInputStream(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        try {
            UtilXML.validateXML(string, string2, bl, bl2);
            FileInputStream fileInputStream = null;
            File file = new File(string);
            if (!file.isFile()) {
                if (string.substring(0, 4).equals("file")) {
                    int n = string.indexOf(":");
                    if (n > 0) {
                        String string3 = string.substring(n + 1, string.length());
                        fileInputStream = new FileInputStream(new File(string3));
                        return fileInputStream;
                    }
                    throw new SQLException("File '" + string + "' not found.");
                }
                if (string.substring(0, 4).equals("http")) {
                    URL uRL = new URL(string);
                    uRL.openConnection();
                    InputStream inputStream = uRL.openStream();
                    return inputStream;
                }
                fileInputStream = new FileInputStream(file);
                return fileInputStream;
            }
            fileInputStream = new FileInputStream(file);
            return fileInputStream;
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.getMessage());
            throw sQLException;
        }
    }

    public static InputStream XMLtoInputStream(String string, String string2) throws SQLException {
        return UtilXML.XMLtoInputStream(string, string2, false, false);
    }

    public static InputStream XMLtoInputStream(String string) throws SQLException {
        return UtilXML.XMLtoInputStream(string, null, false, false);
    }

    public static InputSource getInputSource(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            return null;
        }
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return UtilXML.getInputSource(byteArrayInputStream);
    }

    public static InputSource getInputSource(InputStream inputStream) throws SQLException {
        InputSource inputSource = new InputSource(new BufferedReader(new InputStreamReader(inputStream)));
        return inputSource;
    }

    public static Document InputStreamtoDOM(InputStream inputStream, String string, boolean bl, boolean bl2) throws SQLException {
        Class<?> clazz = null;
        Document document = null;
        try {
            if (string != null) {
                clazz = Class.forName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            SQLException sQLException = new SQLException(classNotFoundException.toString());
            throw sQLException;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (clazz != null) {
                documentBuilder.setErrorHandler((ErrorHandler)clazz.newInstance());
            }
            InputSource inputSource = UtilXML.getInputSource(inputStream);
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.toString());
            throw sQLException;
        }
        return document;
    }

    public static Document InputStreamtoDOM(InputStream inputStream, String string) throws SQLException {
        return UtilXML.InputStreamtoDOM(inputStream, string, false, false);
    }

    public static Document InputStreamtoDOM(InputStream inputStream) throws SQLException {
        return UtilXML.InputStreamtoDOM(inputStream, null, false, false);
    }

    public static Document StringtoDOM(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        if (string == null || string.length() == 0) {
            return UtilXML.InputStreamtoDOM(null, string2, bl, bl2);
        }
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return UtilXML.InputStreamtoDOM(byteArrayInputStream, string2, bl, bl2);
    }

    public static Document StringtoDOM(String string, String string2) throws SQLException {
        return UtilXML.StringtoDOM(string, string2, false, false);
    }

    public static Document StringtoDOM(String string) throws SQLException {
        return UtilXML.StringtoDOM(string, null, false, false);
    }

    private static void validateXML(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        SAXParser sAXParser;
        String string3 = null;
        Class<?> clazz = null;
        try {
            string3 = string2 == null ? "UtilXML.IfxHandler" : string2;
            clazz = Class.forName(string3);
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.toString());
            throw sQLException;
        }
        if (string == null) {
            throw new SQLException("Target '" + string + "' is null.");
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.setNamespaceAware(bl2);
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.toString());
            throw sQLException;
        }
        try {
            File file = new File(string);
            if (file.exists()) {
                sAXParser.parse(file, (HandlerBase)clazz.newInstance());
            } else {
                sAXParser.parse(string, (HandlerBase)clazz.newInstance());
            }
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException(exception.toString());
            throw sQLException;
        }
    }
}

