/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class CodeGenUtil {
    public static final short GETSQL = 0;
    public static final short READ = 1;
    public static final short WRITE = 2;
    public static final String CRLF = "\n";
    public static final String TAB = "    ";
    public static final String BASE = "B";
    public static final String COLLECTION = "C";
    public static final String DISTINCT = "D";
    public static final String NAMEDROW = "R";
    public static final String BUILTIN = " ";
    boolean importYM = false;
    boolean importDF = false;

    String toStringType(int n, short s) {
        switch (n) {
            case 0: {
                return "String";
            }
            case 1: {
                return "short";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "BigDecimal";
            }
            case 7: {
                return "Date";
            }
            case 8: {
                return "BigDecimal";
            }
            case 10: {
                return this.getTimeType(s);
            }
            case 14: {
                return this.getIntervalType(s);
            }
            case 15: {
                return "String";
            }
            case 17: {
                return "long";
            }
            case 6: {
                return "int";
            }
            case 18: {
                return "long";
            }
            case 45: {
                return "boolean";
            }
            case 101: {
                return "java.sql.Clob";
            }
            case 102: {
                return "java.sql.Blob";
            }
        }
        return null;
    }

    String getTimeType(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        if (by < 6) {
            return "Timestamp";
        }
        return "Time";
    }

    String getIntervalType(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        if (by < 4) {
            this.importYM = true;
            return "IfxIntervalYM";
        }
        this.importDF = true;
        return "IfxIntervalDF";
    }

    public static String getReadProcName(String string, int n) {
        if (string.startsWith("IfxInterval")) {
            return "new " + string + "(stream.readString())";
        }
        if (string.startsWith("String")) {
            return "readString(" + n + ")";
        }
        if (string.equalsIgnoreCase("struct")) {
            return "(Struct)stream.readObject()";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return "read" + stringBuffer + "()";
    }

    public static String getWriteProcName(String string, String string2, int n) {
        if (string.startsWith("IfxInterval")) {
            return "stream.writeString(" + string2 + ".toString())";
        }
        if (string.startsWith("String")) {
            return "writeString(" + string2 + ", " + n + ")";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return "write" + stringBuffer + "(" + string2 + ")";
    }

    String generateFile(String string, String string2, Vector vector) {
        String string3 = string2 + ".java";
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "rw");
            this.generateImportAndFields(string2, randomAccessFile, vector);
            this.generateCode(randomAccessFile, 0, vector, string);
            this.generateCode(randomAccessFile, 1, vector, string);
            this.generateCode(randomAccessFile, 2, vector, string);
            this.generateCode(randomAccessFile, "\n}\n");
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string3;
    }

    private void generateImportAndFields(String string, RandomAccessFile randomAccessFile, Vector vector) throws IOException {
        this.generateCode(randomAccessFile, "import java.sql.*;\n");
        this.generateCode(randomAccessFile, "import com.informix.jdbc.IfmxUDTSQLInput;\n");
        this.generateCode(randomAccessFile, "import com.informix.jdbc.IfmxUDTSQLOutput;\n");
        this.generateCode(randomAccessFile, "import java.math.*;\n\n");
        if (this.importDF) {
            this.generateCode(randomAccessFile, "import com.informix.jdbc.IfxIntervalDF;\n");
        }
        if (this.importYM) {
            this.generateCode(randomAccessFile, "import com.informix.jdbc.IfxIntervalYM;\n");
        }
        this.generateCode(randomAccessFile, "public class " + string + " implements SQLData " + CRLF + "{ " + CRLF);
        for (int i = 0; i < vector.size(); ++i) {
            this.generateCode(randomAccessFile, "    public " + ((Field)vector.elementAt((int)i)).datatype + BUILTIN + ((Field)vector.elementAt((int)i)).name + ";" + CRLF);
        }
    }

    void generateCode(RandomAccessFile randomAccessFile, String string) throws IOException {
        randomAccessFile.writeBytes(string);
    }

    void generateCode(RandomAccessFile randomAccessFile, int n, Vector vector, String string) throws IOException {
        if (randomAccessFile == null) {
            throw new IOException("File Not found");
        }
        switch (n) {
            case 0: {
                String string2 = "    private String sql_type =  \"" + string + "\"" + ";" + CRLF + CRLF + TAB + "public String getSQLTypeName() { return sql_type" + "; }" + CRLF;
                this.generateCode(randomAccessFile, string2);
                break;
            }
            case 1: {
                String string3 = "\n    public void readSQL(SQLInput stream, String type) throws SQLException\n    {\n";
                string3 = string3 + TAB + TAB + "IfmxUDTSQLInput in = (IfmxUDTSQLInput) stream; " + CRLF;
                for (int i = 0; i < vector.size(); ++i) {
                    String string4 = "        " + ((Field)vector.elementAt((int)i)).name + " = in." + ((Field)vector.elementAt((int)i)).readProcName + ";" + CRLF;
                    string3 = string3 + string4;
                }
                string3 = string3 + TAB + "}" + CRLF;
                this.generateCode(randomAccessFile, string3);
                break;
            }
            case 2: {
                String string5 = "\n    public void writeSQL(SQLOutput stream) throws SQLException\n    { \n";
                string5 = string5 + TAB + TAB + "IfmxUDTSQLOutput out = (IfmxUDTSQLOutput) stream; " + CRLF;
                for (int i = 0; i < vector.size(); ++i) {
                    String string6 = "        out." + ((Field)vector.elementAt((int)i)).writeProcName + ";" + CRLF;
                    string5 = string5 + string6;
                }
                string5 = string5 + TAB + "}" + CRLF;
                this.generateCode(randomAccessFile, string5);
            }
        }
    }

    class Field {
        String name;
        String datatype;
        String readProcName;
        String writeProcName;

        public Field(String string, String string2, String string3, String string4) {
            this.name = string;
            this.datatype = string2;
            this.readProcName = string3;
            this.writeProcName = string4;
        }
    }
}

