/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.informix.jdbc.IfmxCallableStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInteger;
import com.informix.jdbc.IfxLvarchar;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.UDRMetaData;

public class UDRManager {
    private IfxConnection conn = null;
    private String jarTmpPath = null;
    private Locale locale = Locale.getDefault();
    private Trace trace = null;
    private boolean isInUserTx = false;
    static Hashtable JavaToIfxNameTable;
    static final String IFX_FILE_TO_FILE = "function informix.ifx_file_to_file(lvarchar,int,lvarchar,int)";
    static final int LO_SERVER_FILE = 0x10000000;
    static final int LO_CLIENT_FILE = 0x20000000;

    public UDRManager(Connection connection) throws SQLException {
        if (connection == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.conn = (IfxConnection)connection;
        this.jarTmpPath = UDRManager.isNTServer(this.conn) ? "c:\\Temp\\" : "/tmp/";
    }

    public void createUDRs(UDRMetaData uDRMetaData, String string, String string2, int n) throws SQLException {
        if (uDRMetaData == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (string2 == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        UDRManager.checkJarFile(string, this.locale);
        int n2 = this.conn.getDatabaseType();
        if (n2 == 0) {
            throw IfxErrMsg.getSQLException((int)-79844, (String)"", (Locale)this.locale);
        }
        Hashtable hashtable = uDRMetaData.udrs;
        if (hashtable == null || hashtable.size() == 0) {
            throw IfxErrMsg.getSQLException((int)-79842, (String)"", (Locale)this.locale);
        }
        String string3 = uDRMetaData.jarFileSQLName;
        if (string3 == null) {
            throw IfxErrMsg.getSQLException((int)-79843, (String)"", (Locale)this.locale);
        }
        UDRManager.checkJarInSysCatalog(string3, this.conn, this.locale);
        String string4 = UDRManager.transportJarToServer(string, this.jarTmpPath, this.conn, this.locale);
        if (n2 == 1 || n2 == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                this.conn.setAutoCommit(false);
            }
        }
        try {
            UDRManager.installJarNow(string3, string4, n, this.conn);
            UDRManager.registerUDRs(uDRMetaData, string2, null, this.conn, this.locale);
        }
        catch (SQLException sQLException) {
            if (!this.isInUserTx) {
                this.conn.rollback();
                throw sQLException;
            }
            throw sQLException;
        }
        if (!(n2 != 1 && n2 != 2 || this.isInUserTx)) {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        UDRManager.removeFileInServer(string4, this.conn);
    }

    public void removeUDR(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        String string2 = "DROP ROUTINE " + string;
        Statement statement = this.conn.createStatement();
        statement.executeUpdate(string2);
        statement.close();
    }

    public void removeUDR(String string, Class[] classArray) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        String string2 = "";
        if (classArray != null) {
            string2 = UDRManager.fromClassesToIfxNames(classArray, null, null, this.trace, this.locale);
        }
        String string3 = "DROP ROUTINE " + string + "(" + string2 + ")";
        Statement statement = this.conn.createStatement();
        statement.executeUpdate(string3);
        statement.close();
    }

    public void removeJar(String string, int n) throws SQLException {
        UDRManager.removeJarNow(string, n, this.conn, this.locale);
    }

    public void setJarTmpPath(String string) throws SQLException {
        this.jarTmpPath = UDRManager.getJarTmpPathNow(this.conn, string, this.locale);
    }

    static boolean isNTServer(IfxConnection ifxConnection) throws SQLException {
        boolean bl = false;
        int n = 0;
        if (ifxConnection == null) {
            return false;
        }
        String string = ifxConnection.getDbVersion();
        for (int i = 0; !bl && i < string.length(); ++i) {
            if (string.charAt(i) != '.' || ++n != 2 || string.charAt(i + 1) != 'T') continue;
            bl = true;
        }
        return bl;
    }

    static String getJarTmpPathNow(IfxConnection ifxConnection, String string, Locale locale) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)locale);
        }
        if (UDRManager.isNTServer(ifxConnection)) {
            return string + "\\";
        }
        return string + "/";
    }

    static void checkJarFile(String string, Locale locale) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)locale);
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw IfxErrMsg.getSQLException((int)-79845, (String)"", (Locale)locale);
        }
    }

    static void checkJarInSysCatalog(String string, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Object var3_3 = null;
        String string2 = "select tabname from informix.systables where tabname = 'retained_jars' and owner = 'sqlj'";
        Statement statement = ifxConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        boolean bl = resultSet.next();
        resultSet.close();
        if (!bl) {
            statement.close();
            return;
        }
        String string3 = ifxConnection.getDbName() + "." + ifxConnection.getUserName() + "." + string;
        string2 = "select jarname from 'sqlj'.retained_jars where jarname = '" + string3 + "'";
        resultSet = statement.executeQuery(string2);
        boolean bl2 = resultSet.next();
        resultSet.close();
        statement.close();
        if (bl2) {
            throw IfxErrMsg.getSQLException((int)-79839, (String)"", (Locale)locale);
        }
    }

    static String transportJarToServer(String string, String string2, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Object var4_4 = null;
        String string3 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string3);
        String string4 = string.substring(n + 1);
        if (!string4.endsWith(".jar")) {
            throw IfxErrMsg.getSQLException((int)-79846, (String)"", (Locale)locale);
        }
        String string5 = string2 + string4;
        IfxLvarchar ifxLvarchar = new IfxLvarchar(string);
        ifxLvarchar.setConnection(ifxConnection);
        ifxLvarchar.setExtendedTypeName("lvarchar");
        IfxInteger ifxInteger = new IfxInteger(0x20000000);
        IfxLvarchar ifxLvarchar2 = new IfxLvarchar(string5);
        ifxLvarchar2.setConnection(ifxConnection);
        ifxLvarchar2.setExtendedTypeName("lvarchar");
        IfxInteger ifxInteger2 = new IfxInteger(0x10000000);
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(ifxLvarchar);
        vector.addElement(ifxInteger);
        vector.addElement(ifxLvarchar2);
        vector.addElement(ifxInteger2);
        IfxSqli ifxSqli = null;
        try {
            ifxSqli = new IfxSqli((IfxSqliConnect)ifxConnection);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException((int)-79735, (String)"", (Locale)locale);
        }
        Vector vector2 = ifxSqli.executeFastPath(IFX_FILE_TO_FILE, vector, false);
        ifxSqli.clear();
        ifxSqli = null;
        if (!UDRManager.isNTServer(ifxConnection)) {
            UDRManager.changeFilePermissionInServer(string5, ifxConnection);
        }
        UDRManager.changeFilePermissionInClient(string, ifxConnection, locale);
        return string5;
    }

    static void changeFilePermissionInClient(String string, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Object var3_3 = null;
        String string2 = null;
        string2 = System.getProperty("file.separator").equals("/") ? "chmod a+w " + string : "attrib -r " + string;
        try {
            Process process = Runtime.getRuntime().exec(string2);
            if (process.waitFor() != 0) {
                throw IfxErrMsg.getSQLException((int)-79838, (String)"", (Locale)locale);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException((int)-79838, (String)"", (Locale)locale);
        }
    }

    static void changeFilePermissionInServer(String string, IfxConnection ifxConnection) throws SQLException {
        Object var2_2 = null;
        Statement statement = ifxConnection.createStatement();
        String string2 = null;
        string2 = UDRManager.isNTServer(ifxConnection) ? "CREATE PROCEDURE udtudrmgr_chperm (fname varchar(80)) \nsystem 'cmd /C attrib -r ' || fname; \nEND PROCEDURE" : "CREATE PROCEDURE udtudrmgr_chperm (fname varchar(80)) \nsystem 'chmod 666 ' || fname; \nEND PROCEDURE";
        statement.execute(string2);
        string2 = "EXECUTE PROCEDURE udtudrmgr_chperm ('" + string + "')";
        statement.execute(string2);
        string2 = "DROP PROCEDURE udtudrmgr_chperm (varchar)";
        statement.execute(string2);
        statement.close();
    }

    static void removeFileInServer(String string, IfxConnection ifxConnection) throws SQLException {
        Object var2_2 = null;
        Statement statement = ifxConnection.createStatement();
        String string2 = null;
        string2 = UDRManager.isNTServer(ifxConnection) ? "CREATE PROCEDURE udtudrmgr_rmfile (fname varchar(80)) \nsystem 'cmd /C del ' || fname; \nEND PROCEDURE" : "CREATE PROCEDURE udtudrmgr_rmfile (fname varchar(80)) \nsystem 'rm ' || fname; \nEND PROCEDURE";
        statement.execute(string2);
        string2 = "EXECUTE PROCEDURE udtudrmgr_rmfile ('" + string + "')";
        statement.execute(string2);
        string2 = "DROP PROCEDURE udtudrmgr_rmfile (varchar)";
        statement.execute(string2);
        statement.close();
    }

    static void installJarNow(String string, String string2, int n, IfxConnection ifxConnection) throws SQLException {
        Object var4_4 = null;
        String string3 = "file:" + string2;
        IfmxCallableStatement ifmxCallableStatement = (IfmxCallableStatement)ifxConnection.prepareCall("{ call sqlj.install_jar(?,?,?) }");
        ifmxCallableStatement.setString(1, string3);
        ifmxCallableStatement.setString(2, string);
        ifmxCallableStatement.setInt(3, n);
        ifmxCallableStatement.executeUpdate();
        ifmxCallableStatement.close();
    }

    static void removeJarNow(String string, int n, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Object var4_4 = null;
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)locale);
        }
        IfmxCallableStatement ifmxCallableStatement = (IfmxCallableStatement)ifxConnection.prepareCall("{ call sqlj.remove_jar(?,?) }");
        ifmxCallableStatement.setString(1, string);
        ifmxCallableStatement.setInt(2, n);
        ifmxCallableStatement.executeUpdate();
    }

    static void registerUDRs(UDRMetaData uDRMetaData, String string, String string2, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Trace trace = null;
        Method method = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        Hashtable hashtable = uDRMetaData.udrs;
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        String string9 = uDRMetaData.jarFileSQLName;
        Statement statement = ifxConnection.createStatement();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            method = (Method)enumeration.nextElement();
            string3 = method.getName();
            UDRMetaData.udrinfo udrinfo2 = (UDRMetaData.udrinfo)hashtable.get(method);
            string4 = udrinfo2.sqlname;
            string5 = UDRManager.fromClassesToIfxNames(method.getParameterTypes(), string, string2, trace, locale);
            string6 = UDRManager.fromClassesToJavaNames(method.getParameterTypes(), trace);
            string7 = UDRManager.fromClassesToIfxNames(new Class[]{method.getReturnType()}, string, string2, trace, locale);
            string8 = string7.equals("void") ? "CREATE PROCEDURE " + string4 + " (" + string5 + ") " + "EXTERNAL NAME '" + string9 + ":" + string + "." + string3 + "(" + string6 + ")' " + "LANGUAGE JAVA NOT VARIANT END PROCEDURE" : "CREATE FUNCTION " + string4 + " (" + string5 + ") " + "RETURNS " + string7 + " " + "EXTERNAL NAME '" + string9 + ":" + string + "." + string3 + "(" + string6 + ")' " + "LANGUAGE JAVA NOT VARIANT END FUNCTION";
            statement.executeUpdate(string8);
        }
        statement.close();
    }

    static String fromClassesToJavaNames(Class[] classArray, Trace trace) {
        int n = classArray.length;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != n - 1) {
                stringBuffer.append(classArray[i].getName() + ", ");
                continue;
            }
            stringBuffer.append(classArray[i].getName());
        }
        return stringBuffer.toString();
    }

    static String fromClassesToIfxNames(Class[] classArray, String string, String string2, Trace trace, Locale locale) throws SQLException {
        int n = classArray.length;
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = -1;
            String string3 = null;
            String string4 = classArray[i].getName();
            if (string4.equals(string)) {
                if (string2 != null) {
                    string3 = string2;
                }
            } else {
                if (string4.equals("java.lang.Object") || string4.equals("java.sql.SQLData")) {
                    throw IfxErrMsg.getSQLException((int)-79860, (String)"", (Locale)locale);
                }
                string3 = UDRManager.JavaToIfxName(string4);
                if (string3.equals("unknown")) {
                    throw IfxErrMsg.getSQLException((int)-79714, (String)"", (Locale)locale);
                }
            }
            if (i != n - 1) {
                stringBuffer.append(string3 + ", ");
                continue;
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String JavaToIfxName(String string) {
        String string2 = (String)JavaToIfxNameTable.get(string);
        if (string2 == null) {
            return "unknown";
        }
        return string2;
    }

    static {
        if (JavaToIfxNameTable == null) {
            JavaToIfxNameTable = new Hashtable(30);
            JavaToIfxNameTable.put(new String("boolean"), new String("boolean"));
            JavaToIfxNameTable.put(new String("char"), new String("char(1)"));
            JavaToIfxNameTable.put(new String("byte"), new String("char(1)"));
            JavaToIfxNameTable.put(new String("short"), new String("smallint"));
            JavaToIfxNameTable.put(new String("int"), new String("int"));
            JavaToIfxNameTable.put(new String("long"), new String("int8"));
            JavaToIfxNameTable.put(new String("float"), new String("smallfloat"));
            JavaToIfxNameTable.put(new String("double"), new String("float"));
            JavaToIfxNameTable.put(new String("java.lang.String"), new String("lvarchar"));
            JavaToIfxNameTable.put(new String("java.math.BigDecimal"), new String("decimal"));
            JavaToIfxNameTable.put(new String("java.lang.Boolean"), new String("boolean"));
            JavaToIfxNameTable.put(new String("java.lang.Integer"), new String("int"));
            JavaToIfxNameTable.put(new String("java.lang.Short"), new String("smallint"));
            JavaToIfxNameTable.put(new String("java.lang.Long"), new String("int8"));
            JavaToIfxNameTable.put(new String("java.lang.Float"), new String("smallfloat"));
            JavaToIfxNameTable.put(new String("java.lang.Double"), new String("float"));
            JavaToIfxNameTable.put(new String("java.sql.Date"), new String("date"));
            JavaToIfxNameTable.put(new String("java.sql.Time"), new String("datetime hour to second"));
            JavaToIfxNameTable.put(new String("java.sql.Timestamp"), new String("datetime year to fraction(5)"));
            JavaToIfxNameTable.put(new String("com.informix.lang.IntervalYM"), new String("interval year to month"));
            JavaToIfxNameTable.put(new String("com.informix.lang.IntervalDF"), new String("interval day to fraction(5)"));
            JavaToIfxNameTable.put(new String("java.sql.Blob"), new String("blob"));
            JavaToIfxNameTable.put(new String("java.sql.Clob"), new String("clob"));
        }
    }
}

