/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.CodeGenUtil;
import udtudrmgr.UDRManager;
import udtudrmgr.UDTMetaData;

public class UDTManager {
    private IfxConnection conn = null;
    private String jarTmpPath = null;
    private String informixdir = null;
    private Locale locale = Locale.getDefault();
    private Trace trace = null;
    private boolean isInUserTx = false;
    private boolean hasDefltIOmthd = false;

    public UDTManager(Connection connection) throws SQLException {
        if (connection == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.conn = (IfxConnection)connection;
        this.jarTmpPath = UDRManager.isNTServer(this.conn) ? "c:\\Temp\\" : "/tmp/";
    }

    public void createUDT(UDTMetaData uDTMetaData, String string, String string2, int n) throws SQLException {
        if (uDTMetaData == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (string2 == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (uDTMetaData.sqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79849, (String)"", (Locale)this.locale);
        }
        UDRManager.checkJarFile(string, this.locale);
        int n2 = this.conn.getDatabaseType();
        if (n2 == 0) {
            throw IfxErrMsg.getSQLException((int)-79844, (String)"", (Locale)this.locale);
        }
        this.checkUDTClass(string2);
        if (this.isUDTInSysCatalog(uDTMetaData.sqlname)) {
            throw IfxErrMsg.getSQLException((int)-79848, (String)"", (Locale)this.locale);
        }
        String string3 = uDTMetaData.jarFileSQLName;
        if (string3 == null) {
            throw IfxErrMsg.getSQLException((int)-79843, (String)"", (Locale)this.locale);
        }
        UDRManager.checkJarInSysCatalog(string3, this.conn, this.locale);
        String string4 = UDRManager.transportJarToServer(string, this.jarTmpPath, this.conn, this.locale);
        if (n2 == 1 || n2 == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                this.conn.setAutoCommit(false);
            }
        }
        try {
            UDRManager.installJarNow(string3, string4, n, this.conn);
            this.registerUDT(uDTMetaData);
            this.registerSupportUDRs(uDTMetaData, string2);
            UDRManager.registerUDRs(uDTMetaData, string2, uDTMetaData.sqlname, this.conn, this.locale);
            this.registerImplCasts(uDTMetaData.implCasts, uDTMetaData.sqlname);
            this.registerExplCasts(uDTMetaData.explCasts, uDTMetaData.sqlname);
            this.setExternalName(uDTMetaData.sqlname, string3, string2);
        }
        catch (SQLException sQLException) {
            if (!this.isInUserTx) {
                this.conn.rollback();
                throw sQLException;
            }
            throw sQLException;
        }
        if (!(n2 != 1 && n2 != 2 || this.isInUserTx)) {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        UDRManager.removeFileInServer(string4, this.conn);
    }

    public String createUDTClass(UDTMetaData uDTMetaData) throws SQLException {
        Vector<CodeGenUtil.Field> vector = new Vector<CodeGenUtil.Field>();
        if (uDTMetaData == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (uDTMetaData.getSQLName() == null) {
            throw IfxErrMsg.getSQLException((int)-79849, (String)"", (Locale)this.locale);
        }
        if (uDTMetaData.getFieldCount() < 1) {
            throw IfxErrMsg.getSQLException((int)-79850, (String)"", (Locale)this.locale);
        }
        if (uDTMetaData.getLength() == -1) {
            throw IfxErrMsg.getSQLException((int)-79851, (String)"", (Locale)this.locale);
        }
        CodeGenUtil codeGenUtil = new CodeGenUtil();
        for (int i = 1; i <= uDTMetaData.getFieldCount(); ++i) {
            String string = uDTMetaData.getFieldName(i);
            int n = uDTMetaData.getFieldType(i);
            if (string == null || n == -1) {
                throw IfxErrMsg.getSQLException((int)-79852, (String)"", (Locale)this.locale);
            }
            int n2 = uDTMetaData.getFieldLength(i);
            String string2 = codeGenUtil.toStringType(n, (short)n2);
            if (n2 == -1 && (IfxTypes.isString((int)n) || n == 10 || n == 14)) {
                throw IfxErrMsg.getSQLException((int)-79863, (String)"", (Locale)this.locale);
            }
            String string3 = CodeGenUtil.getReadProcName(string2, n2);
            String string4 = CodeGenUtil.getWriteProcName(string2, string, n2);
            CodeGenUtil codeGenUtil2 = codeGenUtil;
            codeGenUtil2.getClass();
            vector.addElement(codeGenUtil2.new CodeGenUtil.Field(string, string2, string3, string4));
        }
        String string = this.compilesource(codeGenUtil.generateFile(uDTMetaData.getSQLName(), uDTMetaData.getClassName(), vector));
        String string5 = string.substring(0, string.indexOf(46));
        if (!uDTMetaData.keepJavaFile) {
            this.removeClientFile(string);
        }
        return string5;
    }

    public String createJar(UDTMetaData uDTMetaData, String[] stringArray) throws SQLException {
        if (uDTMetaData == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (uDTMetaData.sqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79849, (String)"", (Locale)this.locale);
        }
        if (stringArray == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (stringArray.length == 0) {
            throw IfxErrMsg.getSQLException((int)-79853, (String)"", (Locale)this.locale);
        }
        String string = uDTMetaData.sqlname + ".jar";
        StringBuffer stringBuffer = new StringBuffer();
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            file = new File(stringArray[i]);
            if (!file.exists()) {
                throw IfxErrMsg.getSQLException((int)-79853, (String)"", (Locale)this.locale);
            }
            stringBuffer = stringBuffer.append(" " + stringArray[i]);
        }
        String string2 = "jar cf " + string + stringBuffer.toString();
        try {
            Process process = Runtime.getRuntime().exec(string2);
            if (process.waitFor() != 0) {
                throw IfxErrMsg.getSQLException((int)-79847, (String)"", (Locale)this.locale);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException((int)-79847, (String)"", (Locale)this.locale);
        }
        return string;
    }

    public void removeUDT(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        int n = this.conn.getDatabaseType();
        if (n == 0) {
            throw IfxErrMsg.getSQLException((int)-79844, (String)"", (Locale)this.locale);
        }
        int n2 = this.getUDTXid(string);
        if (n == 1 || n == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                this.conn.setAutoCommit(false);
            }
        }
        try {
            this.unsetExternalName(string);
            this.unregisterCastsAndCastUDRs(string, n2);
            this.unregisterNonCastUDRs(string, n2);
            this.unregisterUDT(string);
        }
        catch (SQLException sQLException) {
            if (!this.isInUserTx) {
                this.conn.rollback();
                throw sQLException;
            }
            throw sQLException;
        }
        if (!(n != 1 && n != 2 || this.isInUserTx)) {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
    }

    public void removeJar(String string, int n) throws SQLException {
        UDRManager.removeJarNow(string, n, this.conn, this.locale);
    }

    public void setJarTmpPath(String string) throws SQLException {
        this.jarTmpPath = UDRManager.getJarTmpPathNow(this.conn, string, this.locale);
    }

    private void checkUDTClass(String string) throws SQLException {
        try {
            int n;
            Class<?> clazz = Class.forName(string);
            Class<?>[] classArray = clazz.getInterfaces();
            for (n = 0; n < classArray.length && !classArray[n].getName().equals("java.sql.SQLData"); ++n) {
            }
            if (n == classArray.length) {
                throw IfxErrMsg.getSQLException((int)-79854, (String)"", (Locale)this.locale);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw IfxErrMsg.getSQLException((int)-79855, (String)"", (Locale)this.locale);
        }
    }

    private boolean isUDTInSysCatalog(String string) throws SQLException {
        String string2 = null;
        string2 = this.conn.getDatabaseType() == 1 ? "select name from informix.sysxtdtypes where name = '" + string + "' " + "and owner = '" + this.conn.getUserName() + "' " + "and mode = 'B'" : "select name from informix.sysxtdtypes where name = '" + string + "' " + "and mode = 'B'";
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        boolean bl = resultSet.next();
        resultSet.close();
        statement.close();
        return bl;
    }

    private int getUDTXid(String string) throws SQLException {
        String string2 = null;
        string2 = this.conn.getDatabaseType() == 1 ? "select extended_id from informix.sysxtdtypes where owner = '" + this.conn.getUserName() + "' " + "and name = '" + string + "' " + "and mode = 'B'" : "select extended_id from informix.sysxtdtypes where name = '" + string + "' " + "and mode = 'B'";
        int n = -1;
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        boolean bl = resultSet.next();
        if (bl) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        statement.close();
        if (!bl) {
            throw IfxErrMsg.getSQLException((int)-79856, (String)"", (Locale)this.locale);
        }
        return n;
    }

    private void registerUDT(UDTMetaData uDTMetaData) throws SQLException {
        String string = uDTMetaData.sqlname;
        int n = uDTMetaData.length;
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("CREATE OPAQUE TYPE " + string + " (");
        if (uDTMetaData.length == -1) {
            stringBuffer.append("internallength = variable");
        } else {
            stringBuffer.append("internallength = " + uDTMetaData.length);
        }
        if (uDTMetaData.align != -1) {
            stringBuffer.append(", alignment = " + uDTMetaData.align);
        }
        stringBuffer.append(")");
        String string2 = stringBuffer.toString().trim();
        Statement statement = this.conn.createStatement();
        statement.executeUpdate(string2);
        statement.close();
    }

    private void unregisterUDT(String string) throws SQLException {
        String string2 = "DROP TYPE " + string + " RESTRICT";
        Statement statement = this.conn.createStatement();
        statement.executeUpdate(string2);
        statement.close();
    }

    private void registerSupportUDRs(UDTMetaData uDTMetaData, String string) throws SQLException {
        boolean[] blArray = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            blArray[i] = true;
        }
        Method method = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Hashtable hashtable = uDTMetaData.supportudrs;
        String string8 = uDTMetaData.sqlname;
        String string9 = uDTMetaData.jarFileSQLName;
        Statement statement = this.conn.createStatement();
        if (hashtable != null && hashtable.size() != 0) {
            int n = hashtable.size();
            UDTMetaData.supportudrinfo[] supportudrinfoArray = new UDTMetaData.supportudrinfo[n];
            int n2 = 0;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                supportudrinfoArray[n2] = (UDTMetaData.supportudrinfo)enumeration.nextElement();
                method = supportudrinfoArray[n2].method;
                string2 = method.getName();
                string3 = supportudrinfoArray[n2].sqlname;
                string4 = UDRManager.fromClassesToIfxNames(method.getParameterTypes(), string, string8, this.trace, this.locale);
                string5 = UDRManager.fromClassesToJavaNames(method.getParameterTypes(), this.trace);
                string6 = UDRManager.fromClassesToIfxNames(new Class[]{method.getReturnType()}, string, string8, this.trace, this.locale);
                string7 = "CREATE FUNCTION " + string3 + " (" + string4 + ") " + "RETURNS " + string6 + " " + "EXTERNAL NAME '" + string9 + ":" + string + "." + string2 + "(" + string5 + ")' " + "LANGUAGE JAVA NOT VARIANT END FUNCTION";
                statement.executeUpdate(string7);
                blArray[supportudrinfoArray[n2].type] = false;
                ++n2;
            }
            return;
        }
        block12: for (int i = 0; i < 8; ++i) {
            if (!blArray[i]) continue;
            switch (i) {
                case 0: {
                    string7 = "CREATE FUNCTION " + string8 + "_input " + "(lvarchar) " + "RETURNS " + string8 + " " + "EXTERNAL NAME 'com.informix.jdbc.IfxDataPointer." + "IfxDataInput(java.lang.Object)' " + "LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE IMPLICIT CAST (lvarchar as " + string8 + " with " + string8 + "_input)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 1: {
                    string7 = "CREATE FUNCTION " + string8 + "_output " + "(" + string8 + ") " + "RETURNS lvarchar " + "EXTERNAL NAME 'com.informix.jdbc.IfxDataPointer." + "IfxDataOutput(java.sql.SQLData)' " + "LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE EXPLICIT CAST (" + string8 + " as lvarchar with " + string8 + "_output)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 2: {
                    string7 = "CREATE FUNCTION " + string8 + "_send " + "(" + string8 + ") " + "RETURNS sendrecv " + "EXTERNAL NAME 'com.informix.jdbc.IfxDataPointer." + "IfxDataOutput(java.sql.SQLData)' " + "LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE EXPLICIT CAST (" + string8 + " as sendrecv with " + string8 + "_send)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 3: {
                    string7 = "CREATE FUNCTION " + string8 + "_receive " + "(sendrecv) " + "RETURNS " + string8 + " " + "EXTERNAL NAME 'com.informix.jdbc.IfxDataPointer." + "IfxDataInput(java.lang.Object)' " + "LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE IMPLICIT CAST (sendrecv as " + string8 + " with " + string8 + "_receive)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 4: {
                    string7 = "CREATE FUNCTION " + string8 + "_import " + "(impexp) " + "RETURNS " + string8 + " " + "EXTERNAL NAME 'com.informix.jdbc.IfxDataPointer." + "IfxDataInput(java.lang.Object)' " + "LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE IMPLICIT CAST (impexp as " + string8 + " with " + string8 + "_import)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 5: {
                    string7 = "CREATE FUNCTION " + string8 + "_export " + "(" + string8 + ") " + "RETURNS impexp " + "EXTERNAL NAME 'com.informix.jdbc.IfxDataPointer." + "IfxDataOutput(java.sql.SQLData)' " + "LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE EXPLICIT CAST (" + string8 + " as impexp with " + string8 + "_export)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 6: {
                    string7 = "CREATE FUNCTION " + string8 + "_binaryimport " + "(impexpbin) " + "RETURNS " + string8 + " " + "EXTERNAL NAME 'com.informix.jdbc.IfxDataPointer." + "IfxDataInput(java.lang.Object)' " + "LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE IMPLICIT CAST (impexpbin as " + string8 + " with " + string8 + "_binaryimport)";
                    statement.executeUpdate(string7);
                    continue block12;
                }
                case 7: {
                    string7 = "CREATE FUNCTION " + string8 + "_binaryexport " + "(" + string8 + ") " + "RETURNS impexpbin " + "EXTERNAL NAME 'com.informix.jdbc.IfxDataPointer." + "IfxDataOutput(java.sql.SQLData)' " + "LANGUAGE JAVA VARIANT END FUNCTION";
                    statement.executeUpdate(string7);
                    string7 = "CREATE EXPLICIT CAST (" + string8 + " as impexpbin with " + string8 + "_binaryexport)";
                    statement.executeUpdate(string7);
                }
            }
        }
        statement.close();
    }

    private void registerImplCasts(Vector vector, String string) throws SQLException {
        String string2 = null;
        String string3 = null;
        UDTMetaData.castinfo castinfo2 = null;
        if (vector != null && vector.size() != 0) {
            Statement statement = this.conn.createStatement();
            for (int i = 0; i < vector.size(); ++i) {
                castinfo2 = (UDTMetaData.castinfo)vector.elementAt(i);
                string3 = IfxTypes.IfxTypeToName((int)castinfo2.ifxtype);
                string2 = "CREATE IMPLICIT CAST (" + string3 + " as " + string + " with " + castinfo2.methodsqlname + ")";
                statement.executeUpdate(string2);
            }
            statement.close();
        }
    }

    private void registerExplCasts(Vector vector, String string) throws SQLException {
        String string2 = null;
        String string3 = null;
        UDTMetaData.castinfo castinfo2 = null;
        if (vector != null && vector.size() != 0) {
            Statement statement = this.conn.createStatement();
            for (int i = 0; i < vector.size(); ++i) {
                castinfo2 = (UDTMetaData.castinfo)vector.elementAt(i);
                string3 = IfxTypes.IfxTypeToName((int)castinfo2.ifxtype);
                string2 = "CREATE EXPLICIT CAST (" + string + " as " + string3 + " with " + castinfo2.methodsqlname + ")";
                statement.executeUpdate(string2);
            }
            statement.close();
        }
    }

    private void unregisterCastsAndCastUDRs(String string, int n) throws SQLException {
        String string2 = null;
        Statement statement = this.conn.createStatement();
        Statement statement2 = this.conn.createStatement();
        string2 = this.conn.getDatabaseType() == 1 ? "select argument_type, argument_xid, result_type, result_xid, routine_name, class from informix.syscasts where (argument_xid = " + n + " " + "or result_xid = " + n + ") " + "and owner = '" + this.conn.getUserName() + "'" : "select argument_type, argument_xid, result_type, result_xid, routine_name, class from informix.syscasts where (argument_xid = " + n + " " + "or result_xid = " + n + ")";
        ResultSet resultSet = statement2.executeQuery(string2);
        while (resultSet.next()) {
            String string3;
            int n2 = resultSet.getInt(1);
            int n3 = resultSet.getInt(2);
            int n4 = resultSet.getInt(3);
            int n5 = resultSet.getInt(4);
            String string4 = resultSet.getString(5);
            String string5 = resultSet.getString(6);
            if (string5.equals("I")) {
                string3 = n2 <= 18 ? IfxTypes.IfxTypeToName((int)n2) : this.getXTypeName(n3);
                string2 = "DROP CAST (" + string3 + " as " + string + ")";
            } else {
                string3 = n4 <= 18 ? IfxTypes.IfxTypeToName((int)n4) : this.getXTypeName(n5);
                string2 = "DROP CAST (" + string + " as " + string3 + ")";
            }
            statement.executeUpdate(string2);
            string2 = "DROP ROUTINE " + string4;
            statement.executeUpdate(string2);
        }
        resultSet.close();
        statement.close();
        statement2.close();
    }

    private void unregisterNonCastUDRs(String string, int n) throws SQLException {
        String string2 = null;
        Statement statement = this.conn.createStatement();
        Statement statement2 = this.conn.createStatement();
        string2 = this.conn.getDatabaseType() == 1 ? "select procname, isproc, paramtypes::lvarchar from informix.sysprocedures where paramtypes::lvarchar like '%" + string + "%' " + "and langid = (select langid from informix.sysroutinelangs " + "where langname = 'java') " + "and owner = '" + this.conn.getUserName() + "'" : "select procname, isproc, paramtypes::lvarchar from informix.sysprocedures where paramtypes::lvarchar like '%" + string + "%' " + "and langid = (select langid from informix.sysroutinelangs " + "where langname = 'java')";
        ResultSet resultSet = statement2.executeQuery(string2);
        while (resultSet.next()) {
            String string3 = resultSet.getString(1);
            String string4 = resultSet.getString(2);
            String string5 = resultSet.getString(3);
            string2 = string4.equals("f") ? "DROP FUNCTION " + string3 + " (" + string5 + ")" : "DROP PROCEDURE " + string3 + " (" + string5 + ")";
            statement.executeUpdate(string2);
        }
        resultSet.close();
        statement.close();
        statement2.close();
    }

    private void setExternalName(String string, String string2, String string3) throws SQLException {
        Statement statement = this.conn.createStatement();
        String string4 = "EXECUTE PROCEDURE sqlj.setUDTExtName('" + string + "', '" + string2 + ":" + string3 + "')";
        statement.executeUpdate(string4);
        statement.close();
    }

    private void unsetExternalName(String string) throws SQLException {
        Statement statement = this.conn.createStatement();
        String string2 = "EXECUTE PROCEDURE sqlj.unsetUDTExtName('" + string + "')";
        statement.executeUpdate(string2);
        statement.close();
    }

    private String compilesource(String string) throws SQLException {
        String string2 = "javac " + string;
        try {
            Process process = Runtime.getRuntime().exec(string2);
            if (process.waitFor() != 0) {
                throw IfxErrMsg.getSQLException((int)-79847, (String)"", (Locale)this.locale);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException((int)-79847, (String)"", (Locale)this.locale);
        }
        return string;
    }

    private String getXTypeName(int n) throws SQLException {
        String string = "select name from informix.sysxtdtypes where extended_id = " + n;
        String string2 = null;
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        resultSet.close();
        statement.close();
        return string2;
    }

    private void removeClientFile(String string) throws SQLException {
        String string2 = "rm -f " + string;
        try {
            Process process = Runtime.getRuntime().exec(string2);
            if (process.waitFor() != 0) {
                throw IfxErrMsg.getSQLException((int)-79858, (String)"", (Locale)this.locale);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException((int)-79858, (String)"", (Locale)this.locale);
        }
    }
}

