/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.informix.jdbc.IfxDateTime;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.UDRMetaData;

public class UDTMetaData
extends UDRMetaData {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int SEND = 2;
    public static final int RECEIVE = 3;
    public static final int IMPORT = 4;
    public static final int EXPORT = 5;
    public static final int BINARYIMPORT = 6;
    public static final int BINARYEXPORT = 7;
    public static final int MAX_SUPPORT_FUNC_TYPE = 8;
    public static final int SINGLE_BYTE = 1;
    public static final int TWO_BYTE = 2;
    public static final int FOUR_BYTE = 4;
    public static final int EIGHT_BYTE = 8;
    String sqlname = null;
    int length = -1;
    int align = -1;
    String classname = null;
    int fieldCount = 0;
    fieldinfo[] fields = null;
    Hashtable supportudrs = null;
    Vector implCasts = null;
    Vector explCasts = null;
    boolean keepJavaFile = false;

    public void setSQLName(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.sqlname = string;
    }

    public String getSQLName() {
        return this.sqlname;
    }

    public void setLength(int n) throws SQLException {
        if (n <= 0) {
            throw IfxErrMsg.getSQLException((int)-79771, (String)"", (Locale)this.locale);
        }
        this.length = n;
    }

    public int getLength() {
        return this.length;
    }

    public void setAlignment(int n) throws SQLException {
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw IfxErrMsg.getSQLException((int)-79771, (String)"", (Locale)this.locale);
        }
        this.align = n;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setFieldCount(int n) throws SQLException {
        if (n <= 0) {
            throw IfxErrMsg.getSQLException((int)-79771, (String)"", (Locale)this.locale);
        }
        this.fieldCount = n;
        this.fields = new fieldinfo[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fields[i] = new fieldinfo();
        }
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setClassName(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.classname = string;
    }

    public String getClassName() {
        if (this.classname != null) {
            return this.classname;
        }
        return this.sqlname;
    }

    public void setSupportUDR(Method method, String string, int n) throws SQLException {
        supportudrinfo supportudrinfo2;
        if (method == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (n < 0 || n >= 8) {
            throw IfxErrMsg.getSQLException((int)-79857, (String)"", (Locale)this.locale);
        }
        if (this.supportudrs == null) {
            this.supportudrs = new Hashtable(10);
        }
        if (!this.supportudrs.contains(supportudrinfo2 = new supportudrinfo(method, string, n))) {
            this.supportudrs.put(new Integer(n), supportudrinfo2);
        }
    }

    public Method[] getSupportUDRs() {
        Method[] methodArray = null;
        int n = 0;
        if (this.supportudrs == null) {
            return null;
        }
        n = this.supportudrs.size();
        if (n == 0) {
            return null;
        }
        methodArray = new Method[n];
        int n2 = 0;
        Enumeration enumeration = this.supportudrs.elements();
        while (enumeration.hasMoreElements()) {
            methodArray[n2] = ((supportudrinfo)enumeration.nextElement()).method;
            ++n2;
        }
        return methodArray;
    }

    public String getSupportUDRSQLName(Method method) throws SQLException {
        if (method == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.supportudrs == null) {
            return null;
        }
        supportudrinfo supportudrinfo2 = null;
        Enumeration enumeration = this.supportudrs.elements();
        while (enumeration.hasMoreElements()) {
            supportudrinfo2 = (supportudrinfo)enumeration.nextElement();
            if (!supportudrinfo2.method.equals(method)) continue;
            return supportudrinfo2.sqlname;
        }
        return null;
    }

    public void setImplicitCast(int n, String string) throws SQLException {
        if (!this.isValidCastType(n)) {
            throw IfxErrMsg.getSQLException((int)-79714, (String)"", (Locale)this.locale);
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.implCasts == null) {
            this.implCasts = new Vector(5);
        }
        castinfo castinfo2 = new castinfo(n, string);
        this.implCasts.addElement(castinfo2);
    }

    public void setExplicitCast(int n, String string) throws SQLException {
        if (!this.isValidCastType(n)) {
            throw IfxErrMsg.getSQLException((int)-79714, (String)"", (Locale)this.locale);
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.explCasts == null) {
            this.explCasts = new Vector(5);
        }
        castinfo castinfo2 = new castinfo(n, string);
        this.explCasts.addElement(castinfo2);
    }

    public void keepJavaFile(boolean bl) {
        this.keepJavaFile = bl;
    }

    public void setFieldName(int n, String string) throws SQLException {
        this.checkfield(n);
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.fields[n - 1].name = string;
    }

    public String getFieldName(int n) throws SQLException {
        this.checkfield(n);
        return this.fields[n - 1].name;
    }

    public void setFieldType(int n, int n2) throws SQLException {
        this.checkfield(n);
        this.checkFieldType(n2);
        this.fields[n - 1].ifxtype = n2;
    }

    public int getFieldType(int n) throws SQLException {
        this.checkfield(n);
        return this.fields[n - 1].ifxtype;
    }

    public void setFieldTypeName(int n, String string) throws SQLException {
        this.checkfield(n);
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.fields[n - 1].sqltypename = string;
    }

    public String getFieldTypeName(int n) throws SQLException {
        this.checkfield(n);
        if (this.fields[n - 1].sqltypename != null) {
            return this.fields[n - 1].sqltypename;
        }
        if (this.fields[n - 1].ifxtype != -1) {
            return IfxTypes.IfxTypeToName((int)this.fields[n - 1].ifxtype);
        }
        return null;
    }

    public void setFieldLength(int n, int n2) throws SQLException {
        this.checkfield(n);
        if (n2 <= 0) {
            throw IfxErrMsg.getSQLException((int)-79771, (String)"", (Locale)this.locale);
        }
        int n3 = this.fields[n - 1].ifxtype;
        if (IfxTypes.isString((int)n3) || n3 == 14) {
            this.fields[n - 1].length = n2;
        } else if (n3 == 10) {
            byte by = IfxDateTime.getStartCode((short)((short)n2));
            byte by2 = IfxDateTime.getEndCode((short)((short)n2));
            if (by == 6 && by2 == 10 || by == 0 && (by2 == 10 || by2 == 12 || by2 == 11 || by2 == 12 || by2 == 13 || by2 == 14 || by2 == 15)) {
                this.fields[n - 1].length = n2;
            } else {
                throw IfxErrMsg.getSQLException((int)-79717, (String)"", (Locale)this.locale);
            }
        }
    }

    public int getFieldLength(int n) throws SQLException {
        this.checkfield(n);
        return this.fields[n - 1].length;
    }

    private void checkFieldType(int n) throws SQLException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 45: 
            case 101: 
            case 102: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 43: {
                throw IfxErrMsg.getSQLException((int)-79861, (String)"", (Locale)this.locale);
            }
            default: {
                throw IfxErrMsg.getSQLException((int)-79862, (String)"", (Locale)this.locale);
            }
        }
    }

    private boolean isValidCastType(int n) {
        return n >= 0 && n <= 8 || n >= 10 && n <= 18 || n == 43 || n == 45 || n == 101 || n == 102 || n == 44 || n == 46 || n == 47;
    }

    private void checkfield(int n) throws SQLException {
        if (n <= 0 || n > this.fieldCount) {
            throw IfxErrMsg.getSQLException((int)-79859, (String)"", (Locale)this.locale);
        }
    }

    class castinfo {
        int ifxtype = -1;
        String methodsqlname = null;

        castinfo(int n, String string) {
            this.ifxtype = n;
            this.methodsqlname = string;
        }
    }

    class supportudrinfo {
        Method method = null;
        String sqlname = null;
        int type = -1;

        supportudrinfo(Method method, String string, int n) {
            this.method = method;
            this.sqlname = string;
            this.type = n;
        }
    }

    class fieldinfo {
        String name = null;
        int ifxtype = -1;
        String sqltypename = null;
        int precision = -1;
        int scale = -1;
        int length = -1;

        fieldinfo() {
        }
    }
}

