/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.clients;

import java.util.Locale;
import java.util.Optional;
import kafkashaded.org.apache.kafka.common.config.AbstractConfig;
import kafkashaded.org.apache.kafka.common.requests.JoinGroupRequest;

public class GroupRebalanceConfig {
    public final int sessionTimeoutMs;
    public final int rebalanceTimeoutMs;
    public final int heartbeatIntervalMs;
    public final String groupId;
    public final Optional<String> groupInstanceId;
    public final long retryBackoffMs;
    public final boolean leaveGroupOnClose;

    public GroupRebalanceConfig(AbstractConfig config, ProtocolType protocolType) {
        this.sessionTimeoutMs = config.getInt("session.timeout.ms");
        this.rebalanceTimeoutMs = protocolType == ProtocolType.CONSUMER ? config.getInt("max.poll.interval.ms").intValue() : config.getInt("rebalance.timeout.ms").intValue();
        this.heartbeatIntervalMs = config.getInt("heartbeat.interval.ms");
        this.groupId = config.getString("group.id");
        if (protocolType == ProtocolType.CONSUMER) {
            String groupInstanceId = config.getString("group.instance.id");
            if (groupInstanceId != null) {
                JoinGroupRequest.validateGroupInstanceId(groupInstanceId);
                this.groupInstanceId = Optional.of(groupInstanceId);
            } else {
                this.groupInstanceId = Optional.empty();
            }
        } else {
            this.groupInstanceId = Optional.empty();
        }
        this.retryBackoffMs = config.getLong("retry.backoff.ms");
        this.leaveGroupOnClose = protocolType == ProtocolType.CONSUMER ? config.getBoolean("internal.leave.group.on.close") : true;
    }

    public GroupRebalanceConfig(int sessionTimeoutMs, int rebalanceTimeoutMs, int heartbeatIntervalMs, String groupId, Optional<String> groupInstanceId, long retryBackoffMs, boolean leaveGroupOnClose) {
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.groupId = groupId;
        this.groupInstanceId = groupInstanceId;
        this.retryBackoffMs = retryBackoffMs;
        this.leaveGroupOnClose = leaveGroupOnClose;
    }

    public static enum ProtocolType {
        CONSUMER,
        CONNECT;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

