/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kafkashaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import kafkashaded.org.apache.kafka.common.protocol.ApiMessage;
import kafkashaded.org.apache.kafka.common.protocol.Message;
import kafkashaded.org.apache.kafka.common.protocol.MessageUtil;
import kafkashaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import kafkashaded.org.apache.kafka.common.protocol.Readable;
import kafkashaded.org.apache.kafka.common.protocol.Writable;
import kafkashaded.org.apache.kafka.common.protocol.types.ArrayOf;
import kafkashaded.org.apache.kafka.common.protocol.types.Field;
import kafkashaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import kafkashaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import kafkashaded.org.apache.kafka.common.protocol.types.Schema;
import kafkashaded.org.apache.kafka.common.protocol.types.Struct;
import kafkashaded.org.apache.kafka.common.protocol.types.Type;
import kafkashaded.org.apache.kafka.common.utils.ByteUtils;

public class DescribeClientQuotasRequestData
implements ApiMessage {
    private List<ComponentData> components;
    private boolean strict;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("components", new ArrayOf(ComponentData.SCHEMA_0), "Filter components to apply to quota entities."), new Field("strict", Type.BOOLEAN, "Whether the match is strict, i.e. should exclude entities with unspecified entity types."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public DescribeClientQuotasRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeClientQuotasRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeClientQuotasRequestData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public DescribeClientQuotasRequestData() {
        this.components = new ArrayList<ComponentData>(0);
        this.strict = false;
    }

    @Override
    public short apiKey() {
        return 48;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field components was serialized as null");
        }
        ArrayList<ComponentData> newCollection = new ArrayList<ComponentData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ComponentData(_readable, _version));
        }
        this.components = newCollection;
        this.strict = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.components.size());
        for (ComponentData componentsElement : this.components) {
            componentsElement.write(_writable, _cache, _version);
        }
        _writable.writeByte(this.strict ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("components");
        this.components = new ArrayList<ComponentData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.components.add(new ComponentData((Struct)nestedObject, _version));
        }
        this.strict = struct.getBoolean("strict");
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.components.size()];
        int i = 0;
        for (ComponentData element : this.components) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("components", (Object)_nestedObjects);
        struct.set("strict", (Object)this.strict);
        return struct;
    }

    @Override
    public void fromJson(JsonNode _node, short _version) {
        JsonNode _componentsNode = _node.get("components");
        if (_componentsNode == null) {
            throw new RuntimeException("DescribeClientQuotasRequestData: unable to locate field 'components', which is mandatory in version " + _version);
        }
        if (!_componentsNode.isArray()) {
            throw new RuntimeException("DescribeClientQuotasRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        this.components = new ArrayList<ComponentData>();
        for (JsonNode _element : _componentsNode) {
            this.components.add(new ComponentData(_element, _version));
        }
        JsonNode _strictNode = _node.get("strict");
        if (_strictNode == null) {
            throw new RuntimeException("DescribeClientQuotasRequestData: unable to locate field 'strict', which is mandatory in version " + _version);
        }
        if (!_strictNode.isBoolean()) {
            throw new RuntimeException("DescribeClientQuotasRequestData expected Boolean type, but got " + _node.getNodeType());
        }
        this.strict = _strictNode.asBoolean();
    }

    @Override
    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _componentsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ComponentData _element : this.components) {
            _componentsArray.add(_element.toJson(_version));
        }
        _node.set("components", (JsonNode)_componentsArray);
        _node.set("strict", (JsonNode)BooleanNode.valueOf((boolean)this.strict));
        return _node;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (ComponentData componentsElement : this.components) {
            _arraySize += componentsElement.size(_cache, _version);
        }
        _size += _arraySize;
        ++_size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeClientQuotasRequestData)) {
            return false;
        }
        DescribeClientQuotasRequestData other = (DescribeClientQuotasRequestData)obj;
        if (this.components == null ? other.components != null : !this.components.equals(other.components)) {
            return false;
        }
        return this.strict == other.strict;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.components == null ? 0 : this.components.hashCode());
        hashCode = 31 * hashCode + (this.strict ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public DescribeClientQuotasRequestData duplicate() {
        DescribeClientQuotasRequestData _duplicate = new DescribeClientQuotasRequestData();
        ArrayList<ComponentData> newComponents = new ArrayList<ComponentData>(this.components.size());
        for (ComponentData _element : this.components) {
            newComponents.add(_element.duplicate());
        }
        _duplicate.components = newComponents;
        _duplicate.strict = this.strict;
        return _duplicate;
    }

    public String toString() {
        return "DescribeClientQuotasRequestData(components=" + MessageUtil.deepToString(this.components.iterator()) + ", strict=" + (this.strict ? "true" : "false") + ")";
    }

    public List<ComponentData> components() {
        return this.components;
    }

    public boolean strict() {
        return this.strict;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeClientQuotasRequestData setComponents(List<ComponentData> v) {
        this.components = v;
        return this;
    }

    public DescribeClientQuotasRequestData setStrict(boolean v) {
        this.strict = v;
        return this;
    }

    public static class ComponentData
    implements Message {
        private String entityType;
        private byte matchType;
        private String match;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("entity_type", Type.STRING, "The entity type that the filter component applies to."), new Field("match_type", Type.INT8, "How to match the entity {0 = exact name, 1 = default name, 2 = any specified name}."), new Field("match", Type.NULLABLE_STRING, "The string to match against, or null if unused for the match type."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public ComponentData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ComponentData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ComponentData(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public ComponentData() {
            this.entityType = "";
            this.matchType = 0;
            this.match = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ComponentData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field entityType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field entityType had invalid length " + length);
            }
            this.entityType = _readable.readString(length);
            this.matchType = _readable.readByte();
            length = _readable.readShort();
            if (length < 0) {
                this.match = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field match had invalid length " + length);
                }
                this.match = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.entityType);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.matchType);
            if (this.match == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.match);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ComponentData");
            }
            this._unknownTaggedFields = null;
            this.entityType = struct.getString("entity_type");
            this.matchType = struct.getByte("match_type");
            this.match = struct.getString("match");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ComponentData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("entity_type", (Object)this.entityType);
            struct.set("match_type", (Object)this.matchType);
            struct.set("match", (Object)this.match);
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _entityTypeNode = _node.get("entityType");
            if (_entityTypeNode == null) {
                throw new RuntimeException("ComponentData: unable to locate field 'entityType', which is mandatory in version " + _version);
            }
            if (!_entityTypeNode.isTextual()) {
                throw new RuntimeException("ComponentData expected a string type, but got " + _node.getNodeType());
            }
            this.entityType = _entityTypeNode.asText();
            JsonNode _matchTypeNode = _node.get("matchType");
            if (_matchTypeNode == null) {
                throw new RuntimeException("ComponentData: unable to locate field 'matchType', which is mandatory in version " + _version);
            }
            this.matchType = MessageUtil.jsonNodeToByte(_matchTypeNode, "ComponentData");
            JsonNode _matchNode = _node.get("match");
            if (_matchNode == null) {
                throw new RuntimeException("ComponentData: unable to locate field 'match', which is mandatory in version " + _version);
            }
            if (_matchNode.isNull()) {
                this.match = null;
            } else {
                if (!_matchNode.isTextual()) {
                    throw new RuntimeException("ComponentData expected a string type, but got " + _node.getNodeType());
                }
                this.match = _matchNode.asText();
            }
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("entityType", (JsonNode)new TextNode(this.entityType));
            _node.set("matchType", (JsonNode)new ShortNode((short)this.matchType));
            if (this.match == null) {
                _node.set("match", (JsonNode)NullNode.instance);
            } else {
                _node.set("match", (JsonNode)new TextNode(this.match));
            }
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ComponentData");
            }
            byte[] _stringBytes = this.entityType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'entityType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.entityType, _stringBytes);
            _size += _stringBytes.length + 2;
            ++_size;
            if (this.match == null) {
                _size += 2;
            } else {
                _stringBytes = this.match.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'match' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.match, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComponentData)) {
                return false;
            }
            ComponentData other = (ComponentData)obj;
            if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
                return false;
            }
            if (this.matchType != other.matchType) {
                return false;
            }
            return !(this.match == null ? other.match != null : !this.match.equals(other.match));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.entityType == null ? 0 : this.entityType.hashCode());
            hashCode = 31 * hashCode + this.matchType;
            hashCode = 31 * hashCode + (this.match == null ? 0 : this.match.hashCode());
            return hashCode;
        }

        @Override
        public ComponentData duplicate() {
            ComponentData _duplicate = new ComponentData();
            _duplicate.entityType = this.entityType;
            _duplicate.matchType = this.matchType;
            _duplicate.match = this.match == null ? null : this.match;
            return _duplicate;
        }

        public String toString() {
            return "ComponentData(entityType=" + (this.entityType == null ? "null" : "'" + this.entityType.toString() + "'") + ", matchType=" + this.matchType + ", match=" + (this.match == null ? "null" : "'" + this.match.toString() + "'") + ")";
        }

        public String entityType() {
            return this.entityType;
        }

        public byte matchType() {
            return this.matchType;
        }

        public String match() {
            return this.match;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ComponentData setEntityType(String v) {
            this.entityType = v;
            return this;
        }

        public ComponentData setMatchType(byte v) {
            this.matchType = v;
            return this;
        }

        public ComponentData setMatch(String v) {
            this.match = v;
            return this;
        }
    }
}

