/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kafkashaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import kafkashaded.org.apache.kafka.common.protocol.ApiMessage;
import kafkashaded.org.apache.kafka.common.protocol.Message;
import kafkashaded.org.apache.kafka.common.protocol.MessageUtil;
import kafkashaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import kafkashaded.org.apache.kafka.common.protocol.Readable;
import kafkashaded.org.apache.kafka.common.protocol.Writable;
import kafkashaded.org.apache.kafka.common.protocol.types.ArrayOf;
import kafkashaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import kafkashaded.org.apache.kafka.common.protocol.types.Field;
import kafkashaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import kafkashaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import kafkashaded.org.apache.kafka.common.protocol.types.Schema;
import kafkashaded.org.apache.kafka.common.protocol.types.Struct;
import kafkashaded.org.apache.kafka.common.protocol.types.Type;
import kafkashaded.org.apache.kafka.common.utils.ByteUtils;

public class ElectLeadersResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private List<ReplicaElectionResult> replicaElectionResults;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("replica_election_results", new ArrayOf(ReplicaElectionResult.SCHEMA_0), "The election results, or an empty array if the requester did not have permission and the request asks for all partitions."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top level response error code."), new Field("replica_election_results", new ArrayOf(ReplicaElectionResult.SCHEMA_0), "The election results, or an empty array if the requester did not have permission and the request asks for all partitions."));
    public static final Schema SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top level response error code."), new Field("replica_election_results", new CompactArrayOf(ReplicaElectionResult.SCHEMA_2), "The election results, or an empty array if the requester did not have permission and the request asks for all partitions."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

    public ElectLeadersResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ElectLeadersResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ElectLeadersResponseData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public ElectLeadersResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.replicaElectionResults = new ArrayList<ReplicaElectionResult>(0);
    }

    @Override
    public short apiKey() {
        return 43;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<ReplicaElectionResult> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _version >= 1 ? _readable.readShort() : (short)0;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicaElectionResults was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ReplicaElectionResult(_readable, _version));
            }
            this.replicaElectionResults = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicaElectionResults was serialized as null");
            }
            newCollection = new ArrayList<ReplicaElectionResult>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ReplicaElectionResult(_readable, _version));
            }
            this.replicaElectionResults = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 1) {
            _writable.writeShort(this.errorCode);
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + _version);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.replicaElectionResults.size() + 1);
            for (ReplicaElectionResult replicaElectionResultsElement : this.replicaElectionResults) {
                replicaElectionResultsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.replicaElectionResults.size());
            for (ReplicaElectionResult replicaElectionResultsElement : this.replicaElectionResults) {
                replicaElectionResultsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = _version >= 1 ? struct.getShort("error_code") : (short)0;
        Object[] _nestedObjects = struct.getArray("replica_election_results");
        this.replicaElectionResults = new ArrayList<ReplicaElectionResult>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.replicaElectionResults.add(new ReplicaElectionResult((Struct)nestedObject, _version));
        }
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        if (_version >= 1) {
            struct.set("error_code", (Object)this.errorCode);
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + _version);
        }
        Struct[] _nestedObjects = new Struct[this.replicaElectionResults.size()];
        int i = 0;
        for (ReplicaElectionResult element : this.replicaElectionResults) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("replica_election_results", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public void fromJson(JsonNode _node, short _version) {
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("ElectLeadersResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        this.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "ElectLeadersResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("ElectLeadersResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            this.errorCode = 0;
        } else {
            this.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "ElectLeadersResponseData");
        }
        JsonNode _replicaElectionResultsNode = _node.get("replicaElectionResults");
        if (_replicaElectionResultsNode == null) {
            throw new RuntimeException("ElectLeadersResponseData: unable to locate field 'replicaElectionResults', which is mandatory in version " + _version);
        }
        if (!_replicaElectionResultsNode.isArray()) {
            throw new RuntimeException("ElectLeadersResponseData expected a JSON array, but got " + _node.getNodeType());
        }
        this.replicaElectionResults = new ArrayList<ReplicaElectionResult>();
        for (JsonNode _element : _replicaElectionResultsNode) {
            this.replicaElectionResults.add(new ReplicaElectionResult(_element, _version));
        }
    }

    @Override
    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(this.throttleTimeMs));
        if (_version >= 1) {
            _node.set("errorCode", (JsonNode)new ShortNode(this.errorCode));
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + _version);
        }
        ArrayNode _replicaElectionResultsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ReplicaElectionResult _element : this.replicaElectionResults) {
            _replicaElectionResultsArray.add(_element.toJson(_version));
        }
        _node.set("replicaElectionResults", (JsonNode)_replicaElectionResultsArray);
        return _node;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        if (_version >= 1) {
            _size += 2;
        }
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.replicaElectionResults.size() + 1)) : (_arraySize += 4);
        for (ReplicaElectionResult replicaElectionResultsElement : this.replicaElectionResults) {
            _arraySize += replicaElectionResultsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElectLeadersResponseData)) {
            return false;
        }
        ElectLeadersResponseData other = (ElectLeadersResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.replicaElectionResults == null ? other.replicaElectionResults != null : !this.replicaElectionResults.equals(other.replicaElectionResults));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.replicaElectionResults == null ? 0 : this.replicaElectionResults.hashCode());
        return hashCode;
    }

    @Override
    public ElectLeadersResponseData duplicate() {
        ElectLeadersResponseData _duplicate = new ElectLeadersResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        ArrayList<ReplicaElectionResult> newReplicaElectionResults = new ArrayList<ReplicaElectionResult>(this.replicaElectionResults.size());
        for (ReplicaElectionResult _element : this.replicaElectionResults) {
            newReplicaElectionResults.add(_element.duplicate());
        }
        _duplicate.replicaElectionResults = newReplicaElectionResults;
        return _duplicate;
    }

    public String toString() {
        return "ElectLeadersResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", replicaElectionResults=" + MessageUtil.deepToString(this.replicaElectionResults.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<ReplicaElectionResult> replicaElectionResults() {
        return this.replicaElectionResults;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ElectLeadersResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ElectLeadersResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ElectLeadersResponseData setReplicaElectionResults(List<ReplicaElectionResult> v) {
        this.replicaElectionResults = v;
        return this;
    }

    public static class PartitionResult
    implements Message {
        private int partitionId;
        private short errorCode;
        private String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public PartitionResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public PartitionResult(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public PartitionResult() {
            this.partitionId = 0;
            this.errorCode = 0;
            this.errorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionResult");
            }
            this.partitionId = _readable.readInt();
            this.errorCode = _readable.readShort();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionId);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.partitionId = struct.getInt("partition_id");
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PartitionResult");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_id", (Object)this.partitionId);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _partitionIdNode = _node.get("partitionId");
            if (_partitionIdNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'partitionId', which is mandatory in version " + _version);
            }
            this.partitionId = MessageUtil.jsonNodeToInt(_partitionIdNode, "PartitionResult");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            this.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "PartitionResult");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (_errorMessageNode.isNull()) {
                this.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("PartitionResult expected a string type, but got " + _node.getNodeType());
                }
                this.errorMessage = _errorMessageNode.asText();
            }
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionId", (JsonNode)new IntNode(this.partitionId));
            _node.set("errorCode", (JsonNode)new ShortNode(this.errorCode));
            if (this.errorMessage == null) {
                _node.set("errorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("errorMessage", (JsonNode)new TextNode(this.errorMessage));
            }
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionResult");
            }
            _size += 4;
            _size += 2;
            if (this.errorMessage == null) {
                _size = _version >= 2 ? ++_size : (_size += 2);
            } else {
                byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionResult)) {
                return false;
            }
            PartitionResult other = (PartitionResult)obj;
            if (this.partitionId != other.partitionId) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return !(this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionId;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        @Override
        public PartitionResult duplicate() {
            PartitionResult _duplicate = new PartitionResult();
            _duplicate.partitionId = this.partitionId;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "PartitionResult(partitionId=" + this.partitionId + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public int partitionId() {
            return this.partitionId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionResult setPartitionId(int v) {
            this.partitionId = v;
            return this;
        }

        public PartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_id", Type.INT32, "The partition id"), new Field("error_code", Type.INT16, "The result error, or zero if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The result message, or null if there was no error."));
            SCHEMA_2 = new Schema(new Field("partition_id", Type.INT32, "The partition id"), new Field("error_code", Type.INT16, "The result error, or zero if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The result message, or null if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class ReplicaElectionResult
    implements Message {
        private String topic;
        private List<PartitionResult> partitionResult;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public ReplicaElectionResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ReplicaElectionResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ReplicaElectionResult(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public ReplicaElectionResult() {
            this.topic = "";
            this.partitionResult = new ArrayList<PartitionResult>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<PartitionResult> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReplicaElectionResult");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionResult was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionResult(_readable, _version));
                }
                this.partitionResult = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionResult was serialized as null");
                }
                newCollection = new ArrayList<PartitionResult>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionResult(_readable, _version));
                }
                this.partitionResult = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitionResult.size() + 1);
                _stringBytes = this.partitionResult.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionResult partitionResultElement = (PartitionResult)_stringBytes.next();
                    partitionResultElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitionResult.size());
                _stringBytes = this.partitionResult.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionResult partitionResultElement = (PartitionResult)_stringBytes.next();
                    partitionResultElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReplicaElectionResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topic = struct.getString("topic");
            Object[] _nestedObjects = struct.getArray("partition_result");
            this.partitionResult = new ArrayList<PartitionResult>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionResult.add(new PartitionResult((Struct)nestedObject, _version));
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ReplicaElectionResult");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic", (Object)this.topic);
            Struct[] _nestedObjects = new Struct[this.partitionResult.size()];
            int i = 0;
            for (PartitionResult element : this.partitionResult) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partition_result", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("ReplicaElectionResult: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("ReplicaElectionResult expected a string type, but got " + _node.getNodeType());
            }
            this.topic = _topicNode.asText();
            JsonNode _partitionResultNode = _node.get("partitionResult");
            if (_partitionResultNode == null) {
                throw new RuntimeException("ReplicaElectionResult: unable to locate field 'partitionResult', which is mandatory in version " + _version);
            }
            if (!_partitionResultNode.isArray()) {
                throw new RuntimeException("ReplicaElectionResult expected a JSON array, but got " + _node.getNodeType());
            }
            this.partitionResult = new ArrayList<PartitionResult>();
            for (JsonNode _element : _partitionResultNode) {
                this.partitionResult.add(new PartitionResult(_element, _version));
            }
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(this.topic));
            ArrayNode _partitionResultArray = new ArrayNode(JsonNodeFactory.instance);
            for (PartitionResult _element : this.partitionResult) {
                _partitionResultArray.add(_element.toJson(_version));
            }
            _node.set("partitionResult", (JsonNode)_partitionResultArray);
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ReplicaElectionResult");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.partitionResult.size() + 1)) : (_arraySize += 4);
            for (PartitionResult partitionResultElement : this.partitionResult) {
                _arraySize += partitionResultElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReplicaElectionResult)) {
                return false;
            }
            ReplicaElectionResult other = (ReplicaElectionResult)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            return !(this.partitionResult == null ? other.partitionResult != null : !this.partitionResult.equals(other.partitionResult));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionResult == null ? 0 : this.partitionResult.hashCode());
            return hashCode;
        }

        @Override
        public ReplicaElectionResult duplicate() {
            ReplicaElectionResult _duplicate = new ReplicaElectionResult();
            _duplicate.topic = this.topic;
            ArrayList<PartitionResult> newPartitionResult = new ArrayList<PartitionResult>(this.partitionResult.size());
            for (PartitionResult _element : this.partitionResult) {
                newPartitionResult.add(_element.duplicate());
            }
            _duplicate.partitionResult = newPartitionResult;
            return _duplicate;
        }

        public String toString() {
            return "ReplicaElectionResult(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitionResult=" + MessageUtil.deepToString(this.partitionResult.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<PartitionResult> partitionResult() {
            return this.partitionResult;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReplicaElectionResult setTopic(String v) {
            this.topic = v;
            return this;
        }

        public ReplicaElectionResult setPartitionResult(List<PartitionResult> v) {
            this.partitionResult = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The topic name"), new Field("partition_result", new ArrayOf(PartitionResult.SCHEMA_0), "The results for each partition"));
            SCHEMA_2 = new Schema(new Field("topic", Type.COMPACT_STRING, "The topic name"), new Field("partition_result", new CompactArrayOf(PartitionResult.SCHEMA_2), "The results for each partition"), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

