/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import kafkashaded.org.apache.kafka.common.header.Header;
import kafkashaded.org.apache.kafka.common.record.Record;
import kafkashaded.org.apache.kafka.common.utils.Utils;

public class SimpleRecord {
    private final ByteBuffer key;
    private final ByteBuffer value;
    private final long timestamp;
    private final Header[] headers;

    public SimpleRecord(long timestamp, ByteBuffer key, ByteBuffer value, Header[] headers) {
        Objects.requireNonNull(headers, "Headers must be non-null");
        this.key = key;
        this.value = value;
        this.timestamp = timestamp;
        this.headers = headers;
    }

    public SimpleRecord(long timestamp, byte[] key, byte[] value, Header[] headers) {
        this(timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value), headers);
    }

    public SimpleRecord(long timestamp, ByteBuffer key, ByteBuffer value) {
        this(timestamp, key, value, Record.EMPTY_HEADERS);
    }

    public SimpleRecord(long timestamp, byte[] key, byte[] value) {
        this(timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value));
    }

    public SimpleRecord(long timestamp, byte[] value) {
        this(timestamp, null, value);
    }

    public SimpleRecord(byte[] value) {
        this(-1L, null, value);
    }

    public SimpleRecord(byte[] key, byte[] value) {
        this(-1L, key, value);
    }

    public SimpleRecord(Record record) {
        this(record.timestamp(), record.key(), record.value(), record.headers());
    }

    public ByteBuffer key() {
        return this.key;
    }

    public ByteBuffer value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Header[] headers() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRecord that = (SimpleRecord)o;
        return this.timestamp == that.timestamp && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Arrays.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + Long.hashCode(this.timestamp);
        result = 31 * result + Arrays.hashCode(this.headers);
        return result;
    }

    public String toString() {
        return String.format("SimpleRecord(timestamp=%d, key=%d bytes, value=%d bytes)", this.timestamp(), this.key == null ? 0 : this.key.limit(), this.value == null ? 0 : this.value.limit());
    }
}

