/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kafkashaded.org.apache.kafka.common.ElectionType;
import kafkashaded.org.apache.kafka.common.TopicPartition;
import kafkashaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import kafkashaded.org.apache.kafka.common.message.ElectLeadersRequestData;
import kafkashaded.org.apache.kafka.common.message.ElectLeadersResponseData;
import kafkashaded.org.apache.kafka.common.protocol.ApiKeys;
import kafkashaded.org.apache.kafka.common.protocol.MessageUtil;
import kafkashaded.org.apache.kafka.common.protocol.types.Struct;
import kafkashaded.org.apache.kafka.common.requests.AbstractRequest;
import kafkashaded.org.apache.kafka.common.requests.AbstractResponse;
import kafkashaded.org.apache.kafka.common.requests.ApiError;
import kafkashaded.org.apache.kafka.common.requests.ElectLeadersResponse;
import kafkashaded.org.apache.kafka.common.utils.CollectionUtils;

public class ElectLeadersRequest
extends AbstractRequest {
    private final ElectLeadersRequestData data;

    private ElectLeadersRequest(ElectLeadersRequestData data, short version) {
        super(ApiKeys.ELECT_LEADERS, version);
        this.data = data;
    }

    public ElectLeadersRequest(Struct struct, short version) {
        super(ApiKeys.ELECT_LEADERS, version);
        this.data = new ElectLeadersRequestData(struct, version);
    }

    public ElectLeadersRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ArrayList<ElectLeadersResponseData.ReplicaElectionResult> electionResults = new ArrayList<ElectLeadersResponseData.ReplicaElectionResult>();
        for (ElectLeadersRequestData.TopicPartitions topic : this.data.topicPartitions()) {
            ElectLeadersResponseData.ReplicaElectionResult electionResult = new ElectLeadersResponseData.ReplicaElectionResult();
            electionResult.setTopic(topic.topic());
            for (Integer partitionId : topic.partitionId()) {
                ElectLeadersResponseData.PartitionResult partitionResult = new ElectLeadersResponseData.PartitionResult();
                partitionResult.setPartitionId(partitionId);
                partitionResult.setErrorCode(apiError.error().code());
                partitionResult.setErrorMessage(apiError.message());
                electionResult.partitionResult().add(partitionResult);
            }
            electionResults.add(electionResult);
        }
        return new ElectLeadersResponse(throttleTimeMs, apiError.error().code(), electionResults, this.version());
    }

    public static ElectLeadersRequest parse(ByteBuffer buffer, short version) {
        return new ElectLeadersRequest(ApiKeys.ELECT_LEADERS.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<ElectLeadersRequest> {
        private final ElectionType electionType;
        private final Collection<TopicPartition> topicPartitions;
        private final int timeoutMs;

        public Builder(ElectionType electionType, Collection<TopicPartition> topicPartitions, int timeoutMs) {
            super(ApiKeys.ELECT_LEADERS);
            this.electionType = electionType;
            this.topicPartitions = topicPartitions;
            this.timeoutMs = timeoutMs;
        }

        @Override
        public ElectLeadersRequest build(short version) {
            return new ElectLeadersRequest(this.toRequestData(version), version);
        }

        public String toString() {
            return "ElectLeadersRequest(electionType=" + (Object)((Object)this.electionType) + ", topicPartitions=" + (this.topicPartitions == null ? "null" : MessageUtil.deepToString(this.topicPartitions.iterator())) + ", timeoutMs=" + this.timeoutMs + ")";
        }

        private ElectLeadersRequestData toRequestData(short version) {
            if (this.electionType != ElectionType.PREFERRED && version == 0) {
                throw new UnsupportedVersionException("API Version 0 only supports PREFERRED election type");
            }
            ElectLeadersRequestData data = new ElectLeadersRequestData().setTimeoutMs(this.timeoutMs);
            if (this.topicPartitions != null) {
                for (Map.Entry<String, List<Integer>> tp : CollectionUtils.groupPartitionsByTopic(this.topicPartitions).entrySet()) {
                    data.topicPartitions().add(new ElectLeadersRequestData.TopicPartitions().setTopic(tp.getKey()).setPartitionId(tp.getValue()));
                }
            } else {
                data.setTopicPartitions(null);
            }
            data.setElectionType(this.electionType.value);
            return data;
        }
    }
}

