/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import kafkashaded.org.apache.kafka.common.message.EndTxnRequestData;
import kafkashaded.org.apache.kafka.common.message.EndTxnResponseData;
import kafkashaded.org.apache.kafka.common.protocol.ApiKeys;
import kafkashaded.org.apache.kafka.common.protocol.Errors;
import kafkashaded.org.apache.kafka.common.protocol.types.Struct;
import kafkashaded.org.apache.kafka.common.requests.AbstractRequest;
import kafkashaded.org.apache.kafka.common.requests.EndTxnResponse;
import kafkashaded.org.apache.kafka.common.requests.TransactionResult;

public class EndTxnRequest
extends AbstractRequest {
    public final EndTxnRequestData data;

    private EndTxnRequest(EndTxnRequestData data, short version) {
        super(ApiKeys.END_TXN, version);
        this.data = data;
    }

    public EndTxnRequest(Struct struct, short version) {
        super(ApiKeys.END_TXN, version);
        this.data = new EndTxnRequestData(struct, version);
    }

    public TransactionResult result() {
        if (this.data.committed()) {
            return TransactionResult.COMMIT;
        }
        return TransactionResult.ABORT;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public EndTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new EndTxnResponse(new EndTxnResponseData().setErrorCode(Errors.forException(e).code()).setThrottleTimeMs(throttleTimeMs));
    }

    public static EndTxnRequest parse(ByteBuffer buffer, short version) {
        return new EndTxnRequest(ApiKeys.END_TXN.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<EndTxnRequest> {
        public final EndTxnRequestData data;

        public Builder(EndTxnRequestData data) {
            super(ApiKeys.END_TXN);
            this.data = data;
        }

        @Override
        public EndTxnRequest build(short version) {
            return new EndTxnRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

