/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import kafkashaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import kafkashaded.org.apache.kafka.common.message.HeartbeatRequestData;
import kafkashaded.org.apache.kafka.common.message.HeartbeatResponseData;
import kafkashaded.org.apache.kafka.common.protocol.ApiKeys;
import kafkashaded.org.apache.kafka.common.protocol.Errors;
import kafkashaded.org.apache.kafka.common.protocol.types.Struct;
import kafkashaded.org.apache.kafka.common.requests.AbstractRequest;
import kafkashaded.org.apache.kafka.common.requests.AbstractResponse;
import kafkashaded.org.apache.kafka.common.requests.HeartbeatResponse;

public class HeartbeatRequest
extends AbstractRequest {
    public final HeartbeatRequestData data;

    private HeartbeatRequest(HeartbeatRequestData data, short version) {
        super(ApiKeys.HEARTBEAT, version);
        this.data = data;
    }

    public HeartbeatRequest(Struct struct, short version) {
        super(ApiKeys.HEARTBEAT, version);
        this.data = new HeartbeatRequestData(struct, version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HeartbeatResponseData responseData = new HeartbeatResponseData().setErrorCode(Errors.forException(e).code());
        if (this.version() >= 1) {
            responseData.setThrottleTimeMs(throttleTimeMs);
        }
        return new HeartbeatResponse(responseData);
    }

    public static HeartbeatRequest parse(ByteBuffer buffer, short version) {
        return new HeartbeatRequest(ApiKeys.HEARTBEAT.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<HeartbeatRequest> {
        private final HeartbeatRequestData data;

        public Builder(HeartbeatRequestData data) {
            super(ApiKeys.HEARTBEAT);
            this.data = data;
        }

        @Override
        public HeartbeatRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 3) {
                throw new UnsupportedVersionException("The broker heartbeat protocol version " + version + " does not support usage of config group.instance.id.");
            }
            return new HeartbeatRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

