/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kafkashaded.org.apache.kafka.common.TopicPartition;
import kafkashaded.org.apache.kafka.common.message.WriteTxnMarkersResponseData;
import kafkashaded.org.apache.kafka.common.protocol.ApiKeys;
import kafkashaded.org.apache.kafka.common.protocol.Errors;
import kafkashaded.org.apache.kafka.common.protocol.types.Struct;
import kafkashaded.org.apache.kafka.common.requests.AbstractResponse;

public class WriteTxnMarkersResponse
extends AbstractResponse {
    private final Map<Long, Map<TopicPartition, Errors>> errors;
    public final WriteTxnMarkersResponseData data;

    public WriteTxnMarkersResponse(Map<Long, Map<TopicPartition, Errors>> errors) {
        ArrayList<WriteTxnMarkersResponseData.WritableTxnMarkerResult> markers = new ArrayList<WriteTxnMarkersResponseData.WritableTxnMarkerResult>();
        for (Map.Entry<Long, Map<TopicPartition, Errors>> markerEntry : errors.entrySet()) {
            HashMap<String, WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult> responseTopicDataMap = new HashMap<String, WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult>();
            for (Map.Entry<TopicPartition, Errors> topicEntry : markerEntry.getValue().entrySet()) {
                TopicPartition topicPartition = topicEntry.getKey();
                String topicName = topicPartition.topic();
                WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topic = responseTopicDataMap.getOrDefault(topicName, new WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult().setName(topicName));
                topic.partitions().add(new WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult().setErrorCode(topicEntry.getValue().code()).setPartitionIndex(topicPartition.partition()));
                responseTopicDataMap.put(topicName, topic);
            }
            markers.add(new WriteTxnMarkersResponseData.WritableTxnMarkerResult().setProducerId(markerEntry.getKey()).setTopics(new ArrayList<WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult>(responseTopicDataMap.values())));
        }
        this.errors = errors;
        this.data = new WriteTxnMarkersResponseData().setMarkers(markers);
    }

    public WriteTxnMarkersResponse(Struct struct, short version) {
        this.data = new WriteTxnMarkersResponseData(struct, version);
        this.errors = new HashMap<Long, Map<TopicPartition, Errors>>();
        for (WriteTxnMarkersResponseData.WritableTxnMarkerResult marker : this.data.markers()) {
            HashMap<TopicPartition, Errors> topicPartitionErrorsMap = new HashMap<TopicPartition, Errors>();
            for (WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topic : marker.topics()) {
                for (WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResult : topic.partitions()) {
                    topicPartitionErrorsMap.put(new TopicPartition(topic.name(), partitionResult.partitionIndex()), Errors.forCode(partitionResult.errorCode()));
                }
            }
            this.errors.put(marker.producerId(), topicPartitionErrorsMap);
        }
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public Map<TopicPartition, Errors> errors(long producerId) {
        return this.errors.get(producerId);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.errors.values().forEach(allErrors -> allErrors.values().forEach(error -> this.updateErrorCounts(errorCounts, (Errors)((Object)((Object)error)))));
        return errorCounts;
    }

    public static WriteTxnMarkersResponse parse(ByteBuffer buffer, short version) {
        return new WriteTxnMarkersResponse(ApiKeys.WRITE_TXN_MARKERS.parseResponse(version, buffer), version);
    }
}

