/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.security.oauthbearer.internals.expiring;

import java.util.Map;
import java.util.Objects;

public class ExpiringCredentialRefreshConfig {
    private final double loginRefreshWindowFactor;
    private final double loginRefreshWindowJitter;
    private final short loginRefreshMinPeriodSeconds;
    private final short loginRefreshBufferSeconds;
    private final boolean loginRefreshReloginAllowedBeforeLogout;

    public ExpiringCredentialRefreshConfig(Map<String, ?> configs, boolean clientReloginAllowedBeforeLogout) {
        Objects.requireNonNull(configs);
        this.loginRefreshWindowFactor = (Double)configs.get("sasl.login.refresh.window.factor");
        this.loginRefreshWindowJitter = (Double)configs.get("sasl.login.refresh.window.jitter");
        this.loginRefreshMinPeriodSeconds = (Short)configs.get("sasl.login.refresh.min.period.seconds");
        this.loginRefreshBufferSeconds = (Short)configs.get("sasl.login.refresh.buffer.seconds");
        this.loginRefreshReloginAllowedBeforeLogout = clientReloginAllowedBeforeLogout;
    }

    public double loginRefreshWindowFactor() {
        return this.loginRefreshWindowFactor;
    }

    public double loginRefreshWindowJitter() {
        return this.loginRefreshWindowJitter;
    }

    public short loginRefreshMinPeriodSeconds() {
        return this.loginRefreshMinPeriodSeconds;
    }

    public short loginRefreshBufferSeconds() {
        return this.loginRefreshBufferSeconds;
    }

    public boolean loginRefreshReloginAllowedBeforeLogout() {
        return this.loginRefreshReloginAllowedBeforeLogout;
    }
}

