/*
 * Decompiled with CFR 0.152.
 */
package kafkashaded.org.apache.kafka.common.utils;

import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private static final float REALLOCATION_FACTOR = 1.1f;
    private final int initialCapacity;
    private final int initialPosition;
    private ByteBuffer buffer;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        this.initialPosition = buffer.position();
        this.initialCapacity = buffer.capacity();
    }

    public ByteBufferOutputStream(int initialCapacity) {
        this(initialCapacity, false);
    }

    public ByteBufferOutputStream(int initialCapacity, boolean directBuffer) {
        this(directBuffer ? ByteBuffer.allocateDirect(initialCapacity) : ByteBuffer.allocate(initialCapacity));
    }

    @Override
    public void write(int b) {
        this.ensureRemaining(1);
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.ensureRemaining(len);
        this.buffer.put(bytes, off, len);
    }

    public void write(ByteBuffer sourceBuffer) {
        this.ensureRemaining(sourceBuffer.remaining());
        this.buffer.put(sourceBuffer);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public int position() {
        return this.buffer.position();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public int limit() {
        return this.buffer.limit();
    }

    public void position(int position) {
        this.ensureRemaining(position - this.buffer.position());
        this.buffer.position(position);
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public void ensureRemaining(int remainingBytesRequired) {
        if (remainingBytesRequired > this.buffer.remaining()) {
            this.expandBuffer(remainingBytesRequired);
        }
    }

    private void expandBuffer(int remainingRequired) {
        int expandSize = Math.max((int)((float)this.buffer.limit() * 1.1f), this.buffer.position() + remainingRequired);
        ByteBuffer temp = ByteBuffer.allocate(expandSize);
        int limit = this.limit();
        this.buffer.flip();
        temp.put(this.buffer);
        this.buffer.limit(limit);
        this.buffer.position(this.initialPosition);
        this.buffer = temp;
    }
}

