/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedResponse;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.LDAPTLSSocketFactory;
import netscape.ldap.LDAPTraceWriter;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPUnbindRequest;

class LDAPConnThread
implements Runnable {
    private static final int MAXMSGID = Integer.MAX_VALUE;
    private static final int BACKLOG_CHKCNT = 50;
    private static transient int m_highMsgId;
    private transient InputStream m_serverInput;
    private transient InputStream m_origServerInput;
    private transient OutputStream m_serverOutput;
    private transient OutputStream m_origServerOutput;
    private transient Hashtable m_requests;
    private transient Hashtable m_messages = null;
    private transient Vector m_registered;
    private transient LDAPCache m_cache = null;
    private transient Thread m_thread = null;
    private transient Object m_sendRequestLock = new Object();
    private transient LDAPConnSetupMgr m_connMgr = null;
    private transient Object m_traceOutput = null;
    private transient int m_backlogCheckCounter = 50;
    private transient boolean m_bound;
    private static transient int m_nextId;
    private transient int m_id;
    static SimpleDateFormat m_timeFormat;

    public LDAPConnThread(LDAPConnSetupMgr connMgr, LDAPCache cache, Object traceOutput) {
        this.m_requests = new Hashtable();
        this.m_registered = new Vector();
        this.m_connMgr = connMgr;
        this.setCache(cache);
        this.setTraceOutput(traceOutput);
    }

    synchronized void connect(LDAPConnection ldc) throws LDAPException {
        if (this.m_thread != null) {
            return;
        }
        try {
            this.m_connMgr.openConnection();
            this.m_serverInput = new BufferedInputStream(this.m_connMgr.getSocket().getInputStream());
            this.m_serverOutput = new BufferedOutputStream(this.m_connMgr.getSocket().getOutputStream());
            this.register(ldc);
        }
        catch (IOException e) {
            throw new LDAPException("failed to connect to server " + this.m_connMgr.getHost(), 91);
        }
        this.m_id = m_nextId++;
        String url = this.m_connMgr.getLDAPUrl().getServerUrl();
        if (this.m_traceOutput != null) {
            StringBuffer sb = new StringBuffer(" Connected to ");
            sb.append(url);
            this.logTraceMessage(sb);
        }
        String threadID = "LDAPConnThread-" + this.m_id + " " + url;
        this.m_thread = new Thread((Runnable)this, threadID);
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    public synchronized String toString() {
        if (this.m_thread != null) {
            return this.m_thread.getName();
        }
        return "LDAPConnThread-" + this.m_id + " <disconnected>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void layerSocket(LDAPTLSSocketFactory factory) throws Exception {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            try {
                this.m_connMgr.layerSocket(factory);
                this.setInputStream(this.m_connMgr.getSocket().getInputStream());
                this.setOutputStream(this.m_connMgr.getSocket().getOutputStream());
            }
            catch (Exception e) {
                this.m_serverInput = this.m_origServerInput;
                this.m_serverOutput = this.m_origServerOutput;
                throw e;
            }
        }
    }

    void setBound(boolean bound) {
        this.m_bound = bound;
    }

    boolean isBound() {
        return this.m_thread != null && this.m_bound;
    }

    InputStream getInputStream() {
        return this.m_serverInput;
    }

    void setInputStream(InputStream is) {
        this.m_serverInput = is;
    }

    OutputStream getOutputStream() {
        return this.m_serverOutput;
    }

    void setOutputStream(OutputStream os) {
        this.m_serverOutput = os;
    }

    int getRequestCount() {
        return this.m_requests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTraceOutput(Object traceOutput) {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            if (traceOutput == null) {
                this.m_traceOutput = null;
            } else if (traceOutput instanceof OutputStream) {
                this.m_traceOutput = new PrintWriter((OutputStream)traceOutput);
            } else if (traceOutput instanceof LDAPTraceWriter) {
                this.m_traceOutput = traceOutput;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logTraceMessage(StringBuffer msg) {
        String timeStamp = m_timeFormat.format(new Date());
        StringBuffer sb = new StringBuffer(timeStamp);
        sb.append(" ldc=");
        sb.append(this.m_id);
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            if (this.m_traceOutput instanceof PrintWriter) {
                PrintWriter traceOutput = (PrintWriter)this.m_traceOutput;
                traceOutput.print(sb);
                traceOutput.println(msg);
                traceOutput.flush();
            } else if (this.m_traceOutput instanceof LDAPTraceWriter) {
                sb.append(msg);
                ((LDAPTraceWriter)this.m_traceOutput).write(sb.toString());
            }
        }
    }

    synchronized void setCache(LDAPCache cache) {
        this.m_cache = cache;
        this.m_messages = this.m_cache != null ? new Hashtable() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateId() {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            m_highMsgId = (m_highMsgId + 1) % Integer.MAX_VALUE;
            return m_highMsgId;
        }
    }

    void sendRequest(LDAPConnection conn, JDAPProtocolOp request, LDAPMessageQueue toNotify, LDAPConstraints cons) throws LDAPException {
        if (this.m_thread == null) {
            throw new LDAPException("Not connected to a server", 81);
        }
        LDAPMessage msg = new LDAPMessage(this.allocateId(), request, cons.getServerControls());
        if (toNotify != null) {
            this.m_requests.put(new Integer(msg.getMessageID()), toNotify);
            this.resultRetrieved();
            toNotify.addRequest(msg.getMessageID(), conn, this, cons.getTimeLimit());
        }
        if (!this.sendRequest(msg, false)) {
            throw new LDAPException("Server or network error", 81);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRequest(LDAPMessage msg, boolean ignoreErrors) {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            block8: {
                try {
                    if (this.m_traceOutput != null) {
                        this.logTraceMessage(msg.toTraceString());
                    }
                    msg.write(this.m_serverOutput);
                    this.m_serverOutput.flush();
                    return true;
                }
                catch (IOException e) {
                    if (!ignoreErrors) {
                        this.networkError(e);
                    }
                }
                catch (NullPointerException e) {
                    if (ignoreErrors || this.m_thread == null) break block8;
                    throw e;
                }
            }
            return false;
        }
    }

    private void sendUnbindRequest(LDAPControl[] ctrls) {
        LDAPMessage msg = new LDAPMessage(this.allocateId(), new JDAPUnbindRequest(), ctrls);
        this.sendRequest(msg, true);
    }

    private void sendAbandonRequest(int id, LDAPControl[] ctrls) {
        LDAPMessage msg = new LDAPMessage(this.allocateId(), new JDAPAbandonRequest(id), ctrls);
        this.sendRequest(msg, true);
    }

    public synchronized void register(LDAPConnection conn) {
        if (!this.m_registered.contains(conn)) {
            this.m_registered.addElement(conn);
        }
    }

    int getClientCount() {
        return this.m_registered.size();
    }

    boolean isConnected() {
        return this.m_thread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deregister(LDAPConnection conn) {
        if (this.m_thread == null) {
            return;
        }
        this.m_registered.removeElement(conn);
        if (this.m_registered.size() == 0) {
            Thread t = this.m_thread;
            this.m_thread = null;
            try {
                this.sendUnbindRequest(conn.getConstraints().getServerControls());
                try {
                    t.interrupt();
                    this.wait(500L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                LDAPConnection.printDebug(e.toString());
            }
            finally {
                this.cleanUp(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(LDAPException ex) {
        this.resultRetrieved();
        try {
            this.m_serverOutput.close();
        }
        catch (Exception e) {
        }
        finally {
            this.m_serverOutput = null;
        }
        try {
            this.m_serverInput.close();
        }
        catch (Exception e) {
        }
        finally {
            this.m_serverInput = null;
        }
        if (this.m_origServerInput != null) {
            try {
                this.m_origServerInput.close();
            }
            catch (Exception e) {
            }
            finally {
                this.m_origServerInput = null;
            }
        }
        if (this.m_origServerOutput != null) {
            try {
                this.m_origServerOutput.close();
            }
            catch (Exception e) {
            }
            finally {
                this.m_origServerOutput = null;
            }
        }
        if (ex != null) {
            this.m_connMgr.invalidateConnection();
        } else {
            this.m_connMgr.closeConnection();
        }
        Enumeration requests = this.m_requests.elements();
        while (requests.hasMoreElements()) {
            try {
                LDAPMessageQueue listener = (LDAPMessageQueue)requests.nextElement();
                if (ex != null) {
                    listener.setException(this, ex);
                    continue;
                }
                listener.removeAllRequests(this);
            }
            catch (Exception exception) {}
        }
        this.m_requests.clear();
        if (this.m_messages != null) {
            this.m_messages.clear();
        }
        this.m_bound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBacklog() throws InterruptedException {
        while (this.m_requests.size() != 0) {
            Enumeration listeners = this.m_requests.elements();
            while (listeners.hasMoreElements()) {
                LDAPMessageQueue l = (LDAPMessageQueue)listeners.nextElement();
                if (!(l instanceof LDAPSearchListener)) {
                    return;
                }
                LDAPSearchListener sl = (LDAPSearchListener)l;
                if (sl.getSearchConstraints() == null) {
                    return;
                }
                int slMaxBacklog = sl.getSearchConstraints().getMaxBacklog();
                int slBatchSize = sl.getSearchConstraints().getBatchSize();
                if (slMaxBacklog == 0) {
                    return;
                }
                if (!sl.isAsynchOp() && slBatchSize == 0) {
                    return;
                }
                if (sl.getMessageCount() >= slMaxBacklog) continue;
                return;
            }
            LDAPConnThread lDAPConnThread = this;
            synchronized (lDAPConnThread) {
                this.wait(3000L);
            }
        }
        return;
    }

    synchronized void resultRetrieved() {
        this.notifyAll();
    }

    public void run() {
        LDAPMessage msg = null;
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        int[] nread = new int[1];
        while (Thread.currentThread() == this.m_thread) {
            try {
                if (--this.m_backlogCheckCounter <= 0) {
                    this.m_backlogCheckCounter = 50;
                    this.checkBacklog();
                }
                nread[0] = 0;
                BERElement element = BERElement.getElement(decoder, this.m_serverInput, nread);
                msg = LDAPMessage.parseMessage(element);
                if (this.m_traceOutput != null) {
                    this.logTraceMessage(msg.toTraceString());
                }
                this.processResponse(msg, nread[0]);
                Thread.yield();
            }
            catch (Exception e) {
                if (Thread.currentThread() == this.m_thread) {
                    this.networkError(e);
                    continue;
                }
                this.resultRetrieved();
            }
        }
    }

    private void processResponse(LDAPMessage msg, int size) {
        Integer messageID = new Integer(msg.getMessageID());
        LDAPMessageQueue l = (LDAPMessageQueue)this.m_requests.get(messageID);
        if (l == null) {
            return;
        }
        if (this.m_cache != null && l instanceof LDAPSearchListener) {
            this.cacheSearchResult((LDAPSearchListener)l, msg, size);
        }
        l.addMessage(msg);
        if (msg instanceof LDAPResponse) {
            this.m_requests.remove(messageID);
            if (this.m_requests.size() == 0) {
                this.m_backlogCheckCounter = 50;
            }
            if (msg instanceof LDAPExtendedResponse) {
                LDAPExtendedResponse extrsp = (LDAPExtendedResponse)msg;
                String extid = extrsp.getID();
                if (extrsp.getResultCode() == 0 && extid != null && extid.equals("1.3.6.1.4.1.1466.20037")) {
                    this.changeIOStreams();
                }
            }
        }
    }

    private void changeIOStreams() {
        this.m_origServerInput = this.m_serverInput;
        this.m_origServerOutput = this.m_serverOutput;
        this.m_serverInput = null;
        this.m_serverOutput = null;
        while (this.m_serverInput == null || this.m_serverOutput == null) {
            try {
                if (Thread.currentThread() != this.m_thread) {
                    return;
                }
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void cacheSearchResult(LDAPSearchListener l, LDAPMessage msg, int size) {
        Integer messageID = new Integer(msg.getMessageID());
        Long key = l.getKey();
        Vector v = null;
        if (this.m_cache == null || key == null) {
            return;
        }
        if (msg instanceof LDAPSearchResult) {
            v = (Vector)this.m_messages.get(messageID);
            if (v == null) {
                v = new Vector();
                this.m_messages.put(messageID, v);
                v.addElement(new Long(0L));
            }
            if ((Long)v.firstElement() == -1L) {
                return;
            }
            long entrySize = (Long)v.firstElement() + (long)size;
            if (entrySize > this.m_cache.getSize()) {
                v.removeAllElements();
                v.addElement(new Long(-1L));
                return;
            }
            v.setElementAt(new Long(entrySize), 0);
            v.addElement(((LDAPSearchResult)msg).getEntry());
        } else if (msg instanceof LDAPSearchResultReference) {
            v = (Vector)this.m_messages.get(messageID);
            if (v == null) {
                v = new Vector();
                this.m_messages.put(messageID, v);
            } else {
                v.removeAllElements();
            }
            v.addElement(new Long(-1L));
        } else if (msg instanceof LDAPResponse) {
            boolean fail = ((LDAPResponse)msg).getResultCode() > 0;
            v = (Vector)this.m_messages.remove(messageID);
            if (!fail) {
                if (v == null) {
                    v = new Vector();
                    v.addElement(new Long(0L));
                }
                if ((Long)v.firstElement() != -1L) {
                    this.m_cache.addEntry(key, v);
                }
            }
        }
    }

    void abandon(int id, LDAPControl[] ctrls) {
        if (this.m_thread == null) {
            return;
        }
        LDAPMessageQueue l = (LDAPMessageQueue)this.m_requests.remove(new Integer(id));
        if (this.m_messages != null) {
            this.m_messages.remove(new Integer(id));
        }
        if (l != null) {
            l.removeRequest(id);
        }
        this.resultRetrieved();
        this.sendAbandonRequest(id, ctrls);
    }

    LDAPMessageQueue changeListener(int id, LDAPMessageQueue toNotify) {
        if (this.m_thread == null) {
            toNotify.setException(this, new LDAPException("Server or network error", 81));
            return null;
        }
        return this.m_requests.put(new Integer(id), toNotify);
    }

    private synchronized void networkError(Exception e) {
        if (this.m_thread == null) {
            return;
        }
        this.m_thread = null;
        this.cleanUp(new LDAPException("Server or network error", 81));
    }

    static {
        m_timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    }
}

