/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;

public abstract class AppServlet
extends HttpServlet {
    private CamelContext camelContext;

    protected AppServlet(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    protected AppServlet() {
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void setHealthCheckResult(HttpServletResponse response, Collection<HealthCheck.Result> results) throws IOException {
        String json;
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode rootNode = JsonNodeFactory.instance.objectNode();
        for (HealthCheck.Result result : results) {
            ObjectNode checkNode = rootNode.putObject(result.getCheck().getId());
            checkNode.put("state", result.getState().toString());
            if (!result.getMessage().isPresent()) continue;
            checkNode.put("message", (String)result.getMessage().get());
        }
        if (results.stream().anyMatch(it -> it.getState() != HealthCheck.State.UP)) {
            rootNode.put("status", "DOWN");
            response.setStatus(503);
        } else {
            rootNode.put("status", "UP");
            response.setStatus(200);
        }
        response.setContentType("application/json");
        try {
            json = objectMapper.writeValueAsString((Object)rootNode);
        }
        catch (JsonProcessingException e) {
            json = "{\"error\":\"Failed to serialize health check results\"}";
        }
        response.getWriter().println(json);
    }

    protected static void setHealthCheckResult(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getWriter().println("{\"status\":\"UP\"}");
    }
}

