/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.v2_3;

import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cardinality$;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Selectivity;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Selectivity$;
import org.neo4j.cypher.internal.compiler.v2_3.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v2_3.spi.StatisticsCompletingGraphStatistics;
import org.neo4j.cypher.internal.frontend.v2_3.LabelId;
import org.neo4j.cypher.internal.frontend.v2_3.NameId;
import org.neo4j.cypher.internal.frontend.v2_3.NameId$;
import org.neo4j.cypher.internal.frontend.v2_3.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v2_3.RelTypeId;
import org.neo4j.cypher.internal.spi.v2_3.TransactionBoundGraphStatistics$;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U<Q!\u0001\u0002\t\u0002=\tq\u0004\u0016:b]N\f7\r^5p]\n{WO\u001c3He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0015\t\u0019A!\u0001\u0003we}\u001b$BA\u0003\u0007\u0003\r\u0019\b/\u001b\u0006\u0003\u000f!\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0013)\taaY=qQ\u0016\u0014(BA\u0006\r\u0003\u0015qWm\u001c\u001bk\u0015\u0005i\u0011aA8sO\u000e\u0001\u0001C\u0001\t\u0012\u001b\u0005\u0011a!\u0002\n\u0003\u0011\u0003\u0019\"a\b+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dgN\u0011\u0011\u0003\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000bm\tB\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005y\u0001\"\u0002\u0010\u0012\t\u0003y\u0012!B1qa2LHC\u0001\u0011)!\t\tc%D\u0001#\u0015\t)1E\u0003\u0002\u0004I)\u0011QEB\u0001\tG>l\u0007/\u001b7fe&\u0011qE\t\u0002$'R\fG/[:uS\u000e\u001c8i\\7qY\u0016$\u0018N\\4He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0011\u0015IS\u00041\u0001+\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0002,a5\tAF\u0003\u0002.]\u0005\u0019\u0011\r]5\u000b\u0005=R\u0011AB6fe:,G.\u0003\u00022Y\tI1\u000b^1uK6,g\u000e\u001e\u0004\u0005gE!AGA\u0012CCN,GK]1og\u0006\u001cG/[8o\u0005>,h\u000eZ$sCBD7\u000b^1uSN$\u0018nY:\u0014\u0007I\"R\u0007\u0005\u0002\"m%\u0011qG\t\u0002\u0010\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg\"A\u0011F\rB\u0001B\u0003%!\u0006C\u0003\u001ce\u0011\u0005!\b\u0006\u0002<{A\u0011AHM\u0007\u0002#!)\u0011&\u000fa\u0001U!)qH\rC\u0001\u0001\u0006\u0001\u0012N\u001c3fqN+G.Z2uSZLG/\u001f\u000b\u0004\u00032+\u0006cA\u000bC\t&\u00111I\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u0013\u000e\nq\u0001\u001d7b]:,'/\u0003\u0002L\r\nY1+\u001a7fGRLg/\u001b;z\u0011\u0015ie\b1\u0001O\u0003\u0015a\u0017MY3m!\ty5+D\u0001Q\u0015\t\u0019\u0011K\u0003\u0002S\r\u0005AaM]8oi\u0016tG-\u0003\u0002U!\n9A*\u00192fY&#\u0007\"\u0002,?\u0001\u00049\u0016\u0001\u00039s_B,'\u000f^=\u0011\u0005=C\u0016BA-Q\u00055\u0001&o\u001c9feRL8*Z=JI\")1L\rC\u00019\u0006q\u0012N\u001c3fqB\u0013x\u000e]3sif,\u00050[:ugN+G.Z2uSZLG/\u001f\u000b\u0004\u0003vs\u0006\"B'[\u0001\u0004q\u0005\"\u0002,[\u0001\u00049\u0006\"\u000213\t\u0003\t\u0017!\u00078pI\u0016\u001cx+\u001b;i\u0019\u0006\u0014W\r\\\"be\u0012Lg.\u00197jif$\"AY3\u0011\u0005\u0015\u001b\u0017B\u00013G\u0005-\u0019\u0015M\u001d3j]\u0006d\u0017\u000e^=\t\u000b\u0019|\u0006\u0019A4\u0002\u000f1\f'-\u001a7JIB\u0019QC\u0011(\t\u000b%\u0014D\u0011\u00016\u0002M\r\f'\u000fZ5oC2LG/\u001f\"z\u0019\u0006\u0014W\r\\:B]\u0012\u0014V\r\\1uS>t7\u000f[5q)f\u0004X\r\u0006\u0003cW6\u001c\b\"\u00027i\u0001\u00049\u0017!\u00034s_6d\u0015MY3m\u0011\u0015q\u0007\u000e1\u0001p\u0003%\u0011X\r\u001c+za\u0016LE\rE\u0002\u0016\u0005B\u0004\"aT9\n\u0005I\u0004&!\u0003*fYRK\b/Z%e\u0011\u0015!\b\u000e1\u0001h\u0003\u001d!x\u000eT1cK2\u0004")
public final class TransactionBoundGraphStatistics {
    public static StatisticsCompletingGraphStatistics apply(Statement statement) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(statement);
    }

    public static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics {
        private final Statement statement;

        public Option<Selectivity> indexSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                IndexDescriptor indexDescriptor = new IndexDescriptor(NameId$.MODULE$.toKernelEncode((NameId)label), NameId$.MODULE$.toKernelEncode((NameId)property));
                double labeledNodes = this.statement.readOperations().countsForNode(NameId$.MODULE$.toKernelEncode((NameId)label));
                double indexEntrySelectivity = this.statement.readOperations().indexUniqueValuesSelectivity(indexDescriptor);
                double frequencyOfNodesWithSameValue = 1.0 / indexEntrySelectivity;
                double indexSelectivity = frequencyOfNodesWithSameValue / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Option<Selectivity> indexPropertyExistsSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                IndexDescriptor indexDescriptor = new IndexDescriptor(NameId$.MODULE$.toKernelEncode((NameId)label), NameId$.MODULE$.toKernelEncode((NameId)property));
                double labeledNodes = this.statement.readOperations().countsForNode(NameId$.MODULE$.toKernelEncode((NameId)label));
                long indexSize = this.statement.readOperations().indexSize(indexDescriptor);
                double indexSelectivity = (double)indexSize / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> labelId) {
            return Cardinality$.MODULE$.lift((double)this.statement.readOperations().countsForNode(NameId$.MODULE$.toKernelEncode(labelId)));
        }

        public Cardinality cardinalityByLabelsAndRelationshipType(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return Cardinality$.MODULE$.lift((double)this.statement.readOperations().countsForRelationship(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        public BaseTransactionBoundGraphStatistics(Statement statement) {
            this.statement = statement;
        }
    }
}

