/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquenessConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.AbstractDelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;

public class TentativeConstraintIndexProxy
extends AbstractDelegatingIndexProxy {
    private final FlippableIndexProxy flipper;
    private final OnlineIndexProxy target;
    private final Collection<IndexEntryConflictException> failures = new CopyOnWriteArrayList<IndexEntryConflictException>();

    public TentativeConstraintIndexProxy(FlippableIndexProxy flipper, OnlineIndexProxy target) {
        this.flipper = flipper;
        this.target = target;
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        switch (mode) {
            case ONLINE: {
                return new DelegatingIndexUpdater(this.target.accessor.newUpdater(mode)){

                    @Override
                    public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
                        try {
                            this.delegate.process(update);
                        }
                        catch (IndexEntryConflictException conflict) {
                            TentativeConstraintIndexProxy.this.failures.add(conflict);
                        }
                    }

                    @Override
                    public void close() throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
                        try {
                            this.delegate.close();
                        }
                        catch (IndexEntryConflictException conflict) {
                            TentativeConstraintIndexProxy.this.failures.add(conflict);
                        }
                    }
                };
            }
            case BATCHED: {
                return super.newUpdater(mode);
            }
        }
        throw new ThisShouldNotHappenError("Stefan", "Unsupported IndexUpdateMode");
    }

    @Override
    public InternalIndexState getState() {
        return this.failures.isEmpty() ? InternalIndexState.POPULATING : InternalIndexState.FAILED;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[target:" + this.target + "]";
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException(this.getDescriptor() + " is still populating");
    }

    @Override
    protected IndexProxy getDelegate() {
        return this.target;
    }

    @Override
    public void validate() throws ConstraintVerificationFailedKernelException {
        if (!this.failures.isEmpty()) {
            IndexDescriptor descriptor = this.getDescriptor();
            throw new UniquenessConstraintVerificationFailedKernelException(new UniquenessConstraint(descriptor.getLabelId(), descriptor.getPropertyKeyId()), new HashSet<IndexEntryConflictException>(this.failures));
        }
    }

    @Override
    public void activate() {
        if (!this.failures.isEmpty()) {
            throw new IllegalStateException("Trying to activate failed index, should have checked the failures earlier...");
        }
        this.flipper.flipTo(this.target);
    }
}

