/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.cursor.LabelItem;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.txstate.UpdateTriState;
import org.neo4j.kernel.impl.api.cursor.TxAllPropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.cursor.TxLabelCursor;
import org.neo4j.kernel.impl.api.cursor.TxSingleLabelCursor;
import org.neo4j.kernel.impl.api.cursor.TxSinglePropertyCursor;
import org.neo4j.kernel.impl.api.state.PropertyContainerState;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.api.state.StateDefaults;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;

public interface NodeState
extends PropertyContainerState {
    public ReadableDiffSets<Integer> labelDiffSets();

    public RelationshipIterator augmentRelationships(Direction var1, RelationshipIterator var2);

    public RelationshipIterator augmentRelationships(Direction var1, int[] var2, RelationshipIterator var3);

    public PrimitiveLongIterator addedRelationships(Direction var1, int[] var2);

    public Cursor<LabelItem> augmentLabelCursor(InstanceCache<TxLabelCursor> var1, Cursor<LabelItem> var2);

    public Cursor<LabelItem> augmentLabelCursor(InstanceCache<TxSingleLabelCursor> var1, Cursor<LabelItem> var2, int var3);

    public Cursor<RelationshipItem> augmentNodeRelationshipCursor(InstanceCache<TxIteratorRelationshipCursor> var1, Cursor<RelationshipItem> var2, Direction var3, int[] var4);

    public int augmentDegree(Direction var1, int var2);

    public int augmentDegree(Direction var1, int var2, int var3);

    public void accept(Visitor var1) throws ConstraintValidationKernelException;

    public PrimitiveIntIterator relationshipTypes();

    public UpdateTriState labelState(int var1);

    public long getId();

    public static abstract class Defaults
    extends StateDefaults<Long, NodeState, Mutable> {
        private static final NodeState DEFAULT = new NodeState(){

            @Override
            public Iterator<DefinedProperty> addedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<DefinedProperty> changedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<Integer> removedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<DefinedProperty> addedAndChangedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<DefinedProperty> augmentProperties(Iterator<DefinedProperty> iterator) {
                return iterator;
            }

            @Override
            public void accept(PropertyContainerState.Visitor visitor) {
            }

            @Override
            public ReadableDiffSets<Integer> labelDiffSets() {
                return ReadableDiffSets.Empty.instance();
            }

            @Override
            public RelationshipIterator augmentRelationships(Direction direction, RelationshipIterator rels) {
                return rels;
            }

            @Override
            public RelationshipIterator augmentRelationships(Direction direction, int[] types, RelationshipIterator rels) {
                return rels;
            }

            @Override
            public PrimitiveLongIterator addedRelationships(Direction direction, int[] types) {
                return Primitive.iterator((long[])new long[0]);
            }

            @Override
            public Cursor<LabelItem> augmentLabelCursor(InstanceCache<TxLabelCursor> labelCursorCache, Cursor<LabelItem> cursor) {
                return cursor;
            }

            @Override
            public Cursor<LabelItem> augmentLabelCursor(InstanceCache<TxSingleLabelCursor> labelCursorCache, Cursor<LabelItem> cursor, int labelId) {
                return cursor;
            }

            @Override
            public Cursor<RelationshipItem> augmentNodeRelationshipCursor(InstanceCache<TxIteratorRelationshipCursor> nodeRelationshipCursor, Cursor<RelationshipItem> cursor, Direction direction, int[] relTypes) {
                return cursor;
            }

            @Override
            public Cursor<PropertyItem> augmentPropertyCursor(Supplier<TxAllPropertyCursor> propertyCursor, Cursor<PropertyItem> cursor) {
                return cursor;
            }

            @Override
            public Cursor<PropertyItem> augmentSinglePropertyCursor(Supplier<TxSinglePropertyCursor> propertyCursor, Cursor<PropertyItem> cursor, int propertyKeyId) {
                return cursor;
            }

            @Override
            public int augmentDegree(Direction direction, int degree) {
                return degree;
            }

            @Override
            public int augmentDegree(Direction direction, int degree, int typeId) {
                return degree;
            }

            @Override
            public void accept(Visitor visitor) {
            }

            @Override
            public PrimitiveIntIterator relationshipTypes() {
                return Primitive.intSet().iterator();
            }

            @Override
            public UpdateTriState labelState(int labelId) {
                return UpdateTriState.UNTOUCHED;
            }

            @Override
            public long getId() {
                throw new UnsupportedOperationException("id not defined");
            }
        };

        @Override
        final Mutable createValue(Long id, TxState state) {
            return new Mutable(id, state);
        }

        @Override
        final NodeState defaultValue() {
            return DEFAULT;
        }
    }

    public static class Mutable
    extends PropertyContainerState.Mutable
    implements NodeState {
        private DiffSets<Integer> labelDiffSets;
        private RelationshipChangesForNode relationshipsAdded;
        private RelationshipChangesForNode relationshipsRemoved;
        private Set<DiffSets<Long>> indexDiffs;
        private final TxState state;

        private Mutable(long id, TxState state) {
            super(id, EntityType.NODE);
            this.state = state;
        }

        @Override
        public ReadableDiffSets<Integer> labelDiffSets() {
            return ReadableDiffSets.Empty.ifNull(this.labelDiffSets);
        }

        public DiffSets<Integer> getOrCreateLabelDiffSets() {
            if (null == this.labelDiffSets) {
                this.labelDiffSets = new DiffSets();
            }
            return this.labelDiffSets;
        }

        public void addRelationship(long relId, int typeId, Direction direction) {
            if (!this.hasAddedRelationships()) {
                this.relationshipsAdded = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, this.state);
            }
            this.relationshipsAdded.addRelationship(relId, typeId, direction);
        }

        public void removeRelationship(long relId, int typeId, Direction direction) {
            if (this.hasAddedRelationships() && this.relationshipsAdded.removeRelationship(relId, typeId, direction)) {
                return;
            }
            if (!this.hasRemovedRelationships()) {
                this.relationshipsRemoved = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.REMOVE, this.state);
            }
            this.relationshipsRemoved.addRelationship(relId, typeId, direction);
        }

        @Override
        public void clear() {
            super.clear();
            if (this.relationshipsAdded != null) {
                this.relationshipsAdded.clear();
            }
            if (this.relationshipsRemoved != null) {
                this.relationshipsRemoved.clear();
            }
            if (this.labelDiffSets != null) {
                this.labelDiffSets.clear();
            }
            if (this.indexDiffs != null) {
                this.indexDiffs.clear();
            }
        }

        @Override
        public RelationshipIterator augmentRelationships(Direction direction, RelationshipIterator rels) {
            if (this.hasAddedRelationships()) {
                return this.relationshipsAdded.augmentRelationships(direction, rels);
            }
            return rels;
        }

        @Override
        public RelationshipIterator augmentRelationships(Direction direction, int[] types, RelationshipIterator rels) {
            if (this.hasAddedRelationships()) {
                return this.relationshipsAdded.augmentRelationships(direction, types, rels);
            }
            return rels;
        }

        @Override
        public RelationshipIterator addedRelationships(Direction direction, int[] types) {
            if (this.hasAddedRelationships()) {
                return this.relationshipsAdded.augmentRelationships(direction, types, RelationshipIterator.EMPTY);
            }
            return null;
        }

        @Override
        public Cursor<LabelItem> augmentLabelCursor(InstanceCache<TxLabelCursor> labelCursorCache, Cursor<LabelItem> cursor) {
            if (this.labelDiffSets == null) {
                return cursor;
            }
            return labelCursorCache.get().init(cursor, this.labelDiffSets);
        }

        @Override
        public Cursor<LabelItem> augmentLabelCursor(InstanceCache<TxSingleLabelCursor> labelCursorCache, Cursor<LabelItem> cursor, int labelId) {
            if (this.labelDiffSets == null) {
                return cursor;
            }
            return labelCursorCache.get().init(cursor, this.labelDiffSets);
        }

        @Override
        public Cursor<RelationshipItem> augmentNodeRelationshipCursor(InstanceCache<TxIteratorRelationshipCursor> nodeRelationshipCursorCache, Cursor<RelationshipItem> cursor, Direction direction, int[] relTypes) {
            if (this.hasAddedRelationships() || this.hasRemovedRelationships()) {
                if (relTypes == null) {
                    return nodeRelationshipCursorCache.get().init(cursor, this.relationshipsAdded != null ? this.relationshipsAdded.augmentRelationships(direction, RelationshipIterator.EMPTY) : RelationshipIterator.EMPTY);
                }
                return nodeRelationshipCursorCache.get().init(cursor, this.relationshipsAdded != null ? this.relationshipsAdded.augmentRelationships(direction, relTypes, RelationshipIterator.EMPTY) : RelationshipIterator.EMPTY);
            }
            return cursor;
        }

        @Override
        public int augmentDegree(Direction direction, int degree) {
            if (this.hasAddedRelationships()) {
                degree = this.relationshipsAdded.augmentDegree(direction, degree);
            }
            if (this.hasRemovedRelationships()) {
                degree = this.relationshipsRemoved.augmentDegree(direction, degree);
            }
            return degree;
        }

        @Override
        public int augmentDegree(Direction direction, int degree, int typeId) {
            if (this.hasAddedRelationships()) {
                degree = this.relationshipsAdded.augmentDegree(direction, degree, typeId);
            }
            if (this.hasRemovedRelationships()) {
                degree = this.relationshipsRemoved.augmentDegree(direction, degree, typeId);
            }
            return degree;
        }

        @Override
        public void accept(Visitor visitor) throws ConstraintValidationKernelException {
            super.accept(visitor);
            if (this.labelDiffSets != null) {
                visitor.visitLabelChanges(this.getId(), this.labelDiffSets.getAdded(), this.labelDiffSets.getRemoved());
            }
            if (this.relationshipsAdded != null || this.relationshipsRemoved != null) {
                visitor.visitRelationshipChanges(this.getId(), this.relationshipsAdded, this.relationshipsRemoved);
            }
        }

        private boolean hasAddedRelationships() {
            return this.relationshipsAdded != null;
        }

        private boolean hasRemovedRelationships() {
            return this.relationshipsRemoved != null;
        }

        @Override
        public PrimitiveIntIterator relationshipTypes() {
            if (this.hasAddedRelationships()) {
                return this.relationshipsAdded.relationshipTypes();
            }
            return PrimitiveIntCollections.emptyIterator();
        }

        @Override
        public UpdateTriState labelState(int labelId) {
            ReadableDiffSets<Integer> labelDiff = this.labelDiffSets();
            if (labelDiff.isAdded(labelId)) {
                return UpdateTriState.ADDED;
            }
            if (labelDiff.isRemoved(labelId)) {
                return UpdateTriState.REMOVED;
            }
            return UpdateTriState.UNTOUCHED;
        }

        public void addIndexDiff(DiffSets<Long> diff) {
            if (this.indexDiffs == null) {
                this.indexDiffs = Collections.newSetFromMap(new IdentityHashMap());
            }
            this.indexDiffs.add(diff);
        }

        public void removeIndexDiff(DiffSets<Long> diff) {
            if (this.indexDiffs != null) {
                this.indexDiffs.remove(diff);
            }
        }

        public void clearIndexDiffs(long nodeId) {
            if (this.indexDiffs != null) {
                for (DiffSets<Long> diff : this.indexDiffs) {
                    if (diff.getAdded().contains(nodeId)) {
                        diff.remove((Object)nodeId);
                        continue;
                    }
                    if (!diff.getRemoved().contains(nodeId)) continue;
                    diff.add((Object)nodeId);
                }
            }
        }
    }

    public static interface Visitor
    extends PropertyContainerState.Visitor {
        public void visitLabelChanges(long var1, Set<Integer> var3, Set<Integer> var4) throws ConstraintValidationKernelException;

        public void visitRelationshipChanges(long var1, RelationshipChangesForNode var3, RelationshipChangesForNode var4);
    }
}

