/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.neo4j.kernel.impl.api.store.PropertyBlockCursor;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.Abstract64BitRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.Record;

public class PropertyRecord
extends Abstract64BitRecord
implements Iterable<PropertyBlock>,
Iterator<PropertyBlock> {
    private long nextProp = Record.NO_NEXT_PROPERTY.intValue();
    private long prevProp = Record.NO_PREVIOUS_PROPERTY.intValue();
    private final PropertyBlock[] blockRecords = new PropertyBlock[PropertyType.getPayloadSizeLongs()];
    private int blockRecordsCursor;
    private long entityId = -1L;
    private Boolean nodeIdSet;
    private List<DynamicRecord> deletedRecords;
    private String malformedMessage;
    private int blockRecordsIteratorCursor;
    private boolean canRemoveFromIterator;

    public PropertyRecord(long id) {
        super(id);
    }

    public PropertyRecord(long id, PrimitiveRecord primitive) {
        super(id);
        this.setCreated();
        primitive.setIdTo(this);
    }

    public void setNodeId(long nodeId) {
        this.nodeIdSet = true;
        this.entityId = nodeId;
    }

    public void setRelId(long relId) {
        this.nodeIdSet = false;
        this.entityId = relId;
    }

    public boolean isNodeSet() {
        return Boolean.TRUE.equals(this.nodeIdSet);
    }

    public boolean isRelSet() {
        return Boolean.FALSE.equals(this.nodeIdSet);
    }

    public long getNodeId() {
        if (this.isNodeSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public long getRelId() {
        if (this.isRelSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public int size() {
        int result = 0;
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            result += this.blockRecords[i].getSize();
        }
        return result;
    }

    public int numberOfProperties() {
        return this.blockRecordsCursor;
    }

    @Override
    public Iterator<PropertyBlock> iterator() {
        this.blockRecordsIteratorCursor = 0;
        this.canRemoveFromIterator = false;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.blockRecordsIteratorCursor < this.blockRecordsCursor;
    }

    @Override
    public PropertyBlock next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.canRemoveFromIterator = true;
        return this.blockRecords[this.blockRecordsIteratorCursor++];
    }

    @Override
    public void remove() {
        if (!this.canRemoveFromIterator) {
            throw new IllegalStateException("cursor:" + this.blockRecordsIteratorCursor + " canRemove:" + this.canRemoveFromIterator);
        }
        if (--this.blockRecordsCursor > --this.blockRecordsIteratorCursor) {
            this.blockRecords[this.blockRecordsIteratorCursor] = this.blockRecords[this.blockRecordsCursor];
        }
        this.canRemoveFromIterator = false;
    }

    public List<DynamicRecord> getDeletedRecords() {
        return this.deletedRecords != null ? this.deletedRecords : Collections.emptyList();
    }

    public void addDeletedRecord(DynamicRecord record) {
        assert (!record.inUse());
        if (this.deletedRecords == null) {
            this.deletedRecords = new LinkedList<DynamicRecord>();
        }
        this.deletedRecords.add(record);
    }

    public void addPropertyBlock(PropertyBlock block) {
        if (this.size() + block.getSize() > PropertyType.getPayloadSize()) {
            this.malformedMessage = "Exceeded capacity of PropertyRecord[" + this.getId() + "]. " + "PropertyRecord size is " + this.size() + ". " + "The added block of type " + (Object)((Object)block.forceGetType()) + " has size " + block.getSize();
        }
        this.blockRecords[this.blockRecordsCursor++] = block;
    }

    public void verifyRecordIsWellFormed() {
        if (this.malformedMessage != null) {
            throw new InvalidRecordException(this.malformedMessage);
        }
    }

    public void setMalformedMessage(String message) {
        this.malformedMessage = message;
    }

    public void setPropertyBlock(PropertyBlock block) {
        this.removePropertyBlock(block.getKeyIndexId());
        this.addPropertyBlock(block);
    }

    public PropertyBlock getPropertyBlock(int keyIndex) {
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            PropertyBlock block = this.blockRecords[i];
            if (block.getKeyIndexId() != keyIndex) continue;
            return block;
        }
        return null;
    }

    public PropertyBlock removePropertyBlock(int keyIndex) {
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            if (this.blockRecords[i].getKeyIndexId() != keyIndex) continue;
            PropertyBlock block = this.blockRecords[i];
            if (--this.blockRecordsCursor > i) {
                this.blockRecords[i] = this.blockRecords[this.blockRecordsCursor];
            }
            return block;
        }
        return null;
    }

    public void clearPropertyBlocks() {
        this.blockRecordsCursor = 0;
    }

    public long getNextProp() {
        return this.nextProp;
    }

    public void setNextProp(long nextProp) {
        this.nextProp = nextProp;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Property[").append(this.getId()).append(",used=").append(this.inUse()).append(",prev=").append(this.prevProp).append(",next=").append(this.nextProp);
        if (this.entityId != -1L) {
            buf.append(this.nodeIdSet != false ? ",node=" : ",rel=").append(this.entityId);
        }
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            buf.append(',').append(this.blockRecords[i]);
        }
        if (this.deletedRecords != null) {
            for (DynamicRecord dyn : this.deletedRecords) {
                buf.append(",del:").append(dyn);
            }
        }
        buf.append("]");
        return buf.toString();
    }

    public void setChanged(PrimitiveRecord primitive) {
        primitive.setIdTo(this);
    }

    public long getPrevProp() {
        return this.prevProp;
    }

    public void setPrevProp(long prev) {
        this.prevProp = prev;
    }

    @Override
    public PropertyRecord clone() {
        PropertyRecord result = new PropertyRecord(this.getLongId());
        result.setInUse(this.inUse());
        result.nextProp = this.nextProp;
        result.prevProp = this.prevProp;
        result.entityId = this.entityId;
        result.nodeIdSet = this.nodeIdSet;
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            result.blockRecords[i] = this.blockRecords[i].clone();
        }
        result.blockRecordsCursor = this.blockRecordsCursor;
        if (this.deletedRecords != null) {
            for (DynamicRecord deletedRecord : this.deletedRecords) {
                result.addDeletedRecord(deletedRecord.clone());
            }
        }
        return result;
    }

    public PropertyBlockCursor getPropertyBlockCursor(PropertyBlockCursor cursor) {
        cursor.init(this.blockRecords, this.blockRecordsCursor);
        return cursor;
    }
}

