/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;

public class TransactionCounters
implements TransactionMonitor {
    private final AtomicLong startedTransactionCount = new AtomicLong();
    private final AtomicLong activeTransactionCount = new AtomicLong();
    private final AtomicLong rolledBackTransactionCount = new AtomicLong();
    private final AtomicLong terminatedTransactionCount = new AtomicLong();
    private long peakTransactionCount;

    @Override
    public void transactionStarted() {
        this.startedTransactionCount.incrementAndGet();
        long active = this.activeTransactionCount.incrementAndGet();
        this.peakTransactionCount = Math.max(this.peakTransactionCount, active);
    }

    @Override
    public void transactionFinished(boolean successful) {
        long count = this.activeTransactionCount.decrementAndGet();
        assert (count >= 0L);
        if (!successful) {
            this.rolledBackTransactionCount.incrementAndGet();
        }
    }

    @Override
    public void transactionTerminated() {
        this.terminatedTransactionCount.incrementAndGet();
    }

    public long getNumberOfActiveTransactions() {
        return this.activeTransactionCount.get();
    }

    public long getPeakConcurrentNumberOfTransactions() {
        return this.peakTransactionCount;
    }

    public long getNumberOfStartedTransactions() {
        return this.startedTransactionCount.get();
    }

    public long getNumberOfCommittedTransactions() {
        return this.startedTransactionCount.get() - this.activeTransactionCount.get() - this.rolledBackTransactionCount.get() - this.terminatedTransactionCount.get();
    }

    public long getNumberOfTerminatedTransactions() {
        return this.terminatedTransactionCount.get();
    }

    public long getNumberOfRolledbackTransactions() {
        return this.rolledBackTransactionCount.get();
    }
}

