/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.command.Command;

public interface CommandHandler
extends AutoCloseable {
    public static final CommandHandler EMPTY = new Adapter();

    public boolean visitNodeCommand(Command.NodeCommand var1) throws IOException;

    public boolean visitRelationshipCommand(Command.RelationshipCommand var1) throws IOException;

    public boolean visitPropertyCommand(Command.PropertyCommand var1) throws IOException;

    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand var1) throws IOException;

    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand var1) throws IOException;

    public boolean visitLabelTokenCommand(Command.LabelTokenCommand var1) throws IOException;

    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand var1) throws IOException;

    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand var1) throws IOException;

    public boolean visitNeoStoreCommand(Command.NeoStoreCommand var1) throws IOException;

    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand var1) throws IOException;

    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand var1) throws IOException;

    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand var1) throws IOException;

    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand var1) throws IOException;

    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand var1) throws IOException;

    public boolean visitIndexDefineCommand(IndexDefineCommand var1) throws IOException;

    public boolean visitNodeCountsCommand(Command.NodeCountsCommand var1) throws IOException;

    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand var1) throws IOException;

    public void apply();

    @Override
    public void close();

    public static class HandlerVisitor
    implements Visitor<Command, IOException> {
        private final CommandHandler handler;

        public HandlerVisitor(CommandHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean visit(Command element) throws IOException {
            element.handle(this.handler);
            return false;
        }
    }

    public static class Delegator
    implements CommandHandler {
        private final CommandHandler delegate;

        public Delegator(CommandHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            return this.delegate.visitNodeCommand(command);
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
            return this.delegate.visitRelationshipCommand(command);
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            return this.delegate.visitPropertyCommand(command);
        }

        @Override
        public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
            return this.delegate.visitRelationshipGroupCommand(command);
        }

        @Override
        public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
            return this.delegate.visitRelationshipTypeTokenCommand(command);
        }

        @Override
        public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
            return this.delegate.visitLabelTokenCommand(command);
        }

        @Override
        public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
            return this.delegate.visitPropertyKeyTokenCommand(command);
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            return this.delegate.visitSchemaRuleCommand(command);
        }

        @Override
        public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
            return this.delegate.visitNeoStoreCommand(command);
        }

        @Override
        public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
            return this.delegate.visitIndexAddNodeCommand(command);
        }

        @Override
        public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
            return this.delegate.visitIndexAddRelationshipCommand(command);
        }

        @Override
        public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
            return this.delegate.visitIndexRemoveCommand(command);
        }

        @Override
        public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
            return this.delegate.visitIndexDeleteCommand(command);
        }

        @Override
        public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
            return this.delegate.visitIndexCreateCommand(command);
        }

        @Override
        public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
            return this.delegate.visitIndexDefineCommand(command);
        }

        @Override
        public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) throws IOException {
            return this.delegate.visitNodeCountsCommand(command);
        }

        @Override
        public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
            return this.delegate.visitRelationshipCountsCommand(command);
        }

        @Override
        public void apply() {
            this.delegate.apply();
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    public static class Adapter
    implements CommandHandler {
        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
            return false;
        }

        @Override
        public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
            return false;
        }

        @Override
        public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
            return false;
        }

        @Override
        public void apply() {
        }

        @Override
        public void close() {
        }
    }
}

