/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.NeoStores;

public class StoreFlusher {
    private final NeoStores neoStores;
    private final IndexingService indexingService;
    private final LabelScanStore labelScanStore;
    private final Iterable<IndexImplementation> indexProviders;

    public StoreFlusher(NeoStores neoStores, IndexingService indexingService, LabelScanStore labelScanStore, Iterable<IndexImplementation> indexProviders) {
        this.neoStores = neoStores;
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.indexProviders = indexProviders;
    }

    public void forceEverything() {
        this.indexingService.forceAll();
        this.labelScanStore.force();
        for (IndexImplementation index : this.indexProviders) {
            index.force();
        }
        this.neoStores.flush();
    }
}

