/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.DirectorySupport;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.util.FailureStorage;

public abstract class LuceneIndexPopulator
implements IndexPopulator {
    protected final LuceneDocumentStructure documentStructure;
    private final IndexWriterFactory<LuceneIndexWriter> indexWriterFactory;
    private final DirectoryFactory dirFactory;
    private final File dirFile;
    private final FailureStorage failureStorage;
    private final long indexId;
    protected LuceneIndexWriter writer;
    private Directory directory;

    LuceneIndexPopulator(LuceneDocumentStructure documentStructure, IndexWriterFactory<LuceneIndexWriter> indexWriterFactory, DirectoryFactory dirFactory, File dirFile, FailureStorage failureStorage, long indexId) {
        this.documentStructure = documentStructure;
        this.indexWriterFactory = indexWriterFactory;
        this.dirFactory = dirFactory;
        this.dirFile = dirFile;
        this.failureStorage = failureStorage;
        this.indexId = indexId;
    }

    public void create() throws IOException {
        this.directory = this.dirFactory.open(this.dirFile);
        DirectorySupport.deleteDirectoryContents(this.directory);
        this.failureStorage.reserveForIndex(this.indexId);
        this.writer = this.indexWriterFactory.create(this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        try {
            this.directory = this.directory == null ? this.dirFactory.open(this.dirFile) : this.directory;
            DirectorySupport.deleteDirectoryContents(this.directory);
        }
        catch (AlreadyClosedException e) {
            this.directory = this.dirFactory.open(this.dirFile);
            DirectorySupport.deleteDirectoryContents(this.directory);
        }
        finally {
            if (this.directory != null) {
                this.directory.close();
            }
        }
        this.failureStorage.clearForIndex(this.indexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean populationCompletedSuccessfully) throws IOException, IndexCapacityExceededException {
        try {
            if (populationCompletedSuccessfully) {
                this.flush();
                this.writer.commitAsOnline();
            }
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.directory != null) {
                this.directory.close();
            }
        }
    }

    public void markAsFailed(String failure) throws IOException {
        this.failureStorage.storeIndexFailure(this.indexId, failure);
    }

    protected abstract void flush() throws IOException, IndexCapacityExceededException;
}

