/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import oracle.gss.util.NLSLocale;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.TypeDescriptor;

public abstract class DBAccess {
    public static final short ORACLE8_PROD_VERSION = 8030;
    public static final short ORACLE81_PROD_VERSION = 8100;
    public static final byte IS_UNINITIALIZED = -1;
    public static final byte IS_SELECT = 0;
    public static final byte IS_PLSQL_BLOCK = 1;
    public static final byte IS_DML = 2;
    public static final byte IS_CALL_BLOCK = 3;
    public static final byte IS_OTHER = 4;
    public static final byte BIND_IN = 1;
    public static final byte BIND_OUT = 16;
    protected SQLWarning connectionWarning = null;
    protected SQLWarning statementWarning = null;

    public abstract DBConversion logon(String var1, String var2, String var3, Properties var4) throws SQLException, IOException;

    public abstract void logoff() throws SQLException, IOException;

    public abstract void commit() throws SQLException, IOException;

    public abstract void rollback() throws SQLException, IOException;

    public abstract void setAutoCommit(boolean var1) throws SQLException, IOException;

    public abstract DBStatement open() throws SQLException, IOException;

    public abstract void closeQuery(DBStatement var1) throws SQLException, IOException;

    public abstract void close(DBStatement var1) throws SQLException, IOException;

    public abstract DBColumn[] describe(DBStatement var1) throws SQLException, IOException;

    public abstract DBColumn[] parseExecuteDescribe(DBStatement var1, byte[] var2, DBDataSet var3) throws SQLException, IOException;

    public abstract int executeFetch(DBStatement var1, byte var2, DBDataSet var3, int var4, DBDataSet var5, int var6) throws SQLException, IOException;

    public int executeFetchNeedDefines(DBStatement dBStatement, byte by, DBDataSet dBDataSet, int n, DBDataSet dBDataSet2, int n2) throws SQLException, IOException {
        return this.executeFetch(dBStatement, by, dBDataSet, n, dBDataSet2, n2);
    }

    public abstract int parseExecuteFetch(DBStatement var1, byte var2, byte[] var3, DBDataSet var4, int var5, DBDataSet var6, int var7) throws SQLException, IOException;

    public abstract int fetch(DBStatement var1, DBDataSet var2, int var3) throws SQLException, IOException;

    public abstract int read(DBStatement var1, byte[] var2, int var3) throws SQLException, IOException;

    public int read(DBStatement dBStatement, byte[] byArray, int n, int n2) throws SQLException, IOException {
        return this.read(dBStatement, byArray, n);
    }

    public abstract byte[] getVersion() throws SQLException, IOException;

    public abstract short getVersionNumber() throws SQLException;

    public abstract int getDefaultPrefetch();

    public abstract int getDefaultStreamChunkSize();

    public abstract void cancel() throws SQLException, IOException;

    public DBStatement RefCursorBytesToDBStatement(DBStatement dBStatement, byte[] byArray) throws SQLException, IOException {
        return this.RefCursorBytesToDBStatement(byArray);
    }

    public abstract DBStatement RefCursorBytesToDBStatement(byte[] var1) throws SQLException, IOException;

    public abstract byte[] DBStatementToRefCursorBytes(DBStatement var1) throws SQLException, IOException;

    public void startup(String string, int n) throws SQLException {
        DBError.check_error(66, "startup");
    }

    public void shutdown(int n) throws SQLException {
        DBError.check_error(66, "shutdown");
    }

    public void archive(int n, int n2, String string) throws SQLException {
        DBError.check_error(66, "archive");
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
    }

    public DBDataSet createDBDataSet(OracleConnection oracleConnection, OracleStatement oracleStatement, int n, int n2) {
        return new DBDataSetImpl(oracleConnection, oracleStatement, n, n2);
    }

    public abstract DBType createDBType(int var1, boolean var2) throws SQLException;

    public DBType createDBType(int n, boolean bl, boolean bl2) throws SQLException {
        return this.createDBType(n, true);
    }

    public DBType createDBType(int n, boolean bl, short s) throws SQLException {
        return this.createDBType(n, true);
    }

    public abstract DBItem createDBItem(DBType var1) throws SQLException;

    public abstract int fetch(DBStatement var1, DBDataSet var2, int var3, int var4) throws SQLException, IOException;

    public long lobWrite(BLOB bLOB, long l, byte[] byArray, int n) throws SQLException {
        return LobPlsqlUtil.plsql_write(bLOB, l, byArray, n);
    }

    public long lobWrite(CLOB cLOB, long l, char[] cArray, int n) throws SQLException {
        return LobPlsqlUtil.plsql_write(cLOB, l, cArray, n);
    }

    public long lobRead(BLOB bLOB, long l, long l2, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bLOB, l, l2, byArray);
    }

    public long lobRead(BFILE bFILE, long l, long l2, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bFILE, l, l2, byArray);
    }

    public long lobRead(CLOB cLOB, long l, long l2, char[] cArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(cLOB, l, l2, cArray);
    }

    public long lobLength(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(bLOB);
    }

    public long lobLength(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_length(bFILE);
    }

    public long lobLength(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(cLOB);
    }

    public long hasPattern(BLOB bLOB, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bLOB, byArray, l);
    }

    public long hasPattern(CLOB cLOB, char[] cArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l);
    }

    public long hasPattern(BFILE bFILE, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bFILE, byArray, l);
    }

    public long isSubLob(BLOB bLOB, BLOB bLOB2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bLOB, bLOB2, l);
    }

    public long isSubLob(CLOB cLOB, CLOB cLOB2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(cLOB, cLOB2, l);
    }

    public long isSubLob(BFILE bFILE, BFILE bFILE2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bFILE, bFILE2, l);
    }

    public void fileOpen(BFILE bFILE) throws SQLException {
        LobPlsqlUtil.plsql_fileOpen(bFILE);
    }

    public boolean fileIsOpen(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_fileIsOpen(bFILE);
    }

    public boolean fileExists(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_fileExists(bFILE);
    }

    public String fileGetName(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_fileGetName(bFILE);
    }

    public String fileGetDirAlias(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_fileGetDirAlias(bFILE);
    }

    public void fileClose(BFILE bFILE) throws SQLException {
        LobPlsqlUtil.plsql_fileClose(bFILE);
    }

    public long getLobChunkSize(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(bLOB);
    }

    public long getLobChunkSize(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(cLOB);
    }

    public void trimLob(Connection connection, Datum datum, int n, long l) throws SQLException {
        LobPlsqlUtil.plsql_trimLob(connection, datum, n, l);
    }

    public Datum createTemporaryLob(Connection connection, boolean bl, int n, int n2) throws SQLException {
        return this.createTemporaryLob(connection, bl, n, n2, (short)1);
    }

    public Datum createTemporaryLob(Connection connection, boolean bl, int n, int n2, short s) throws SQLException {
        return LobPlsqlUtil.plsql_createTemporaryLob(connection, bl, n, n2, s);
    }

    public void freeTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        LobPlsqlUtil.plsql_freeTemporaryLob(connection, datum, n);
    }

    public boolean isTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        boolean bl = false;
        byte[] byArray = datum.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl = true;
        }
        return bl;
    }

    public void openLob(Connection connection, Datum datum, int n, int n2) throws SQLException {
        LobPlsqlUtil.plsql_openLob(connection, datum, n, n2);
    }

    public void closeLob(Connection connection, Datum datum, int n) throws SQLException {
        LobPlsqlUtil.plsql_closeLob(connection, datum, n);
    }

    public boolean isLobOpen(Connection connection, Datum datum, int n) throws SQLException {
        return LobPlsqlUtil.plsql_isLobOpen(connection, datum, n);
    }

    public Properties getDBAccessProperties() throws SQLException {
        DBError.throwSqlException(66, "getDBAccessProperties");
        return null;
    }

    public Properties getConnectionPoolInfo() throws SQLException {
        DBError.throwSqlException(66, "getConnectionPoolInfo");
        return null;
    }

    public void setConnectionPoolInfo(Properties properties) throws SQLException {
        DBError.throwSqlException(66, "setConnectionPoolInfo");
    }

    public int getNlsRatio() {
        return 1;
    }

    public int getC2SNlsRatio() {
        return 1;
    }

    public void initNls(OracleConnection oracleConnection) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setNlsParamsClient(OracleConnection oracleConnection) throws SQLException {
        Statement statement = null;
        Object var3_3 = null;
        Object var4_4 = null;
        boolean bl = this.getVersionNumber() >= 8100;
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        int n2 = n / 3600000;
        int n3 = n / 60000 % 60;
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(new Date())) {
            n2 = n2 > 0 ? --n2 : ++n2;
        }
        String string = (n2 < 0 ? "" + n2 : "+" + n2) + (n3 < 10 ? ":0" + n3 : ":" + n3);
        try {
            try {
                statement = oracleConnection.createStatement();
                Locale locale = Locale.getDefault();
                Object var12_13 = null;
                NLSLocale nLSLocale = NLSLocale.getInstance();
                statement.execute("ALTER SESSION SET " + (bl ? "TIME_ZONE='" + string + "'" : "") + " NLS_LANGUAGE = '" + nLSLocale.getNLSLanguage(locale) + "' NLS_TERRITORY = '" + nLSLocale.getNLSTerritory(locale) + "'");
            }
            catch (SQLException sQLException) {
                Object var15_16 = null;
                if (statement == null) return;
                statement.close();
                return;
            }
            Object var15_15 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (statement != null) {
                statement.close();
            }
            statement = null;
            throw throwable;
        }
        statement.close();
    }

    public SQLWarning getConnectionWarning() {
        return this.connectionWarning;
    }

    public void setConnectionWarning(SQLWarning sQLWarning) {
        this.connectionWarning = sQLWarning;
    }

    public SQLWarning getStatementWarning() {
        return this.statementWarning;
    }

    public void setStatementWarning(SQLWarning sQLWarning) {
        this.statementWarning = sQLWarning;
    }

    public int getMinAsciiStreamSize(OracleConnection oracleConnection, int n) {
        if (oracleConnection.conversion.isUcs2CharSet()) {
            return n / 2;
        }
        return n;
    }

    public void registerTAFCallback(Connection connection, OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        DBError.throwSqlException(23);
    }

    public TypeDescriptor getAnyDataEmbTypeDesc(DBStatement dBStatement, DBDataSet dBDataSet, OracleTypeADT oracleTypeADT, int n, int n2) throws SQLException {
        DBError.throwSqlException(23);
        return null;
    }

    public int getAnyDataEmbDataPos(DBStatement dBStatement, int n, int n2) throws SQLException {
        DBError.throwSqlException(23);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearClientIdentifier(OracleConnection oracleConnection, String string) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = oracleConnection.prepareCall("begin dbms_session.clear_identifier(); end;");
            callableStatement.execute();
            Object var6_4 = null;
            if (callableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (callableStatement != null) {
                callableStatement.close();
            }
            callableStatement = null;
            throw throwable;
        }
        callableStatement.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClientIdentifier(OracleConnection oracleConnection, String string) throws SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = oracleConnection.prepareCall("begin dbms_session.set_identifier(?); end;");
            callableStatement.setString(1, string);
            callableStatement.execute();
            Object var6_4 = null;
            if (callableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (callableStatement != null) {
                callableStatement.close();
            }
            callableStatement = null;
            throw throwable;
        }
        callableStatement.close();
    }

    public void setCreateStatementAsRefCursor(boolean bl) {
    }

    public boolean getCreateStatementAsRefCursor() {
        return false;
    }

    public boolean getFetchOnNewRefCursor() {
        return true;
    }

    public Class classForNameAndSchema(String string, String string2) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public Class safelyGetClassForName(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n) throws SQLException {
    }

    public int getMaxCharSize() throws SQLException {
        DBError.throwSqlException(58);
        return -1;
    }

    public void registerConnection(OracleConnection oracleConnection) {
    }

    public String getUserName() throws SQLException {
        return null;
    }
}

