/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;

public class DBDataSetImpl
extends DBDataSet {
    private static int _MIN_ARG_COUNT = 1;
    private static final boolean DEBUG = false;
    protected OracleConnection m_connection;
    protected OracleStatement m_statement;
    private boolean m_dynamic = false;
    private int m_arrayDepth = 0;
    private boolean m_cleanedData = false;
    private boolean m_isCached = false;
    private byte m_sql_kind;
    private boolean m_sql_kind_cached;
    private int m_noOfArgs;
    protected int m_dataSetType;
    protected DBData[] data;
    protected DBType[] types;
    private DBItem[] m_last_bind_values = null;
    private boolean newDBType = false;
    private DBItem[] m_tmp_first_row_items = null;
    private DBType[] m_tmp_first_row_types = null;
    protected boolean m_first_row;
    private short[] form_of_use = null;

    private void init() {
        this.m_dynamic = false;
        this.m_first_row = true;
        this.m_noOfArgs = 0;
        this.data = null;
        this.types = null;
        this.m_cleanedData = false;
    }

    private void _transformToDynamic() {
        this.m_dynamic = true;
        this.m_arrayDepth = 0;
        if (!this.m_first_row) {
            this._cleanData();
            int n = 0;
            while (n < this.types.length) {
                this._allocData(n);
                ++n;
            }
        }
    }

    private final void _allocData(int n) {
        if (this.data[n] != null) {
            return;
        }
        this.data[n] = this.m_dynamic ? new DBData() : new DBData(this.m_arrayDepth);
    }

    private final void _allocDataAndItems(int n) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this._allocData(n);
        this._allocItemsAndBuffers(n);
    }

    private void _allocItemsAndBuffers(int n) throws SQLException {
        int n2 = 0;
        int n3 = this.data[n].getNItems();
        DBType dBType = this.types[n];
        n2 = 0;
        while (n2 < n3) {
            this.data[n].setItem(n2, this.m_connection.db_access.createDBItem(dBType));
            if (!dBType.is_stream && dBType.type != 109 && dBType.type != 111) {
                this.data[n].getItem(n2).allocBuffer();
            }
            ++n2;
        }
    }

    public final void _cleanData() {
        if (this.data != null) {
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.data[n2] != null) {
                    this.data[n2].cleanup();
                    this.data[n2] = null;
                }
                ++n2;
            }
            this.m_cleanedData = true;
        }
    }

    public final DBItem _getDBItem(int n, int n2) throws SQLException {
        if (this.data == null || this.data[n] == null) {
            return null;
        }
        return this.data[n].getItem(n2);
    }

    private final DBItem _getLastDBItem(int n) throws SQLException {
        if (this.data == null || this.data[n] == null) {
            return null;
        }
        if (this.m_dynamic) {
            int n2 = this.data[n].getNItems();
            if (n2 == 0) {
                return null;
            }
            return this.data[n].getItem(n2 - 1);
        }
        return this.data[n].getItem(this.m_arrayDepth - 1);
    }

    private final void _setDBItem(DBItem dBItem, int n, int n2) throws SQLException {
        if (this.data[n] == null) {
            DBError.throwSqlException(44);
        }
        if (this.m_dynamic) {
            this.data[n].addItem(dBItem);
        } else {
            this.data[n].setItem(n2, dBItem);
        }
    }

    private final DBType _getDBType(int n) {
        if (this.types != null && n >= 0 && n < this.types.length) {
            return this.types[n];
        }
        return null;
    }

    private final void _setDBType(int n, DBType dBType) {
        if (this.types != null && n >= 0 && n < this.types.length) {
            this.types[n] = dBType;
        }
    }

    private void _alloc_tmp_binds(int n, boolean bl) {
        if (this.m_tmp_first_row_types == null) {
            int n2 = Math.max(n + 1, _MIN_ARG_COUNT);
            if (bl) {
                this.m_tmp_first_row_items = new DBItem[n2];
            }
            this.m_tmp_first_row_types = new DBType[n2];
        } else if (n >= this.m_tmp_first_row_types.length) {
            Object[] objectArray;
            int n3 = this.m_tmp_first_row_types.length;
            n3 = Math.max(n + 1, n3);
            if (bl) {
                objectArray = new DBItem[2 * n3];
                System.arraycopy(this.m_tmp_first_row_items, 0, objectArray, 0, this.m_tmp_first_row_items.length);
                this.m_tmp_first_row_items = objectArray;
                objectArray = null;
            }
            objectArray = new DBType[2 * n3];
            System.arraycopy(this.m_tmp_first_row_types, 0, objectArray, 0, this.m_tmp_first_row_types.length);
            this.m_tmp_first_row_types = objectArray;
            objectArray = null;
        }
    }

    protected DBType _getBindDBType(int n) {
        DBType dBType = null;
        if (this.m_first_row) {
            if (n + 1 > this.m_noOfArgs) {
                this.m_noOfArgs = n + 1;
            }
            this._alloc_tmp_binds(n, true);
            dBType = this.m_tmp_first_row_types[n];
        } else {
            dBType = this._getDBType(n);
        }
        return dBType;
    }

    protected DBType _createOrGetBindDBType(int n, int n2) throws SQLException {
        DBType dBType;
        if (!(this.m_first_row || this.data != null && this.data.length > n)) {
            this.m_first_row = true;
            if (this.types != null && this.types.length > 0) {
                this.m_tmp_first_row_types = new DBType[this.types.length];
                this.m_tmp_first_row_items = new DBItem[this.types.length];
                System.arraycopy(this.types, 0, this.m_tmp_first_row_types, 0, this.m_tmp_first_row_types.length);
                System.arraycopy(this.m_last_bind_values, 0, this.m_tmp_first_row_items, 0, this.m_tmp_first_row_items.length);
            }
        }
        if ((dBType = this._getBindDBType(n)) == null || dBType.type != n2) {
            this.newDBType = true;
            if (!this.m_sql_kind_cached) {
                this.m_sql_kind = this.m_statement.getSqlKind();
                this.m_sql_kind_cached = true;
            }
            dBType = this.m_sql_kind == 1 || this.m_sql_kind == 3 ? this.m_connection.db_access.createDBType(n2, this.m_dataSetType == 1, this.m_sql_kind == 1) : this.m_connection.db_access.createDBType(n2, true, this.getFormOfUse(n));
        } else {
            this.newDBType = false;
        }
        return dBType;
    }

    protected DBItem _createOrGetDBItem(int n, DBType dBType, int n2) throws SQLException {
        DBItem dBItem = null;
        if (this.m_first_row) {
            dBItem = this.m_connection.db_access.createDBItem(dBType);
        } else {
            dBItem = this._getDBItem(n, n2);
            DBItem dBItem2 = null;
            dBItem2 = n2 == 0 ? this._getLastDBItem(n) : this._getDBItem(n, n2 - 1);
            if (dBItem == null || dBItem2 != null && dBItem2.equals(dBItem)) {
                dBItem = this.m_connection.db_access.createDBItem(dBType);
            } else {
                dBItem.reinitialize(dBType.max_length);
            }
        }
        return dBItem;
    }

    protected void _setBindDBItem(int n, DBItem dBItem) {
        if (this.m_first_row) {
            this.m_tmp_first_row_items[n] = dBItem;
        } else {
            this.m_last_bind_values[n] = dBItem;
        }
    }

    protected void _setBindDBType(int n, DBType dBType) {
        dBType.FormOfUse = this.getFormOfUse(n);
        dBType.ncs = dBType.isNType() ? (int)this.m_connection.conversion.getNCharSet() : (int)this.m_connection.conversion.getDbCharSet();
        if (this.m_first_row) {
            this.m_tmp_first_row_types[n] = dBType;
        } else {
            this._setDBType(n, dBType);
        }
    }

    private final void _setRowItems(int n, DBItem dBItem) throws SQLException {
        if (this.m_dynamic) {
            DBError.throwSqlException(89);
        }
        this.data[n].setItem(0, dBItem);
        int n2 = 1;
        while (n2 < this.m_arrayDepth) {
            DBItem dBItem2 = dBItem.clone(this.types[n], this.m_connection.db_access);
            this.data[n].setItem(n2, dBItem2);
            ++n2;
        }
    }

    private void _bindsRowCompleted(int n) throws SQLException {
        int n2;
        if (n == -1 && !this.m_dynamic) {
            this._transformToDynamic();
        }
        if (this.m_first_row) {
            this.m_first_row = false;
            this.data = new DBData[this.m_noOfArgs];
            this.types = new DBType[this.m_noOfArgs];
            this.m_last_bind_values = new DBItem[this.m_noOfArgs];
            n2 = 0;
            while (n2 < this.m_noOfArgs) {
                if (this.m_tmp_first_row_types != null && this.m_tmp_first_row_types[n2] != null) {
                    this.types[n2] = this.m_tmp_first_row_types[n2];
                    if (this.m_dataSetType == 1) {
                        this.m_last_bind_values[n2] = this.m_tmp_first_row_items[n2];
                        this._allocData(n2);
                    } else {
                        this._allocDataAndItems(n2);
                    }
                }
                ++n2;
            }
            if (this.m_tmp_first_row_types != null) {
                n2 = 0;
                while (n2 < this.m_tmp_first_row_types.length) {
                    this.m_tmp_first_row_types[n2] = null;
                    this.m_tmp_first_row_items[n2] = null;
                    ++n2;
                }
                this.m_tmp_first_row_items = null;
                this.m_tmp_first_row_types = null;
            }
        }
        if (this.m_cleanedData) {
            n2 = 0;
            while (n2 < this.m_noOfArgs) {
                if (this.types != null && this.types[n2] != null) {
                    if (this.m_dataSetType == 1) {
                        this._allocData(n2);
                    } else {
                        this._allocDataAndItems(n2);
                    }
                }
                ++n2;
            }
            this.m_cleanedData = false;
        }
        if (this.m_dataSetType == 1) {
            n2 = 0;
            while (n2 < this.types.length) {
                if (this.m_last_bind_values[n2] != null) {
                    this._setDBItem(this.m_last_bind_values[n2], n2, n);
                }
                ++n2;
            }
        }
    }

    private void _definesRowCompleted() throws SQLException {
        this.m_first_row = false;
        if (!this.m_dynamic) {
            if (this.types == null) {
                DBError.throwSqlException(21);
            }
            if (this.types.length == 0) {
                DBError.throwSqlException(21);
            }
            int n = this.types.length;
            this.data = new DBData[n];
            int n2 = 0;
            while (n2 < n) {
                this.data[n2] = new DBData(this.m_arrayDepth);
                ++n2;
            }
        }
        int n = 0;
        while (n < this.m_noOfArgs) {
            DBType dBType = this.types[n];
            DBItem dBItem = this.m_connection.db_access.createDBItem(dBType);
            if (dBType.type != 109 && dBType.type != 111 && !dBType.is_stream) {
                dBItem.allocBuffer();
            }
            this._setRowItems(n, dBItem);
            ++n;
        }
    }

    private final void _createArrayFromTypes(int n) throws SQLException {
    }

    public DBDataSetImpl(OracleConnection oracleConnection, OracleStatement oracleStatement, int n, int n2) {
        this.init();
        this.m_connection = oracleConnection;
        this.m_statement = oracleStatement;
        this.m_arrayDepth = n;
        this.m_dataSetType = n2;
    }

    public final boolean isDynamic() {
        return this.m_dynamic;
    }

    public int getNoOfArgs() {
        return this.m_noOfArgs;
    }

    public void setNoOfDefineCol(int n) {
        if (this.m_dynamic || this.m_dataSetType != 0) {
            return;
        }
        this.m_noOfArgs = n;
        DBType[] dBTypeArray = this.types;
        this.types = new DBType[this.m_noOfArgs];
        if (dBTypeArray != null) {
            int n2 = this.m_noOfArgs < dBTypeArray.length ? this.m_noOfArgs : dBTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.types[n3] = dBTypeArray[n3];
                ++n3;
            }
            dBTypeArray = null;
        }
    }

    public boolean isStreamType(int n) {
        if (this.types != null && n < this.types.length && this.types[n] != null) {
            return this.types[n].is_stream;
        }
        return false;
    }

    public boolean hasStreamType() {
        if (this.types != null) {
            int n = 0;
            while (n < this.types.length) {
                if (this.types[n] != null && this.types[n].is_stream) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public int getMissingType() {
        int n = 0;
        while (n < this.types.length) {
            if (this.types[n] == null) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final byte[] getBytesItem(int n, int n2) throws SQLException {
        DBItem dBItem;
        byte[] byArray = null;
        if (this.data != null && this.data[n] != null && (dBItem = this.data[n].getItem(n2)) != null && !dBItem.is_null) {
            byArray = new byte[dBItem.data_size];
            System.arraycopy(dBItem.byte_value, 0, byArray, 0, dBItem.data_size);
        }
        return byArray;
    }

    public final char[] getCharsItem(int n, int n2, int[] nArray, short s) throws SQLException {
        DBItem dBItem;
        char[] cArray = null;
        if (this.data != null && this.data[n] != null && (dBItem = this.data[n].getItem(n2)) != null && !dBItem.is_null) {
            dBItem.getChars(s);
            cArray = dBItem.char_value;
            nArray[0] = dBItem.char_size;
        }
        return cArray;
    }

    public final InputStream getStreamItem(int n, int n2) throws SQLException {
        if (this.data == null || this.data[n] == null) {
            return null;
        }
        DBItem dBItem = this.data[n].getItem(n2);
        if (dBItem == null || dBItem.is_null) {
            return null;
        }
        try {
            if (((OracleInputStream)dBItem.stream_value).isClosed()) {
                DBError.throwSqlException(27);
            }
            if (!((OracleInputStream)dBItem.stream_value).needBytes()) {
                dBItem.setNull();
                return null;
            }
            return dBItem.stream_value;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return null;
        }
    }

    public final char[] getCharsStreamItem(int n, int n2, int[] nArray) throws SQLException {
        if (this.data == null || this.data[n] == null) {
            return null;
        }
        DBItem dBItem = this.data[n].getItem(n2);
        if (dBItem == null || dBItem.is_null) {
            return null;
        }
        char[] cArray = dBItem.getChars((short)1);
        nArray[0] = dBItem.char_size;
        return cArray;
    }

    public final void setStreamItem(int n, int n2, InputStream inputStream) throws SQLException {
        if (this.data == null || this.data[n] == null) {
            return;
        }
        this.data[n].getItem((int)n2).stream_value = inputStream;
    }

    public boolean dataAllocated(int n) {
        return this.data != null && n < this.data.length && this.data[n] != null;
    }

    public final byte[] getBytes(int n, int n2) throws SQLException {
        if (this.data.length < n) {
            return null;
        }
        return this.data[n].getItem(n2).getBytes();
    }

    public final boolean isNull(int n, int n2) throws SQLException {
        return this.data[n].getItem((int)n2).is_null;
    }

    public final void setNull(int n, int n2) throws SQLException {
        this.data[n].getItem(n2).setNull();
    }

    public final int getType(int n) {
        if (this.types == null || n < 0 || this.types.length <= n || this.types[n] == null) {
            return -1;
        }
        return this.types[n].type;
    }

    public final int getExternalType(int n) {
        if (this.types == null || n < 0 || this.types.length <= n || this.types[n] == null) {
            return -1;
        }
        return this.types[n].external_type;
    }

    public final OracleType getOtype(int n) {
        if (this.types == null || this.types.length <= n || this.types[n] == null) {
            return null;
        }
        return this.types[n].otype;
    }

    public final void setType(int n, int n2, int n3, short s) throws SQLException {
        this.setType(n, n2, 0, n3, s);
    }

    public void setType(int n, int n2, int n3, int n4, short s) throws SQLException {
        this.setType(n, n2, n3, n4, s, false);
    }

    public void setType(int n, int n2, int n3, int n4, short s, boolean bl) throws SQLException {
        DBType dBType = null;
        if (this.m_dataSetType == 0) {
            if (n + 1 > this.m_noOfArgs) {
                this.setNoOfDefineCol(n + 1);
            }
            dBType = this.m_connection.db_access.createDBType(n2, false);
            if (!bl && n2 == 96 || n2 == 1 || n2 == 999) {
                if (n4 > 0) {
                    dBType.setMaxSize(n4);
                }
            } else if (n4 > 0 && n4 < dBType.max_length) {
                dBType.max_length = n4;
            }
            dBType.FormOfUse = s;
            dBType.ncs = dBType.isNType() ? (int)this.m_connection.conversion.getNCharSet() : (int)this.m_connection.conversion.getDbCharSet();
            this._setDBType(n, dBType);
        } else {
            dBType = this._createOrGetBindDBType(n, n2);
            if (n4 > 0 && n4 < dBType.max_length) {
                dBType.max_length = n4;
            }
            this._setBindDBType(n, dBType);
            if (this.m_dataSetType == 2 && !this.m_first_row) {
                this._allocDataAndItems(n);
            }
        }
        dBType.setExternalType(n3);
    }

    public final void setType(int n, int n2, OracleType oracleType) throws SQLException {
        if (this.m_dataSetType == 0) {
            if (n + 1 > this.m_noOfArgs) {
                this.setNoOfDefineCol(n + 1);
            }
            DBType dBType = this.m_connection.db_access.createDBType(n2, false);
            dBType.otype = oracleType;
            this._setDBType(n, dBType);
        } else {
            DBType dBType = this._createOrGetBindDBType(n, n2);
            dBType.otype = oracleType;
            this._setBindDBType(n, dBType);
        }
    }

    public final void clearItems() {
        if (this.m_first_row && this.m_tmp_first_row_items != null) {
            int n = 0;
            while (n < this.m_noOfArgs) {
                this.m_tmp_first_row_items[n] = null;
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.m_noOfArgs) {
                this.m_last_bind_values[n] = null;
                ++n;
            }
            if (this.data == null) {
                return;
            }
            int n2 = 0;
            while (n2 < this.data.length) {
                if (this.data[n2] != null) {
                    this.data[n2].clearItems();
                }
                ++n2;
            }
            this.m_cleanedData = true;
        }
    }

    public final void cleanup() {
        int n;
        this.cleanTypes();
        this.cleanData();
        this.data = null;
        int n2 = 0;
        this.m_last_bind_values = null;
        if (this.m_tmp_first_row_items != null) {
            n = this.m_tmp_first_row_items.length;
            n2 = 0;
            while (n2 < n) {
                this.m_tmp_first_row_items[n2] = null;
                ++n2;
            }
            this.m_tmp_first_row_items = null;
        }
        if (this.m_tmp_first_row_types != null) {
            n = this.m_tmp_first_row_types.length;
            n2 = 0;
            while (n2 < n) {
                this.m_tmp_first_row_types[n2] = null;
                ++n2;
            }
            this.m_tmp_first_row_types = null;
        }
        this.init();
    }

    public final void cleanTypes() {
        if (this.types != null) {
            int n = 0;
            while (n < this.types.length) {
                this.types[n] = null;
                ++n;
            }
        }
        this.types = null;
        this.m_noOfArgs = 0;
    }

    public final void cleanData() {
        if (this.m_last_bind_values != null) {
            int n = this.m_last_bind_values.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.m_last_bind_values[n2] != null) {
                    this.m_last_bind_values[n2] = null;
                }
                ++n2;
            }
        }
        this._cleanData();
    }

    public void setBatchSize(int n) throws SQLException {
        if (n == this.m_arrayDepth) {
            return;
        }
        this.m_arrayDepth = n;
        if (this.m_first_row || this.m_dynamic) {
            return;
        }
        if (this.data != null && this.types != null) {
            int n2 = this.data.length;
            int n3 = 0;
            while (n3 < n2) {
                DBType dBType = this.types[n3];
                if (this.data[n3] == null) {
                    this.data[n3] = new DBData(this.m_arrayDepth);
                } else {
                    DBData dBData = this.data[n3];
                    int n4 = dBData.getNItems();
                    int n5 = n4 < n ? n4 : n;
                    this.data[n3] = new DBData(n);
                    int n6 = 0;
                    while (n6 < n5) {
                        this.data[n3].setItem(n6, dBData.getItem(n6));
                        ++n6;
                    }
                    int n7 = -1;
                    DBItem dBItem = dBData.getItem(0);
                    if (dBItem != null && dBItem.byte_value != null) {
                        n7 = dBItem.byte_value.length;
                    }
                    n6 = n5;
                    while (n6 < n) {
                        DBItem dBItem2 = this.m_connection.db_access.createDBItem(dBType);
                        if (n7 == -1) {
                            dBItem2.allocBuffer();
                        } else {
                            dBItem2.allocBuffer(n7);
                        }
                        this.data[n3].setItem(n6, dBItem2);
                        ++n6;
                    }
                }
                ++n3;
            }
        }
    }

    public void rowCompleted(int n) throws SQLException {
        if (this.m_dataSetType == 0) {
            this._definesRowCompleted();
        } else {
            this._bindsRowCompleted(n);
        }
    }

    public boolean setBytesBindItem(int n, int n2, int n3, byte[] byArray) throws SQLException {
        if (this.m_isCached && !this.m_first_row && (this.types == null || this.types.length < n || this.types[n] == null || this.types[n].type != n3 || byArray != null && this.types[n].max_length < byArray.length)) {
            this.setFirstRow(true);
            if (n > 0) {
                this.m_tmp_first_row_types = new DBType[this.types.length];
                this.m_tmp_first_row_items = new DBItem[this.m_last_bind_values.length];
                System.arraycopy(this.types, 0, this.m_tmp_first_row_types, 0, this.types.length);
                System.arraycopy(this.m_last_bind_values, 0, this.m_tmp_first_row_items, 0, this.m_last_bind_values.length);
            }
        }
        DBType dBType = this._createOrGetBindDBType(n, n3);
        DBItem dBItem = this._createOrGetDBItem(n, dBType, n2);
        boolean bl = this.newDBType;
        if (byArray == null) {
            dBItem.setNull();
        } else {
            if (dBType.max_length < byArray.length) {
                dBType.max_length = byArray.length;
                bl = true;
            }
            dBItem.setArrayData(false, byArray);
        }
        this._setBindDBType(n, dBType);
        this._setBindDBItem(n, dBItem);
        return bl;
    }

    public boolean setBytesBindItem(int n, int n2, int n3, String string) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n, n3);
        DBItem dBItem = this._createOrGetDBItem(n, dBType, n2);
        boolean bl = this.newDBType;
        if (string == null) {
            dBItem.setNull();
        } else {
            dBItem.setArrayData(false, string, this.getFormOfUse(n));
            if (dBType.max_length < dBItem.byte_value.length) {
                dBType.max_length = dBItem.byte_value.length;
                bl = true;
            }
        }
        this._setBindDBType(n, dBType);
        this._setBindDBItem(n, dBItem);
        return bl;
    }

    public void setStreamBindItem(int n, int n2, int n3, InputStream inputStream, int n4) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n, n3);
        DBItem dBItem = this._createOrGetDBItem(n, dBType, n2);
        dBItem.setStreamData(false, n4, inputStream);
        this._setBindDBType(n, dBType);
        this._setBindDBItem(n, dBItem);
    }

    public boolean setNullADTBindItem(int n, int n2, int n3, OracleType oracleType) throws SQLException {
        boolean bl = false;
        DBType dBType = this._createOrGetBindDBType(n, n3);
        DBItem dBItem = this._createOrGetDBItem(n, dBType, n2);
        ((OracleTypeADT)oracleType).getTOID();
        if (!oracleType.isInHierarchyOf(dBType.otype)) {
            bl = true;
            dBType.otype = oracleType;
        }
        dBItem.setNull();
        this._setBindDBType(n, dBType);
        this._setBindDBItem(n, dBItem);
        return bl;
    }

    public void setNullBindItem(int n, int n2, int n3) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n, n3);
        DBItem dBItem = this._createOrGetDBItem(n, dBType, n2);
        dBItem.setNull();
        this._setBindDBType(n, dBType);
        this._setBindDBItem(n, dBItem);
    }

    public void setADTBindType(int n, int n2, int n3, OracleType oracleType) throws SQLException {
        DBType dBType = this._createOrGetBindDBType(n, n3);
        DBItem dBItem = this._createOrGetDBItem(n, dBType, n2);
        ((OracleTypeADT)oracleType).getTOID();
        dBType.max_length = 0;
        dBType.otype = oracleType;
        this._setBindDBType(n, dBType);
        this._setBindDBItem(n, null);
    }

    public boolean setADTBindItem(int n, int n2, int n3, byte[] byArray, OracleType oracleType) throws SQLException {
        boolean bl = false;
        DBType dBType = this._createOrGetBindDBType(n, n3);
        DBItem dBItem = this._createOrGetDBItem(n, dBType, n2);
        ((OracleTypeADT)oracleType).getTOID();
        dBType.max_length = byArray.length;
        if (!oracleType.isInHierarchyOf(dBType.otype)) {
            bl = true;
            dBType.otype = oracleType;
        }
        dBItem.setArrayData(false, byArray, true);
        this._setBindDBType(n, dBType);
        this._setBindDBItem(n, dBItem);
        return bl;
    }

    public int checkBindTypes(DBDataSet dBDataSet, int n, int n2) throws SQLException {
        DBType dBType;
        Object object;
        if (n < 0) {
            DBError.throwSqlException(3);
        }
        if (this.m_first_row) {
            return 0;
        }
        if (this.types != null && this.types.length > n && (object = this._getDBType(n)) != null && (((DBType)object).type != n2 || ((DBType)object).max_length == 0 && !this.m_statement.isColumnSetNull(n + 1))) {
            return -1;
        }
        object = (DBDataSetImpl)dBDataSet;
        if (!(object == null || ((DBDataSetImpl)object).types == null || ((DBDataSetImpl)object).types.length <= n || (dBType = super._getDBType(n)) == null || dBType.type == n2 || this.m_connection.looseTimestampDateCheck && (dBType.type == 180 && n2 == 12 || dBType.type == 12 && n2 == 180) || dBType.type == 96 && n2 == 1 || dBType.type == 1 && n2 == 96)) {
            DBError.throwSqlException(12);
        }
        return 0;
    }

    public int checkBindObjectTypes(DBDataSet dBDataSet, int n, int n2, StructDescriptor structDescriptor) throws SQLException {
        DBType dBType;
        Object object;
        if (n < 0) {
            DBError.throwSqlException(3);
        }
        if (this.m_first_row) {
            return 0;
        }
        if (this.types != null && this.types.length > n && (object = this._getDBType(n)) != null && (((DBType)object).type != n2 || ((DBType)object).max_length == 0 && !this.m_statement.isColumnSetNull(n + 1) || !((DBType)object).otype.isInHierarchyOf(structDescriptor))) {
            return -1;
        }
        object = (DBDataSetImpl)dBDataSet;
        if (!(object == null || ((DBDataSetImpl)object).types == null || ((DBDataSetImpl)object).types.length <= n || (dBType = super._getDBType(n)) == null || dBType.type == n2 || dBType.type == 96 && n2 == 1 || dBType.type == 1 && n2 == 96)) {
            DBError.throwSqlException(12);
        }
        return 0;
    }

    public int checkBindsInAndOut(DBDataSet dBDataSet, int n) throws SQLException {
        DBDataSetImpl dBDataSetImpl = (DBDataSetImpl)dBDataSet;
        int n2 = 0;
        if (this.types != null) {
            n2 = this.types.length;
        }
        if (dBDataSetImpl != null && dBDataSetImpl.types != null && dBDataSetImpl.types.length > n2) {
            n2 = dBDataSetImpl.types.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!(this.data != null && n3 < this.data.length && this.data[n3] != null && this.data[n3].getItem(n) != null || dBDataSetImpl != null && dBDataSetImpl.data != null && n3 < dBDataSetImpl.data.length && dBDataSetImpl.data[n3] != null && dBDataSetImpl.data[n3].getItem(n) != null)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void removeFirstRow() throws SQLException {
        if (this.data != null) {
            int n = 0;
            while (n < this.data.length) {
                this.data[n].removeFirstItem();
                ++n;
            }
        }
    }

    public void prependRowidColumn() throws SQLException {
        ++this.m_noOfArgs;
        DBType[] dBTypeArray = new DBType[this.m_noOfArgs];
        dBTypeArray[0] = this.m_connection.db_access.createDBType(104, false);
        System.arraycopy(this.types, 0, dBTypeArray, 1, this.types.length);
        this.types = dBTypeArray;
    }

    public void removeRowidColumn() throws SQLException {
        --this.m_noOfArgs;
        DBType[] dBTypeArray = new DBType[this.m_noOfArgs];
        System.arraycopy(this.types, 1, dBTypeArray, 0, this.types.length - 1);
        this.types = dBTypeArray;
    }

    public void enterCache() throws SQLException {
        if (this.m_dataSetType != 0) {
            this.cleanData();
            this.m_isCached = true;
        } else if (this.m_statement.columns_defined_by_user) {
            this.m_statement.columns_defined_by_user = false;
            this.cleanTypes();
        }
    }

    public void reactivate() throws SQLException {
    }

    public DBType[] getDBTypes() {
        return this.types;
    }

    public DBData[] getDBData() {
        return this.data;
    }

    public final String getInfoString() throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this + "\n" + "  DBDataSetImpl.m_dynamic=" + this.m_dynamic + "\n" + "  DBDataSetImpl.m_arrayDepth=" + this.m_arrayDepth + " (valid only when m_dynamic=false)\n");
        stringBuffer.append("  DBDataSetImpl.m_dataSetType=" + this.m_dataSetType + "\n");
        stringBuffer.append("  DBDataSetImpl.m_noOfArgs=" + this.m_noOfArgs + "\n");
        if (this.types == null) {
            stringBuffer.append("  DBDataSetImpl.types is null");
        } else {
            stringBuffer.append("  DBDataSetImpl.types.length=" + this.types.length);
            n = 0;
            while (n < this.types.length) {
                if (this.types[n] == null) {
                    stringBuffer.append("\n    types[" + n + "]=null");
                } else {
                    stringBuffer.append("\n    types[" + n + "].type=" + DBType.getStringType(this.types[n].type) + " (max_length=" + this.types[n].max_length + ")");
                }
                ++n;
            }
        }
        stringBuffer.append("\n");
        if (this.data == null) {
            stringBuffer.append("  DBDataSetImpl.data is null");
        } else {
            stringBuffer.append("  DBDataSetImpl.data.length=" + this.data.length);
            n = 0;
            while (n < this.data.length) {
                if (this.data[n] == null) {
                    stringBuffer.append("\n    data[" + n + "]=null");
                } else {
                    int n2 = 0;
                    while (n2 < this.data[n].getNItems()) {
                        DBItem dBItem = this.data[n].getItem(n2);
                        if (dBItem == null) {
                            stringBuffer.append("\n    data[" + n + "].items[" + n2 + "]=null");
                        } else {
                            stringBuffer.append("\n    data[" + n + "].items[" + n2 + "] has " + dBItem.data_size + " bytes:\n");
                            if (dBItem.byte_value != null) {
                                stringBuffer.append("\n    data[" + n + "].items[" + n2 + "] has " + dBItem.byte_value.length + " bytes allocated\n");
                                stringBuffer.append(OracleLog.bytesToFormattedStr(dBItem.byte_value, dBItem.data_size, "    "));
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (this.m_last_bind_values == null) {
            stringBuffer.append("  DBDataSetImpl.m_last_bind_values is null\n");
        } else {
            stringBuffer.append("  DBDataSetImpl.m_last_bind_values has size of " + this.m_last_bind_values.length + "\n");
        }
        if (this.m_tmp_first_row_items == null) {
            stringBuffer.append("  DBDataSetImpl.m_tmp_first_row_items is null\n");
        } else {
            stringBuffer.append("  DBDataSetImpl.m_tmp_first_row_items has size of " + this.m_tmp_first_row_items.length + "\n");
        }
        if (this.m_tmp_first_row_types == null) {
            stringBuffer.append("  DBDataSetImpl.m_tmp_first_row_types is null\n");
        } else {
            stringBuffer.append("  DBDataSetImpl.m_tmp_first_row_types has size of " + this.m_tmp_first_row_types.length + "\n");
        }
        return stringBuffer.toString();
    }

    public short getFormOfUse(int n) {
        if (this.form_of_use == null) {
            return 1;
        }
        if (this.form_of_use.length <= n) {
            return 1;
        }
        if (this.form_of_use[n] == 0) {
            return 1;
        }
        return this.form_of_use[n];
    }

    public void setFormOfUse(int n, short s) {
        DBType dBType;
        int n2;
        int n3 = n - 1;
        if (this.form_of_use == null) {
            n2 = Math.max(n3 + 1, _MIN_ARG_COUNT);
            this.form_of_use = new short[n2];
        } else if (n3 >= this.form_of_use.length) {
            n2 = this.form_of_use.length;
            n2 = Math.max(n3 + 1, n2);
            short[] sArray = new short[2 * n2];
            System.arraycopy(this.form_of_use, 0, sArray, 0, this.form_of_use.length);
            this.form_of_use = sArray;
            sArray = null;
        }
        this.form_of_use[n3] = s;
        if (this.m_dataSetType == 2 && (dBType = this._getBindDBType(n3)) != null) {
            this._setBindDBType(n3, dBType);
        }
    }

    public void setFirstRow(boolean bl) {
        this.m_first_row = bl;
    }

    public void clearItem(int n, boolean bl) {
        if (!bl && this.m_first_row && this.m_tmp_first_row_items != null) {
            int n2 = 0;
            while (n2 < this.m_noOfArgs) {
                this.m_tmp_first_row_items[n2] = null;
                ++n2;
            }
        } else {
            int n3;
            if (this.data == null) {
                return;
            }
            if (!bl) {
                n3 = 0;
                while (n3 < this.m_last_bind_values.length) {
                    this.m_last_bind_values[n3] = null;
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < this.data.length && this.data[n3] != null) {
                this.data[n3].clearItem(n);
                ++n3;
            }
            this.m_cleanedData = true;
        }
    }

    public final void clearItemBuffers() throws SQLException {
        if (this.data != null) {
            int n = 0;
            while (n < this.data.length) {
                if (this.data[n] != null) {
                    this.data[n].clearItemBuffers();
                }
                ++n;
            }
        }
    }

    public void reallocOutBuffers() throws SQLException {
        if (this.data != null) {
            int n = 0;
            while (n < this.data.length && this.data[n] != null) {
                this.data[n].reallocItemBuffers();
                ++n;
            }
        }
    }
}

