/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;

public abstract class OracleXAConnection
extends OraclePooledConnection
implements XAConnection {
    protected XAResource m_xarsrc = null;

    public OracleXAConnection() throws XAException {
        this((Connection)null);
    }

    public OracleXAConnection(Connection connection) throws XAException {
        super(connection);
    }

    public abstract XAResource getXAResource();

    public synchronized Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        if (this.m_xarsrc != null) {
            ((OracleXAResource)this.m_xarsrc).setLogicalConnection(connection);
        }
        return connection;
    }

    boolean getAutoCommit() throws SQLException {
        return this.m_autoCommit;
    }

    void setAutoCommit(boolean bl) throws SQLException {
        this.m_autoCommit = bl;
    }
}

