/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import oracle.net.ns.NetException;

public class JndiAttrs {
    private Properties env;
    private static final String nFactory = "java.naming.factory.initial";
    private static final String nProvider = "java.naming.provider.url";
    private static final String nProfile = "ora-net-profile";
    private static final String default_nFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    DirContext ctx;

    public JndiAttrs(Properties properties) throws NetException {
        Class<Object> clazz;
        String string = null;
        this.env = new Properties();
        if (((Hashtable)properties).containsKey(nFactory)) {
            ((Hashtable)this.env).put(nFactory, properties.getProperty(nFactory));
        } else {
            ((Hashtable)this.env).put(nFactory, default_nFactory);
        }
        if (((Hashtable)properties).containsKey(nProvider)) {
            string = properties.getProperty(nProvider);
            if (string.startsWith("ldaps")) {
                ((Hashtable)this.env).put("java.naming.ldap.factory.socket", "oracle.net.jndi.CustomSSLSocketFactory");
                ((Hashtable)this.env).put("java.naming.security.protocol", "ssl");
                string = "ldap:" + string.substring(6);
            }
            ((Hashtable)this.env).put(nProvider, string);
        }
        if (((Hashtable)properties).containsKey("oracle.net.profile")) {
            ((Hashtable)this.env).put(nProfile, properties.getProperty("oracle.net.profile"));
        }
        try {
            clazz = Class.forName("javax.naming.directory.InitialDirContext");
            if (((Hashtable)this.env).get(nFactory) == null) {
                ((Hashtable)this.env).put(nFactory, default_nFactory);
            }
            if (((Hashtable)this.env).get(nProvider) == null) {
                ((Hashtable)this.env).put(nProvider, string);
            }
        }
        catch (Exception exception) {
            throw new NetException(110, exception.toString());
        }
        clazz = ((Hashtable)properties).get("java.naming.security.authentication");
        if (clazz != null) {
            ((Hashtable)this.env).put("java.naming.security.authentication", clazz);
        }
        if ((clazz = ((Hashtable)properties).get("java.naming.security.principal")) != null) {
            ((Hashtable)this.env).put("java.naming.security.principal", clazz);
        }
        if ((clazz = ((Hashtable)properties).get("java.naming.security.credentials")) != null) {
            ((Hashtable)this.env).put("java.naming.security.credentials", clazz);
        }
        int n = 0;
        while (n < 3) {
            try {
                this.ctx = new InitialDirContext(this.env);
                break;
            }
            catch (NamingException namingException) {
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName("javax.net.ssl.SSLHandshakeException");
                }
                catch (Exception exception) {
                    throw new NetException(108, namingException.toString());
                }
                if (!clazz2.isInstance(namingException.getRootCause()) || n >= 3) {
                    throw new NetException(108, namingException.toString());
                }
                ++n;
            }
        }
    }

    public void close() throws NetException {
        try {
            this.ctx.close();
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
    }

    public Vector getAttrs(String string, String[] stringArray) throws NetException {
        String string2 = "cn=";
        Attributes attributes = null;
        try {
            string2 = string2.concat(string);
            attributes = this.ctx.getAttributes(string2, stringArray);
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
        return this.setAttrs(attributes);
    }

    public Vector getProfileAttrs(String string) throws NetException {
        String string2 = "cn=";
        Attributes attributes = null;
        try {
            string2 = string2.concat(string);
            attributes = this.ctx.getAttributes(string2);
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
        return this.setAttrs(attributes);
    }

    private Vector setAttrs(Attributes attributes) throws NetException {
        Vector vector = new Vector(1, 1);
        if (attributes == null) {
            System.out.println("No attributes");
        } else {
            try {
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                    Attribute attribute = namingEnumeration.next();
                    NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                    while (namingEnumeration2.hasMoreElements()) {
                        vector.addElement(namingEnumeration2.nextElement());
                    }
                }
            }
            catch (NamingException namingException) {
                throw new NetException(108, namingException.toString());
            }
        }
        return vector;
    }

    public void setEnv(String string, String string2) {
        ((Hashtable)this.env).put(string, string2);
    }
}

