/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;

class ResultSetUtil {
    static final int[][] allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Thu_Apr__8_03:39:14_PDT_2010";

    ResultSetUtil() {
    }

    static OracleResultSet createScrollResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n) throws SQLException {
        switch (n) {
            case 1: {
                return oracleResultSet;
            }
            case 2: {
                return new UpdatableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 3: {
                return new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 4: {
                ScrollableResultSet scrollableResultSet = new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
                return new UpdatableResultSet(scrollRsetStatement, scrollableResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 5: {
                return new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 6: {
                SensitiveScrollableResultSet sensitiveScrollableResultSet = new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
                return new UpdatableResultSet(scrollRsetStatement, sensitiveScrollableResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
        }
        DatabaseError.throwSqlException(23, null);
        return null;
    }

    static int getScrollType(int n) {
        return allRsetTypes[n][0];
    }

    static int getUpdateConcurrency(int n) {
        return allRsetTypes[n][1];
    }

    static int getRsetTypeCode(int n, int n2) throws SQLException {
        for (int i = 0; i < allRsetTypes.length; ++i) {
            if (allRsetTypes[i][0] != n || allRsetTypes[i][1] != n2) continue;
            return i;
        }
        DatabaseError.throwSqlException(68);
        return 0;
    }

    static boolean needIdentifier(int n) throws SQLException {
        return n != 1 && n != 3;
    }

    static boolean needIdentifier(int n, int n2) throws SQLException {
        return ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(n, n2));
    }

    static boolean needCache(int n) throws SQLException {
        return n >= 3;
    }

    static boolean needCache(int n, int n2) throws SQLException {
        return ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(n, n2));
    }

    static boolean supportRefreshRow(int n) throws SQLException {
        return n >= 4;
    }

    static boolean supportRefreshRow(int n, int n2) throws SQLException {
        return ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(n, n2));
    }
}

