/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit = false;
    protected boolean savedXAConnectionAutoCommit = false;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection = null;
    protected OracleXAConnection xaconnection = null;
    protected int timeout = 60;
    protected String dblink = null;
    private Connection logicalConnection = null;
    private String synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
    private String synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
    private String recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected boolean canBeMigratablySuspended = false;
    Xid lastActiveXid = null;
    protected Xid activeXid = null;
    protected Hashtable xidHash = new Hashtable(50);
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Thu_Apr__8_03:39:22_PDT_2010";

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.connection = connection;
        this.xaconnection = oracleXAConnection;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    public synchronized void setConnection(Connection connection) throws XAException {
        this.connection = connection;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    final synchronized XidListEntry getMatchingXidListEntry(Xid xid) {
        XidListEntry xidListEntry = (XidListEntry)this.xidHash.get(xid);
        return xidListEntry;
    }

    protected final synchronized boolean removeXidFromList(Xid xid) {
        if (this.isSameXid(this.activeXid, xid)) {
            this.activeXid = null;
        }
        return this.xidHash.remove(xid) != null;
    }

    final boolean isSameXid(Xid xid, Xid xid2) {
        return xid == xid2;
    }

    protected final boolean isOnStack(Xid xid) throws XAException {
        return this.xidHash.containsKey(xid);
    }

    protected final synchronized boolean isXidListEmpty() {
        return this.xidHash.isEmpty();
    }

    protected synchronized void createOrUpdateXid(Xid xid, boolean bl, boolean[] blArray) {
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            blArray[0] = true;
            xidListEntry.isSuspended = bl;
        } else {
            xidListEntry = new XidListEntry(xid, bl);
            this.xidHash.put(xid, xidListEntry);
        }
        if (bl) {
            this.lastActiveXid = this.activeXid;
            this.activeXid = null;
        } else {
            this.enterGlobalTxnMode();
            if (this.lastActiveXid != null && this.isSameXid(xid, this.lastActiveXid)) {
                this.lastActiveXid = null;
            }
            this.activeXid = xidListEntry.xid;
        }
    }

    protected synchronized boolean updateXidList(Xid xid, boolean[] blArray) {
        boolean bl = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl = true;
            blArray[0] = true;
            blArray[1] = xidListEntry.isSuspended;
            if (xidListEntry.isSuspended) {
                this.enterGlobalTxnMode();
            } else {
                this.exitGlobalTxnMode();
            }
        }
        return bl;
    }

    protected boolean isXidSuspended(Xid xid) throws XAException {
        boolean bl = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl = xidListEntry.isSuspended;
        }
        return bl;
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid xid2 = null;
        if (this.activeXid != null && !this.isSameXid(this.activeXid, xid)) {
            xid2 = this.activeXid;
            if (!this.isXidSuspended(this.activeXid)) {
                this.end(this.activeXid, 0x2000000);
                this.lastActiveXid = this.activeXid;
                this.activeXid = null;
            }
        }
        return xid2;
    }

    protected void resumeStacked(Xid xid) throws XAException {
        if (xid != null) {
            this.start(xid, 0x8000000);
            this.activeXid = xid;
        }
    }

    public abstract void start(Xid var1, int var2) throws XAException;

    public abstract void end(Xid var1, int var2) throws XAException;

    public abstract void commit(Xid var1, boolean var2) throws XAException;

    public abstract int prepare(Xid var1) throws XAException;

    public abstract void forget(Xid var1) throws XAException;

    public abstract void rollback(Xid var1) throws XAException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int n) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            if ((n & 0x1800000) != n) {
                throw new XAException(-5);
            }
            Statement statement = null;
            ResultSet resultSet = null;
            ArrayList<OracleXid> arrayList = new ArrayList<OracleXid>(50);
            try {
                try {
                    statement = this.connection.createStatement();
                    try {
                        statement.execute(this.synchronizeBeforeRecoverNewCall);
                    }
                    catch (Exception exception) {
                        statement.execute(this.synchronizeBeforeRecoverOldCall);
                    }
                    resultSet = statement.executeQuery(this.recoverySqlRows);
                    while (resultSet.next()) {
                        arrayList.add(new OracleXid(resultSet.getInt(1), resultSet.getBytes(2), resultSet.getBytes(3)));
                    }
                    Object var8_9 = null;
                }
                catch (SQLException sQLException) {
                    throw new XAException(-3);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (resultSet == null) throw throwable;
                    resultSet.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
            int n2 = arrayList.size();
            Xid[] xidArray = new Xid[n2];
            System.arraycopy(arrayList.toArray(), 0, xidArray, 0, n2);
            return xidArray;
        }
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        try {
            this.savedConnectionAutoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
            this.xaconnection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void resume(Xid xid) throws XAException {
        this.start(xid, 0x8000000);
    }

    public void join(Xid xid) throws XAException {
        this.start(xid, 0x200000);
    }

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000000);
    }

    public void join(Xid xid, int n) throws XAException {
        this.timeout = n;
        this.start(xid, 0x200000);
    }

    public void resume(Xid xid, int n) throws XAException {
        this.timeout = n;
        this.start(xid, 0x8000000);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        Connection connection = null;
        if (!(xAResource instanceof OracleXAResource)) {
            return false;
        }
        connection = ((OracleXAResource)xAResource).getConnection();
        try {
            if (this.connection == null || ((OracleConnection)this.connection).isClosed()) {
                return false;
            }
            String string = ((OracleConnection)this.connection).getURL();
            String string2 = ((OracleConnection)this.connection).getProtocolType();
            if (connection != null) {
                boolean bl = connection.equals(this.connection) || ((OracleConnection)connection).getURL().equals(string) || ((OracleConnection)connection).getProtocolType().equals(string2) && string2.equals("kprb");
                return bl;
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(-3);
        }
        return false;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.timeout = n;
        return true;
    }

    public String getDBLink() {
        return this.dblink;
    }

    public void setDBLink(String string) {
        this.dblink = string;
    }

    public void setLogicalConnection(Connection connection) {
        this.logicalConnection = connection;
    }

    protected void allowGlobalTxnModeOnly(int n) throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            throw new XAException(n);
        }
    }

    protected void exitGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(0);
    }

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(1);
    }

    protected void checkError(int n) throws OracleXAException {
        if ((n & 0xFFFF) != 0) {
            throw new OracleXAException(n);
        }
    }

    protected void checkError(int n, int n2) throws OracleXAException {
        if ((n & 0xFFFF) != 0) {
            throw new OracleXAException(n, n2);
        }
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;

        XidListEntry(Xid xid, boolean bl) {
            this.xid = xid;
            this.isSuspended = bl;
        }
    }
}

