/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb;

import java.util.List;
import java.util.Map;
import org.neo4j.rest.graphdb.RequestResult;

public class RestResultException
extends RuntimeException {
    public RestResultException(Object result, String ... messages) {
        super(RestResultException.format(RestResultException.toMap(result), messages));
    }

    public RestResultException(String ... messages) {
        super(RestResultException.format(messages));
    }

    private static String format(String[] messages) {
        StringBuilder sb = new StringBuilder();
        if (messages == null || messages.length == 0) {
            return "";
        }
        for (String s : messages) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    private static String format(Map<?, ?> result, String ... messages) {
        if (result == null && (messages == null || messages.length == 0)) {
            return "Unknown Exception";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(RestResultException.format(messages));
        sb.append(result.get("message")).append(" at\n");
        sb.append(result.get("exception")).append("\n");
        List stacktrace = (List)result.get("stacktrace");
        if (stacktrace != null) {
            for (String line : stacktrace) {
                sb.append("   ").append(line).append("\n");
            }
        }
        if (result.containsKey("body")) {
            sb.append(RestResultException.format(RestResultException.toMap(result.get("body")), new String[0]));
        }
        return sb.toString();
    }

    public static boolean isExceptionResult(Object result) {
        Map<String, Object> map = RestResultException.toMap(result);
        return map != null && (RestResultException.hasErrorStatus(map) || map.containsKey("exception") || map.containsKey("message") || RestResultException.isExceptionResult(map.get("body")));
    }

    private static boolean hasErrorStatus(Map<String, Object> map) {
        Object status = map.get("status");
        return status != null && !status.toString().startsWith("2");
    }

    private static Map<String, Object> toMap(Object result) {
        if (!(result instanceof Map)) {
            return null;
        }
        return (Map)result;
    }

    static RestResultException create(RequestResult result, String ... messages) {
        if (result.isMap()) {
            return new RestResultException(result.toMap(), messages);
        }
        if (messages.length == 0) {
            return new RestResultException(new String[]{"Error executing request,status " + result.getStatus() + " message " + result.getText()});
        }
        return new RestResultException(messages);
    }
}

