/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLAlias
implements Cloneable,
Serializable,
ISQLAlias,
Comparable {
    private boolean _autoLogon;
    private boolean _connectAtStartup;
    private IIdentifier _driverId;
    private SQLDriverPropertyCollection _driverProps = new SQLDriverPropertyCollection();
    private String _folderFilterExpression = "";
    private IIdentifier _id;
    private String _name;
    private String _nameFilterExpression = "";
    private String _password;
    private transient PropertyChangeReporter _propChgReporter;
    private String _schemaFilterExpression = "";
    private String _url;
    private boolean _useDriverProperties = false;
    private String _userName;
    private static final StringManager s_stringMgr;
    public static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.squirrel_sql.fw.sql.SQLAlias");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_stringMgr = StringManagerFactory.getStringManager((Class)clazz);
    }

    public SQLAlias() {
    }

    public SQLAlias(IIdentifier id) {
        this._id = id;
        this._name = "";
        this._driverId = null;
        this._url = "";
        this._userName = "";
        this._password = "";
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    public synchronized void assignFrom(ISQLAlias rhs) throws ValidationException {
        this.setName(rhs.getName());
        this.setDriverIdentifier(rhs.getDriverIdentifier());
        this.setUrl(rhs.getUrl());
        this.setUserName(rhs.getUserName());
        this.setPassword(rhs.getPassword());
        this.setAutoLogon(rhs.isAutoLogon());
        this.setUseDriverProperties(rhs.getUseDriverProperties());
        this.setDriverProperties(rhs.getDriverProperties());
    }

    public Object clone() throws CloneNotSupportedException {
        SQLAlias alias = (SQLAlias)super.clone();
        alias._propChgReporter = null;
        alias.setDriverProperties(this.getDriverProperties());
        return alias;
    }

    public int compareTo(Object rhs) {
        return this._name.compareTo(((ISQLAlias)rhs).getName());
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((ISQLAlias)rhs).getIdentifier().equals((Object)this.getIdentifier());
        }
        return rc;
    }

    public IIdentifier getDriverIdentifier() {
        return this._driverId;
    }

    public synchronized SQLDriverPropertyCollection getDriverProperties() {
        int count = this._driverProps.size();
        SQLDriverProperty[] newar = new SQLDriverProperty[count];
        int i = 0;
        while (i < count) {
            newar[i] = (SQLDriverProperty)this._driverProps.getDriverProperty(i).clone();
            ++i;
        }
        SQLDriverPropertyCollection coll = new SQLDriverPropertyCollection();
        coll.setDriverProperties(newar);
        return coll;
    }

    public String getFolderFilterExpression() {
        return this._folderFilterExpression;
    }

    public IIdentifier getIdentifier() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getNameFilterExpression() {
        return this._nameFilterExpression;
    }

    public String getPassword() {
        return this._password;
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter((Object)this);
        }
        return this._propChgReporter;
    }

    public String getSchemaFilterExpression() {
        return this._schemaFilterExpression;
    }

    private String getString(String data) {
        return data == null ? "" : data.trim();
    }

    public String getUrl() {
        return this._url;
    }

    public boolean getUseDriverProperties() {
        return this._useDriverProperties;
    }

    public String getUserName() {
        return this._userName;
    }

    public synchronized int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public boolean isAutoLogon() {
        return this._autoLogon;
    }

    public boolean isConnectAtStartup() {
        return this._connectAtStartup;
    }

    public boolean isFiltered() {
        return this._nameFilterExpression != null && this._nameFilterExpression.trim().length() != 0 || this._schemaFilterExpression != null && this._schemaFilterExpression.trim().length() != 0 || this._folderFilterExpression != null && this._folderFilterExpression.trim().length() != 0;
    }

    public synchronized boolean isValid() {
        return this._name.length() > 0 && this._driverId != null && this._url.length() > 0;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    public void setAutoLogon(boolean value) {
        if (this._autoLogon != value) {
            this._autoLogon = value;
            this.getPropertyChangeReporter().firePropertyChange("autoLogon", !this._autoLogon, this._autoLogon);
        }
    }

    public void setConnectAtStartup(boolean value) {
        if (this._connectAtStartup != value) {
            this._connectAtStartup = value;
            this.getPropertyChangeReporter().firePropertyChange("connectAtStartup", !this._connectAtStartup, this._connectAtStartup);
        }
    }

    public void setDriverIdentifier(IIdentifier data) throws ValidationException {
        if (data == null) {
            throw new ValidationException(IStrings.ERR_BLANK_DRIVER);
        }
        if (this._driverId != data) {
            IIdentifier oldValue = this._driverId;
            this._driverId = data;
            this.getPropertyChangeReporter().firePropertyChange("driverIdentifier", (Object)oldValue, (Object)this._driverId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDriverProperties(SQLDriverPropertyCollection value) {
        this._driverProps.clear();
        if (value != null) {
            SQLDriverPropertyCollection sQLDriverPropertyCollection = value;
            synchronized (sQLDriverPropertyCollection) {
                int count = value.size();
                SQLDriverProperty[] newar = new SQLDriverProperty[count];
                int i = 0;
                while (i < count) {
                    newar[i] = (SQLDriverProperty)value.getDriverProperty(i).clone();
                    ++i;
                }
                this._driverProps.setDriverProperties(newar);
            }
        }
    }

    public void setFolderFilterExpression(String expression) {
        String data = this.getString(expression);
        if (this._folderFilterExpression != data) {
            String oldValue = this._folderFilterExpression;
            this._folderFilterExpression = data;
            this.getPropertyChangeReporter().firePropertyChange("folderFilterExpression", (Object)oldValue, (Object)this._folderFilterExpression);
        }
    }

    public void setIdentifier(IIdentifier id) {
        this._id = id;
    }

    public void setName(String name) throws ValidationException {
        String data = this.getString(name);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_NAME);
        }
        if (this._name != data) {
            String oldValue = this._name;
            this._name = data;
            this.getPropertyChangeReporter().firePropertyChange("name", (Object)oldValue, (Object)this._name);
        }
    }

    public void setNameFilterExpression(String expression) {
        String data = this.getString(expression);
        if (this._nameFilterExpression != data) {
            String oldValue = this._nameFilterExpression;
            this._nameFilterExpression = data;
            this.getPropertyChangeReporter().firePropertyChange("nameFilterExpression", (Object)oldValue, (Object)this._nameFilterExpression);
        }
    }

    public void setPassword(String password) {
        String data = this.getString(password);
        if (this._password != data) {
            String oldValue = this._password;
            this._password = data;
            this.getPropertyChangeReporter().firePropertyChange("password", (Object)oldValue, (Object)this._password);
        }
    }

    public void setSchemaFilterExpression(String expression) {
        String data = this.getString(expression);
        if (this._schemaFilterExpression != data) {
            String oldValue = this._schemaFilterExpression;
            this._schemaFilterExpression = data;
            this.getPropertyChangeReporter().firePropertyChange("schemaFilterExpression", (Object)oldValue, (Object)this._schemaFilterExpression);
        }
    }

    public void setUrl(String url) throws ValidationException {
        String data = this.getString(url);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_URL);
        }
        if (this._url != data) {
            String oldValue = this._url;
            this._url = data;
            this.getPropertyChangeReporter().firePropertyChange("url", (Object)oldValue, (Object)this._url);
        }
    }

    public void setUseDriverProperties(boolean value) {
        if (this._useDriverProperties != value) {
            boolean oldValue = this._useDriverProperties;
            this._useDriverProperties = value;
            this.getPropertyChangeReporter().firePropertyChange("useDriverProperties", oldValue, this._useDriverProperties);
        }
    }

    public void setUserName(String userName) {
        String data = this.getString(userName);
        if (this._userName != data) {
            String oldValue = this._userName;
            this._userName = data;
            this.getPropertyChangeReporter().firePropertyChange("userName", (Object)oldValue, (Object)this._userName);
        }
    }

    public String toString() {
        return this.getName();
    }

    static /* synthetic */ StringManager access$0() {
        return s_stringMgr;
    }

    private static interface IStrings {
        public static final String ERR_BLANK_DRIVER = SQLAlias.access$0().getString("SQLAlias.error.blankdriver");
        public static final String ERR_BLANK_NAME = SQLAlias.access$0().getString("SQLAlias.error.blankname");
        public static final String ERR_BLANK_URL = SQLAlias.access$0().getString("SQLAlias.error.blankurl");
    }
}

