/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverClassLoader;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLDriverManager {
    private static final ILogger s_log;
    private Map _driverInfo = new HashMap();
    private Map _classLoaders = new HashMap();
    private MyDriverListener _myDriverListener = new MyDriverListener();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.SQLDriverManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_log = LoggerController.createLogger((Class)clazz);
    }

    public synchronized void registerSQLDriver(ISQLDriver sqlDriver) throws IllegalAccessException, InstantiationException, ClassNotFoundException, MalformedURLException {
        this.unregisterSQLDriver(sqlDriver);
        sqlDriver.addPropertyChangeListener((PropertyChangeListener)this._myDriverListener);
        SQLDriverClassLoader loader = new SQLDriverClassLoader(sqlDriver);
        Class<?> driverClass = loader.loadClass(sqlDriver.getDriverClassName());
        this._driverInfo.put(sqlDriver.getIdentifier(), driverClass.newInstance());
        this._classLoaders.put(sqlDriver.getIdentifier(), loader);
        sqlDriver.setJDBCDriverClassLoaded(true);
    }

    public synchronized void unregisterSQLDriver(ISQLDriver sqlDriver) {
        sqlDriver.setJDBCDriverClassLoaded(false);
        sqlDriver.removePropertyChangeListener((PropertyChangeListener)this._myDriverListener);
        this._driverInfo.remove(sqlDriver.getIdentifier());
        this._classLoaders.remove(sqlDriver.getIdentifier());
    }

    public SQLConnection getConnection(ISQLDriver sqlDriver, ISQLAlias alias, String user, String pw) throws ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException, SQLException {
        Connection jdbcConn;
        Driver driver;
        Properties props = new Properties();
        if (user != null) {
            props.put("user", user);
        }
        if (pw != null) {
            props.put("password", pw);
        }
        if ((driver = (Driver)this._driverInfo.get(sqlDriver.getIdentifier())) == null) {
            s_log.debug((Object)("Loading driver that wasn't registered: " + sqlDriver.getDriverClassName()));
            SQLDriverClassLoader loader = new SQLDriverClassLoader(sqlDriver);
            Class<?> driverCls = loader.loadClass(sqlDriver.getDriverClassName());
            driver = (Driver)driverCls.newInstance();
        }
        if ((jdbcConn = driver.connect(alias.getUrl(), props)) == null) {
            throw new SQLException("Unable to create connection. Check your URL.");
        }
        return new SQLConnection(jdbcConn, null);
    }

    public Driver getJDBCDriver(IIdentifier id) {
        if (id == null) {
            throw new IllegalArgumentException("IIdentifier == null");
        }
        return (Driver)this._driverInfo.get(id);
    }

    public SQLDriverClassLoader getSQLDriverClassLoader(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("SQLDriverClassLoader == null");
        }
        return (SQLDriverClassLoader)this._classLoaders.get(driver.getIdentifier());
    }

    private final class MyDriverListener
    implements PropertyChangeListener {
        private MyDriverListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || propName.equals("driverClassName") || propName.equals("jarFileNames")) {
                Object obj = evt.getSource();
                if (obj instanceof ISQLDriver) {
                    ISQLDriver driver = (ISQLDriver)obj;
                    SQLDriverManager.this.unregisterSQLDriver(driver);
                    try {
                        SQLDriverManager.this.registerSQLDriver(driver);
                    }
                    catch (IllegalAccessException ex) {
                        s_log.error((Object)("Unable to create instance of Class " + driver.getDriverClassName() + " for JDCB driver " + driver.getName()), (Throwable)ex);
                    }
                    catch (InstantiationException ex) {
                        s_log.error((Object)("Unable to create instance of Class " + driver.getDriverClassName() + " for JDCB driver " + driver.getName()), (Throwable)ex);
                    }
                    catch (MalformedURLException ex) {
                        s_log.error((Object)("Unable to create instance of Class " + driver.getDriverClassName() + " for JDCB driver " + driver.getName()), (Throwable)ex);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        s_log.error((Object)("Unable to find Driver Class " + driver.getDriverClassName() + " for JDCB driver " + driver.getName()));
                    }
                } else {
                    s_log.error((Object)"SqlDriverManager.MyDriverListener is listening to a non-ISQLDriver");
                }
            }
        }
    }
}

