/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections;

import net.sourceforge.sqlexplorer.connections.actions.AbstractConnectionTreeAction;
import net.sourceforge.sqlexplorer.connections.actions.ChangeAliasAction;
import net.sourceforge.sqlexplorer.connections.actions.CloseAllConnectionsAction;
import net.sourceforge.sqlexplorer.connections.actions.CloseConnectionAction;
import net.sourceforge.sqlexplorer.connections.actions.CommitAction;
import net.sourceforge.sqlexplorer.connections.actions.ConnectAliasAction;
import net.sourceforge.sqlexplorer.connections.actions.CopyAliasAction;
import net.sourceforge.sqlexplorer.connections.actions.DeleteAliasAction;
import net.sourceforge.sqlexplorer.connections.actions.NewAliasAction;
import net.sourceforge.sqlexplorer.connections.actions.NewEditorAction;
import net.sourceforge.sqlexplorer.connections.actions.RollbackAction;
import net.sourceforge.sqlexplorer.plugin.views.ConnectionsView;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.actions.ActionGroup;

public class ConnectionTreeActionGroup
extends ActionGroup {
    private AbstractConnectionTreeAction _changeAliasAction;
    private AbstractConnectionTreeAction _copyAliasAction;
    private AbstractConnectionTreeAction _deleteAliasAction;
    private AbstractConnectionTreeAction _connectAliasAction;
    private AbstractConnectionTreeAction _newAliasAction;
    private AbstractConnectionTreeAction _newEditorAction;
    private AbstractConnectionTreeAction _closeAllConnectionsAction;
    private AbstractConnectionTreeAction _closeConnectionAction;
    private AbstractConnectionTreeAction _commitAction;
    private AbstractConnectionTreeAction _rollBackAction;
    private TreeViewer _treeViewer;

    public ConnectionTreeActionGroup(ConnectionsView view, TreeViewer treeViewer) {
        this._treeViewer = treeViewer;
        this._newAliasAction = new NewAliasAction();
        this._changeAliasAction = new ChangeAliasAction();
        this._copyAliasAction = new CopyAliasAction();
        this._deleteAliasAction = new DeleteAliasAction();
        this._connectAliasAction = new ConnectAliasAction();
        this._newEditorAction = new NewEditorAction();
        this._closeAllConnectionsAction = new CloseAllConnectionsAction();
        this._closeConnectionAction = new CloseConnectionAction();
        this._commitAction = new CommitAction();
        this._rollBackAction = new RollbackAction();
        this._newAliasAction.setTreeViewer(this._treeViewer);
        this._changeAliasAction.setTreeViewer(this._treeViewer);
        this._copyAliasAction.setTreeViewer(this._treeViewer);
        this._deleteAliasAction.setTreeViewer(this._treeViewer);
        this._connectAliasAction.setTreeViewer(this._treeViewer);
        this._newEditorAction.setTreeViewer(this._treeViewer);
        this._closeAllConnectionsAction.setTreeViewer(this._treeViewer);
        this._closeConnectionAction.setTreeViewer(this._treeViewer);
        this._commitAction.setTreeViewer(this._treeViewer);
        this._rollBackAction.setTreeViewer(this._treeViewer);
        this._newAliasAction.setView(view);
        this._changeAliasAction.setView(view);
        this._copyAliasAction.setView(view);
        this._deleteAliasAction.setView(view);
        this._connectAliasAction.setView(view);
        this._newEditorAction.setView(view);
        this._closeAllConnectionsAction.setView(view);
        this._closeConnectionAction.setView(view);
        this._commitAction.setView(view);
        this._rollBackAction.setView(view);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this._treeViewer.getSelection();
        if (selection == null) {
            this.addGenericActions(menu);
            return;
        }
        if (this._newEditorAction.isAvailable()) {
            menu.add((IAction)this._newEditorAction);
            menu.add((IContributionItem)new Separator());
        }
        if (selection.getFirstElement() instanceof ISQLAlias) {
            this.addAliasActions(menu);
            menu.add((IContributionItem)new Separator());
            this.addSessionActions(menu);
            menu.add((IContributionItem)new Separator());
        } else {
            this.addSessionActions(menu);
            menu.add((IContributionItem)new Separator());
            this.addAliasActions(menu);
            menu.add((IContributionItem)new Separator());
        }
        this.addGenericActions(menu);
    }

    private void addGenericActions(IMenuManager menu) {
        menu.add((IAction)this._newAliasAction);
    }

    private void addSessionActions(IMenuManager menu) {
        if (this._closeConnectionAction.isAvailable()) {
            menu.add((IAction)this._closeConnectionAction);
        }
        if (this._closeAllConnectionsAction.isAvailable()) {
            menu.add((IAction)this._closeAllConnectionsAction);
        }
        if (this._commitAction.isAvailable()) {
            menu.add((IAction)this._commitAction);
        }
        if (this._rollBackAction.isAvailable()) {
            menu.add((IAction)this._rollBackAction);
        }
    }

    private void addAliasActions(IMenuManager menu) {
        if (this._connectAliasAction.isAvailable()) {
            menu.add((IAction)this._connectAliasAction);
        }
        if (this._changeAliasAction.isAvailable()) {
            menu.add((IAction)this._changeAliasAction);
        }
        if (this._copyAliasAction.isAvailable()) {
            menu.add((IAction)this._copyAliasAction);
        }
        if (this._deleteAliasAction.isAvailable()) {
            menu.add((IAction)this._deleteAliasAction);
        }
    }
}

