/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections.actions;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.connections.actions.AbstractConnectionTreeAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.ConnectionsView;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class CloseAllConnectionsAction
extends AbstractConnectionTreeAction
implements IViewActionDelegate {
    private ImageDescriptor _image = ImageUtil.getDescriptor("Images.CloseAllConnsIcon");
    private ImageDescriptor _disabledImage = ImageUtil.getDescriptor("Images.DisabledCloseAllConnsIcon");

    public void init(IViewPart view) {
        this._treeViewer = ((ConnectionsView)view).getTreeViewer();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.isAvailable());
    }

    public String getText() {
        return Messages.getString("ConnectionsView.Actions.CloseAllConnections");
    }

    public String getToolTipText() {
        return Messages.getString("ConnectionsView.Actions.CloseAllConnectionsToolTip");
    }

    public void run() {
        RootSessionTreeNode sessionRoot = SQLExplorerPlugin.getDefault().stm.getRoot();
        sessionRoot.closeAllConnections();
        this.setEnabled(false);
        this._treeViewer.refresh();
    }

    public ImageDescriptor getImageDescriptor() {
        return this._image;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return this._disabledImage;
    }

    public boolean isAvailable() {
        RootSessionTreeNode sessionRoot = SQLExplorerPlugin.getDefault().stm.getRoot();
        Object[] sessions = sessionRoot.getChildren();
        return sessions != null && sessions.length != 0;
    }
}

