/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections.actions;

import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.connections.actions.AbstractConnectionTreeAction;
import net.sourceforge.sqlexplorer.dialogs.CreateAliasDlg;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class CopyAliasAction
extends AbstractConnectionTreeAction {
    ImageDescriptor _image = ImageUtil.getDescriptor("Images.CopyAlias");

    public String getToolTipText() {
        return Messages.getString("ConnectionsView.Actions.CopyAliasToolTip");
    }

    public String getText() {
        return Messages.getString("ConnectionsView.Actions.CopyAlias");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this._image;
    }

    public ImageDescriptor getImageDescriptor() {
        return this._image;
    }

    public void run() {
        StructuredSelection sel = (StructuredSelection)this._treeViewer.getSelection();
        if (!(sel.getFirstElement() instanceof ISQLAlias)) {
            return;
        }
        SQLAlias al = (SQLAlias)sel.getFirstElement();
        IdentifierFactory factory = IdentifierFactory.getInstance();
        DriverModel driverModel = SQLExplorerPlugin.getDefault().getDriverModel();
        AliasModel aliasModel = SQLExplorerPlugin.getDefault().getAliasModel();
        SQLAlias alias = aliasModel.createAlias(factory.createIdentifier());
        if (al != null) {
            try {
                alias.assignFrom(al);
            }
            catch (ValidationException validationException) {}
            CreateAliasDlg dlg = new CreateAliasDlg(Display.getCurrent().getActiveShell(), driverModel, 3, alias, aliasModel);
            dlg.open();
            this._treeViewer.refresh();
        }
    }

    public boolean isAvailable() {
        StructuredSelection sel = (StructuredSelection)this._treeViewer.getSelection();
        if (sel.size() != 1) {
            return false;
        }
        return sel.getFirstElement() instanceof ISQLAlias;
    }
}

